/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.hierarchy;

import com.projity.grouping.core.Node;
import com.projity.grouping.core.event.HierarchyEvent;
import com.projity.grouping.core.event.HierarchyListener;
import com.projity.grouping.core.hierarchy.AbstractMutableNodeHierarchy;
import com.projity.grouping.core.hierarchy.NodeHierarchy;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.transform.filtering.NodeFilter;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class FilteredNodeHierarchy
extends AbstractMutableNodeHierarchy
implements HierarchyListener {
    protected NodeHierarchy hierarchy;
    protected NodeFilter filter;

    public FilteredNodeHierarchy(NodeHierarchy nodeHierarchy) {
        this.hierarchy = nodeHierarchy;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public void setFilter(NodeFilter nodeFilter) {
        this.filter = nodeFilter;
        this.fireStructureChanged(this);
    }

    public NodeHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(NodeHierarchy nodeHierarchy) {
        this.hierarchy = nodeHierarchy;
        this.fireStructureChanged(this);
    }

    public void add(Node node, List list, int n, int n2) {
        this.hierarchy.add(node, list, n, n2);
    }

    public void paste(Node node, List list, int n, NodeModel nodeModel, int n2) {
        this.hierarchy.paste(node, list, n, nodeModel, n2);
    }

    public void cleanVoidChildren() {
        this.hierarchy.cleanVoidChildren();
    }

    public void checkEndVoidNodes(int n) {
        this.hierarchy.checkEndVoidNodes(n);
    }

    public void checkEndVoidNodes(boolean bl, int n) {
        this.hierarchy.checkEndVoidNodes(bl, n);
    }

    public int getLevel(Node node) {
        return this.hierarchy.getLevel(node);
    }

    public Object getRoot() {
        return this.hierarchy.getRoot();
    }

    public void indent(List list, int n, NodeModel nodeModel, int n2) {
        this.hierarchy.indent(list, n, nodeModel, n2);
    }

    public boolean isLeaf(Object object) {
        return this.hierarchy.isLeaf(object);
    }

    public boolean isSummary(Node node) {
        return this.hierarchy.isSummary(node);
    }

    public void remove(List list, NodeModel nodeModel, int n, boolean bl) {
        this.hierarchy.remove(list, nodeModel, n, bl);
    }

    public void move(Node node, Node node2, int n) {
        this.hierarchy.move(node, node2, n);
    }

    public void setNbEndVoidNodes(int n) {
        this.hierarchy.setNbEndVoidNodes(n);
    }

    public int getNbEndVoidNodes() {
        return this.hierarchy.getNbEndVoidNodes();
    }

    public Node getParent(Node node) {
        return this.hierarchy.getParent(node);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        this.hierarchy.valueForPathChanged(treePath, object);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.hierarchy.addTreeModelListener(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.hierarchy.removeTreeModelListener(treeModelListener);
    }

    public void removeAll(NodeModel nodeModel, int n) {
        this.hierarchy.removeAll(nodeModel, n);
    }

    public List getChildren(Node node) {
        return this.filter.filterList(this.hierarchy.getChildren(node));
    }

    public Node search(Object object, Comparator comparator) {
        Node node = this.hierarchy.search(object, comparator);
        if (node == null) {
            return null;
        }
        return this.filter.evaluate(node) ? node : null;
    }

    public Object clone() {
        FilteredNodeHierarchy filteredNodeHierarchy = new FilteredNodeHierarchy(this.hierarchy);
        filteredNodeHierarchy.setFilter(this.filter);
        return filteredNodeHierarchy;
    }

    public void nodesChanged(HierarchyEvent hierarchyEvent) {
        Object[] objectArray = this.filter.filterArray(hierarchyEvent.getNodes());
        this.fireNodesChanged(hierarchyEvent.getSource(), objectArray, hierarchyEvent.getNodes(), hierarchyEvent.getFlag());
    }

    public void nodesInserted(HierarchyEvent hierarchyEvent) {
        Object[] objectArray = this.filter.filterArray(hierarchyEvent.getNodes());
        this.fireNodesInserted(hierarchyEvent.getSource(), objectArray, hierarchyEvent.getNodes(), hierarchyEvent.getFlag());
    }

    public void nodesRemoved(HierarchyEvent hierarchyEvent) {
        Object[] objectArray = this.filter.filterArray(hierarchyEvent.getNodes());
        this.fireNodesRemoved(hierarchyEvent.getSource(), objectArray, hierarchyEvent.getNodes(), hierarchyEvent.getFlag());
    }

    public void structureChanged(HierarchyEvent hierarchyEvent) {
        Object[] objectArray = this.filter.filterArray(hierarchyEvent.getNodes());
        this.fireStructureChanged(hierarchyEvent.getSource());
    }

    public void fireUpdate() {
        this.hierarchy.fireUpdate();
    }

    public void fireUpdate(Node[] nodeArray) {
        this.hierarchy.fireUpdate(nodeArray);
    }

    public void fireInsertion(Node[] nodeArray) {
        this.hierarchy.fireInsertion(nodeArray);
    }

    public void fireRemoval(Node[] nodeArray) {
        this.hierarchy.fireRemoval(nodeArray);
    }
}

