/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment media rendering library
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author(s): Loïc Molinari <loic@fluendo.com>
 *            Julien Moutte <julien@fluendo.com>
 */

#ifndef __HAVE_PGM_H__
#define __HAVE_PGM_H__

#include "pgmversion.h"
#include "pgmviewport.h"
#include "pgmcanvas.h"
#include "pgmimage.h"
#include "pgmtext.h"
#include "pgmevents.h"
#include "pgmplugin.h"
#include "pgmlinearalgebra.h"
#include "pgmimagesink.h"
#include "pgmenumtypes.h"
#include "pgmkeysyms.h"

G_BEGIN_DECLS

void     pgm_init              (int *argc,
                                char **argv[]);

gboolean pgm_init_check        (int *argc,
                                char **argv[]);

void     pgm_deinit            (void);

void     pgm_version           (guint *major,
                                guint *minor,
                                guint *micro,
                                guint *nano);

gchar   *pgm_version_string    (void);

gboolean pgm_events_pending    (void);

void     pgm_main              (void);

void     pgm_main_quit         (void);

void     pgm_main_iteration    (void);

void     pgm_main_iteration_do (gboolean blocking);

G_END_DECLS

#endif /* __HAVE_PGM_H__ */
