/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.postgresql.core.JdbcCallParseInfo;
import org.postgresql.core.NativeQuery;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Parser {
    private static final int[] NO_BINDS = new int[0];

    public static List<NativeQuery> parseJdbcSql(String query, boolean standardConformingStrings, boolean withParameters, boolean splitStatements) {
        if (!withParameters && !splitStatements) {
            return Collections.singletonList(new NativeQuery(query));
        }
        int fragmentStart = 0;
        int inParen = 0;
        char[] aChars = query.toCharArray();
        StringBuilder nativeSql = new StringBuilder(query.length() + 10);
        ArrayList<Integer> bindPositions = null;
        List<NativeQuery> nativeQueries = null;
        block11: for (int i = 0; i < aChars.length; ++i) {
            switch (aChars[i]) {
                case '\'': {
                    i = Parser.parseSingleQuotes(aChars, i, standardConformingStrings);
                    continue block11;
                }
                case '\"': {
                    i = Parser.parseDoubleQuotes(aChars, i);
                    continue block11;
                }
                case '-': {
                    i = Parser.parseLineComment(aChars, i);
                    continue block11;
                }
                case '/': {
                    i = Parser.parseBlockComment(aChars, i);
                    continue block11;
                }
                case '$': {
                    i = Parser.parseDollarQuotes(aChars, i);
                    continue block11;
                }
                case '(': {
                    ++inParen;
                    continue block11;
                }
                case ')': {
                    --inParen;
                    continue block11;
                }
                case '?': {
                    nativeSql.append(aChars, fragmentStart, i - fragmentStart);
                    if (i + 1 < aChars.length && aChars[i + 1] == '?') {
                        nativeSql.append('?');
                        ++i;
                    } else {
                        if (bindPositions == null) {
                            bindPositions = new ArrayList<Integer>();
                        }
                        bindPositions.add(nativeSql.length());
                        int bindIndex = bindPositions.size();
                        nativeSql.append(NativeQuery.bindName(bindIndex));
                    }
                    fragmentStart = i + 1;
                    continue block11;
                }
                case ';': {
                    if (inParen != 0 || !splitStatements) continue block11;
                    nativeSql.append(aChars, fragmentStart, i - fragmentStart);
                    fragmentStart = i + 1;
                    if (nativeSql.length() > 0) {
                        if (nativeQueries == null) {
                            nativeQueries = new ArrayList<NativeQuery>();
                        }
                        nativeQueries.add(new NativeQuery(nativeSql.toString(), Parser.toIntArray(bindPositions)));
                    }
                    if (bindPositions != null) {
                        bindPositions.clear();
                    }
                    nativeSql.setLength(0);
                    continue block11;
                }
            }
        }
        if (fragmentStart < aChars.length) {
            nativeSql.append(aChars, fragmentStart, aChars.length - fragmentStart);
        }
        if (nativeSql.length() == 0) {
            return nativeQueries != null ? nativeQueries : Collections.emptyList();
        }
        NativeQuery lastQuery = new NativeQuery(nativeSql.toString(), Parser.toIntArray(bindPositions));
        if (nativeQueries == null) {
            return Collections.singletonList(lastQuery);
        }
        nativeQueries.add(lastQuery);
        return nativeQueries;
    }

    private static int[] toIntArray(List<Integer> list) {
        if (list == null || list.isEmpty()) {
            return NO_BINDS;
        }
        int[] res = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = list.get(i);
        }
        return res;
    }

    public static int parseSingleQuotes(char[] query, int offset, boolean standardConformingStrings) {
        if (standardConformingStrings && offset >= 2 && (query[offset - 1] == 'e' || query[offset - 1] == 'E') && Parser.charTerminatesIdentifier(query[offset - 2])) {
            standardConformingStrings = false;
        }
        if (standardConformingStrings) {
            while (++offset < query.length) {
                switch (query[offset]) {
                    case '\'': {
                        return offset;
                    }
                }
            }
        } else {
            block8: while (++offset < query.length) {
                switch (query[offset]) {
                    case '\\': {
                        ++offset;
                        continue block8;
                    }
                    case '\'': {
                        return offset;
                    }
                }
            }
        }
        return query.length;
    }

    public static int parseDoubleQuotes(char[] query, int offset) {
        while (++offset < query.length && query[offset] != '\"') {
        }
        return offset;
    }

    public static int parseDollarQuotes(char[] query, int offset) {
        if (!(offset + 1 >= query.length || offset != 0 && Parser.isIdentifierContChar(query[offset - 1]))) {
            int endIdx = -1;
            if (query[offset + 1] == '$') {
                endIdx = offset + 1;
            } else if (Parser.isDollarQuoteStartChar(query[offset + 1])) {
                for (int d = offset + 2; d < query.length; ++d) {
                    if (query[d] == '$') {
                        endIdx = d;
                        break;
                    }
                    if (!Parser.isDollarQuoteContChar(query[d])) break;
                }
            }
            if (endIdx > 0) {
                int tagIdx = offset;
                int tagLen = endIdx - offset + 1;
                offset = endIdx;
                ++offset;
                while (offset < query.length) {
                    if (query[offset] == '$' && Parser.subArraysEqual(query, tagIdx, offset, tagLen)) {
                        offset += tagLen - 1;
                        break;
                    }
                    ++offset;
                }
            }
        }
        return offset;
    }

    public static int parseLineComment(char[] query, int offset) {
        block1: {
            if (offset + 1 >= query.length || query[offset + 1] != '-') break block1;
            while (offset + 1 < query.length && query[++offset] != '\r' && query[offset] != '\n') {
            }
        }
        return offset;
    }

    public static int parseBlockComment(char[] query, int offset) {
        if (offset + 1 < query.length && query[offset + 1] == '*') {
            int level = 1;
            offset += 2;
            while (offset < query.length) {
                switch (query[offset - 1]) {
                    case '*': {
                        if (query[offset] != '/') break;
                        --level;
                        ++offset;
                        break;
                    }
                    case '/': {
                        if (query[offset] != '*') break;
                        ++level;
                        ++offset;
                        break;
                    }
                }
                if (level == 0) {
                    --offset;
                    break;
                }
                ++offset;
            }
        }
        return offset;
    }

    public static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f';
    }

    public static boolean isOperatorChar(char c) {
        return ",()[].;:+-*/%^<>=~!@#&|`?".indexOf(c) != -1;
    }

    public static boolean isIdentifierStartChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u007f';
    }

    public static boolean isIdentifierContChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u007f' || c >= '0' && c <= '9' || c == '$';
    }

    public static boolean charTerminatesIdentifier(char c) {
        return c == '\"' || Parser.isSpace(c) || Parser.isOperatorChar(c);
    }

    public static boolean isDollarQuoteStartChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u007f';
    }

    public static boolean isDollarQuoteContChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u007f' || c >= '0' && c <= '9';
    }

    private static boolean subArraysEqual(char[] arr, int offA, int offB, int len) {
        if (offA < 0 || offB < 0 || offA >= arr.length || offB >= arr.length || offA + len > arr.length || offB + len > arr.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (arr[offA + i] == arr[offB + i]) continue;
            return false;
        }
        return true;
    }

    public static JdbcCallParseInfo modifyJdbcCall(String jdbcSql, boolean stdStrings, int serverVersion, int protocolVersion) throws SQLException {
        String sql = jdbcSql;
        boolean isFunction = false;
        boolean outParmBeforeFunc = false;
        int len = jdbcSql.length();
        int state = 1;
        boolean inQuotes = false;
        boolean inEscape = false;
        int startIndex = -1;
        int endIndex = -1;
        boolean syntaxError = false;
        int i = 0;
        block10: while (i < len && !syntaxError) {
            char ch = jdbcSql.charAt(i);
            switch (state) {
                case 1: {
                    if (ch == '{') {
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    i = len;
                    continue block10;
                }
                case 2: {
                    if (ch == '?') {
                        isFunction = true;
                        outParmBeforeFunc = true;
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (ch == 'c' || ch == 'C') {
                        state += 3;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 3: {
                    if (ch == '=') {
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 4: {
                    if (ch == 'c' || ch == 'C') {
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 5: {
                    if ((ch == 'c' || ch == 'C') && i + 4 <= len && jdbcSql.substring(i, i + 4).equalsIgnoreCase("call")) {
                        isFunction = true;
                        i += 4;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 6: {
                    if (Character.isWhitespace(ch)) {
                        ++state;
                        startIndex = ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 7: {
                    if (ch == '\'') {
                        inQuotes = !inQuotes;
                        ++i;
                        continue block10;
                    }
                    if (inQuotes && ch == '\\' && !stdStrings) {
                        i += 2;
                        continue block10;
                    }
                    if (!inQuotes && ch == '{') {
                        inEscape = !inEscape;
                        ++i;
                        continue block10;
                    }
                    if (!inQuotes && ch == '}') {
                        if (!inEscape) {
                            endIndex = i++;
                            ++state;
                            continue block10;
                        }
                        inEscape = false;
                        continue block10;
                    }
                    if (!inQuotes && ch == ';') {
                        syntaxError = true;
                        continue block10;
                    }
                    ++i;
                    continue block10;
                }
                case 8: {
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
            }
            throw new IllegalStateException("somehow got into bad state " + state);
        }
        if (i == len && !syntaxError) {
            if (state == 1) {
                return new JdbcCallParseInfo(sql, isFunction, outParmBeforeFunc);
            }
            if (state != 8) {
                syntaxError = true;
            }
        }
        if (syntaxError) {
            throw new PSQLException(GT.tr("Malformed function or procedure escape syntax at offset {0}.", i), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (serverVersion < 80100 || protocolVersion != 3) {
            sql = "select " + jdbcSql.substring(startIndex, endIndex) + " as result";
            return new JdbcCallParseInfo(sql, isFunction, outParmBeforeFunc);
        }
        String s = jdbcSql.substring(startIndex, endIndex);
        StringBuilder sb = new StringBuilder(s);
        if (outParmBeforeFunc) {
            boolean needComma = false;
            int opening = s.indexOf(40) + 1;
            int closing = s.indexOf(41);
            for (int j = opening; j < closing; ++j) {
                if (Character.isWhitespace(sb.charAt(j))) continue;
                needComma = true;
                break;
            }
            if (needComma) {
                sb.insert(opening, "?,");
            } else {
                sb.insert(opening, "?");
            }
        }
        sql = "select * from " + sb.toString() + " as result";
        return new JdbcCallParseInfo(sql, isFunction, outParmBeforeFunc);
    }
}

