/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBox;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.SyntaxColoringPanel;
import org.netbeans.modules.options.colors.spi.FontsColorsController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AnnotationsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
FontsColorsController {
    private ColorModel colorModel;
    private boolean listen = false;
    private String currentScheme;
    private Map<String, Vector<AttributeSet>> schemes = new HashMap<String, Vector<AttributeSet>>();
    private Set<String> toBeSaved = new HashSet<String>();
    private boolean changed = false;
    private JComboBox cbBackground;
    private JComboBox cbForeground;
    private JComboBox cbWaveUnderlined;
    private JScrollPane cpCategories;
    private JList lCategories;
    private JLabel lCategory;
    private JLabel lForeground;
    private JLabel lWaveUnderlined;
    private JLabel lbackground;

    public AnnotationsPanel() {
        this.initComponents();
        this.setName(AnnotationsPanel.loc("Annotations_tab"));
        this.cbForeground.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Foreground_Chooser"));
        this.cbForeground.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Foreground_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Background_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Background_Chooser"));
        this.cbWaveUnderlined.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Wave_Underlined"));
        this.cbWaveUnderlined.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Wave_Underlined"));
        this.lCategories.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Categories"));
        ColorComboBox.init(this.cbForeground);
        ColorComboBox.init(this.cbBackground);
        ColorComboBox.init(this.cbWaveUnderlined);
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!AnnotationsPanel.this.listen) {
                    return;
                }
                AnnotationsPanel.this.refreshUI();
            }
        });
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.cbForeground.addPropertyChangeListener(this);
        ((JComponent)((Object)this.cbForeground.getEditor())).addPropertyChangeListener(this);
        this.cbBackground.addPropertyChangeListener(this);
        ((JComponent)((Object)this.cbBackground.getEditor())).addPropertyChangeListener(this);
        this.cbWaveUnderlined.addPropertyChangeListener(this);
        ((JComponent)((Object)this.cbWaveUnderlined.getEditor())).addPropertyChangeListener(this);
        this.lCategory.setLabelFor(this.lCategories);
        AnnotationsPanel.loc(this.lCategory, "CTL_Category");
        AnnotationsPanel.loc(this.lForeground, "CTL_Foreground_label");
        AnnotationsPanel.loc(this.lWaveUnderlined, "CTL_Wave_underlined_label");
        AnnotationsPanel.loc(this.lbackground, "CTL_Background_label");
    }

    private void initComponents() {
        this.lCategory = new JLabel();
        this.cpCategories = new JScrollPane();
        this.lCategories = new JList();
        this.lForeground = new JLabel();
        this.lbackground = new JLabel();
        this.lWaveUnderlined = new JLabel();
        this.cbForeground = new JComboBox();
        this.cbBackground = new JComboBox();
        this.cbWaveUnderlined = new JComboBox();
        this.lCategory.setText("Category:");
        this.cpCategories.setViewportView(this.lCategories);
        this.lForeground.setText("Foreground:");
        this.lbackground.setText("Background:");
        this.lWaveUnderlined.setText("Wave Underlined:");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cpCategories, -1, 212, Short.MAX_VALUE).add(20, 20, 20).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lbackground).add((Component)this.lWaveUnderlined).add((Component)this.lForeground)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.cbForeground, 0, 71, Short.MAX_VALUE).add((Component)this.cbBackground, 0, 71, Short.MAX_VALUE).add((Component)this.cbWaveUnderlined, 0, 71, Short.MAX_VALUE))).add((Component)this.lCategory)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lCategory).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lForeground).add((Component)this.cbForeground, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lbackground).add((Component)this.cbBackground, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lWaveUnderlined).add((Component)this.cbWaveUnderlined, -2, -1, -2))).add((Component)this.cpCategories, -1, 258, Short.MAX_VALUE)).addContainerGap()));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!this.listen) {
            return;
        }
        this.updateData();
        this.changed = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.listen) {
            return;
        }
        if (evt.getPropertyName() != "color") {
            return;
        }
        this.updateData();
    }

    @Override
    public void update(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.listen = false;
        this.currentScheme = colorModel.getCurrentProfile();
        this.lCategories.setListData(this.getAnnotations(this.currentScheme));
        if (this.lCategories.getModel().getSize() > 0) {
            this.lCategories.setSelectedIndex(0);
        }
        this.refreshUI();
        this.listen = true;
        this.changed = false;
    }

    @Override
    public void cancel() {
        this.toBeSaved = new HashSet<String>();
        this.schemes = new HashMap<String, Vector<AttributeSet>>();
        this.changed = false;
    }

    @Override
    public void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        for (String scheme : this.toBeSaved) {
            this.colorModel.setAnnotations(scheme, this.getAnnotations(scheme));
        }
        this.toBeSaved = new HashSet<String>();
        this.schemes = new HashMap<String, Vector<AttributeSet>>();
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setCurrentProfile(String currentScheme) {
        String oldScheme = this.currentScheme;
        this.currentScheme = currentScheme;
        Vector<AttributeSet> v = this.getAnnotations(currentScheme);
        if (v == null) {
            v = this.getAnnotations(oldScheme);
            this.schemes.put(currentScheme, new Vector<AttributeSet>(v));
            this.toBeSaved.add(currentScheme);
            v = this.getAnnotations(currentScheme);
        }
        this.lCategories.setListData(v);
        if (this.lCategories.getModel().getSize() > 0) {
            this.lCategories.setSelectedIndex(0);
        }
        this.refreshUI();
    }

    @Override
    public void deleteProfile(String scheme) {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private static String loc(String key) {
        return NbBundle.getMessage(SyntaxColoringPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)AnnotationsPanel.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)AnnotationsPanel.loc(key));
        }
    }

    private void updateData() {
        Vector<AttributeSet> annotations = this.getAnnotations(this.currentScheme);
        SimpleAttributeSet c = (SimpleAttributeSet)annotations.get(this.lCategories.getSelectedIndex());
        Color color = ColorComboBox.getColor(this.cbBackground);
        if (color != null) {
            c.addAttribute(StyleConstants.Background, color);
        } else {
            c.removeAttribute(StyleConstants.Background);
        }
        color = ColorComboBox.getColor(this.cbForeground);
        if (color != null) {
            c.addAttribute(StyleConstants.Foreground, color);
        } else {
            c.removeAttribute(StyleConstants.Foreground);
        }
        color = ColorComboBox.getColor(this.cbWaveUnderlined);
        if (color != null) {
            c.addAttribute(EditorStyleConstants.WaveUnderlineColor, color);
        } else {
            c.removeAttribute(EditorStyleConstants.WaveUnderlineColor);
        }
        this.toBeSaved.add(this.currentScheme);
    }

    private void refreshUI() {
        int index = this.lCategories.getSelectedIndex();
        if (index < 0) {
            this.cbForeground.setEnabled(false);
            this.cbBackground.setEnabled(false);
            this.cbWaveUnderlined.setEnabled(false);
            return;
        }
        this.cbForeground.setEnabled(true);
        this.cbBackground.setEnabled(true);
        this.cbWaveUnderlined.setEnabled(true);
        this.listen = false;
        AttributeSet defAs = this.getDefaultColoring();
        if (defAs != null) {
            Color inheritedForeground = (Color)defAs.getAttribute(StyleConstants.Foreground);
            if (inheritedForeground == null) {
                inheritedForeground = Color.black;
            }
            ColorComboBox.setInheritedColor(this.cbForeground, inheritedForeground);
            Color inheritedBackground = (Color)defAs.getAttribute(StyleConstants.Background);
            if (inheritedBackground == null) {
                inheritedBackground = Color.white;
            }
            ColorComboBox.setInheritedColor(this.cbBackground, inheritedBackground);
        }
        Vector<AttributeSet> annotations = this.getAnnotations(this.currentScheme);
        AttributeSet c = annotations.get(index);
        ColorComboBox.setColor(this.cbForeground, (Color)c.getAttribute(StyleConstants.Foreground));
        ColorComboBox.setColor(this.cbBackground, (Color)c.getAttribute(StyleConstants.Background));
        ColorComboBox.setColor(this.cbWaveUnderlined, (Color)c.getAttribute(EditorStyleConstants.WaveUnderlineColor));
        this.listen = true;
    }

    private AttributeSet getDefaultColoring() {
        Collection<AttributeSet> defaults = this.colorModel.getCategories(this.currentScheme, ColorModel.ALL_LANGUAGES);
        for (AttributeSet as : defaults) {
            String name = (String)as.getAttribute(StyleConstants.NameAttribute);
            if (name == null || !"default".equals(name)) continue;
            return as;
        }
        return null;
    }

    private Vector<AttributeSet> getAnnotations(String scheme) {
        if (!this.schemes.containsKey(scheme)) {
            Collection<AttributeSet> c = this.colorModel.getAnnotations(this.currentScheme);
            if (c == null) {
                return null;
            }
            ArrayList<AttributeSet> l = new ArrayList<AttributeSet>(c);
            Collections.sort(l, new CategoryComparator());
            this.schemes.put(scheme, new Vector<AttributeSet>(l));
        }
        return this.schemes.get(scheme);
    }
}

