/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import javax.swing.JPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.netbeans.modules.apisupport.project.ui.wizard.NewNbModuleWizardIterator;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public abstract class BasicVisualPanel
extends JPanel {
    private WizardDescriptor settings;

    protected BasicVisualPanel(WizardDescriptor setting) {
        this.settings = setting;
    }

    public final WizardDescriptor getSettings() {
        return this.settings;
    }

    protected final void setError(String message) {
        if (message == null) {
            throw new NullPointerException();
        }
        this.setMessage(message);
        this.setValid(false);
    }

    protected final void setWarning(String message) {
        this.setWarning(message, true);
    }

    protected final void setWarning(String message, boolean valid) {
        if (message == null) {
            throw new NullPointerException();
        }
        this.settings.putProperty("WizardPanel_warningMessage", (Object)message);
        this.setValid(valid);
    }

    protected final void setInfo(String message, boolean valid) {
        if (message == null) {
            throw new NullPointerException();
        }
        this.settings.putProperty("WizardPanel_infoMessage", (Object)message);
        this.setValid(valid);
    }

    protected final void markInvalid() {
        this.setMessage(null);
        this.setValid(false);
    }

    protected final void markValid() {
        this.setMessage(null);
        this.setValid(true);
    }

    private final void setMessage(String message) {
        this.settings.putProperty("WizardPanel_errorMessage", (Object)message);
    }

    private final void setValid(boolean valid) {
        this.firePropertyChange("valid", null, (Object)valid);
    }

    protected static abstract class NewTemplatePanel
    extends BasicVisualPanel {
        private final NewModuleProjectData data;

        NewTemplatePanel(NewModuleProjectData data) {
            super(data.getSettings());
            String resource;
            this.data = data;
            switch (data.getWizardType()) {
                case SUITE: {
                    resource = "emptySuite";
                    break;
                }
                case APPLICATION: {
                    resource = "emptyApplication";
                    break;
                }
                case MODULE: 
                case SUITE_COMPONENT: {
                    resource = "emptyModule";
                    break;
                }
                case LIBRARY_MODULE: {
                    resource = "libraryModule";
                    break;
                }
                default: {
                    assert (false) : "Unknown wizard type = " + (Object)((Object)data.getWizardType());
                    resource = "";
                }
            }
            data.getSettings().putProperty("NewProjectWizard_Title", (Object)NbBundle.getMessage(BasicVisualPanel.class, (String)("Templates/Project/APISupport/" + resource)));
        }

        protected NewModuleProjectData getData() {
            return this.data;
        }

        protected boolean isSuiteWizard() {
            return NewNbModuleWizardIterator.isSuiteWizard(this.getData().getWizardType());
        }

        protected boolean isSuiteComponentWizard() {
            return NewNbModuleWizardIterator.isSuiteComponentWizard(this.getData().getWizardType());
        }

        protected boolean isLibraryWizard() {
            return NewNbModuleWizardIterator.isLibraryWizard(this.getData().getWizardType());
        }
    }
}

