/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionParameterList;
import org.netbeans.modules.cnd.api.model.CsmInitializerListContainer;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;

public class CsmOffsetUtilities {
    private CsmOffsetUtilities() {
    }

    public static boolean isInObject(CsmObject obj, int offset) {
        if (!CsmKindUtilities.isOffsetable((Object)obj)) {
            return false;
        }
        CsmOffsetable offs = (CsmOffsetable)obj;
        if (offs.getStartOffset() <= offset && offset <= offs.getEndOffset()) {
            if (offset == offs.getEndOffset()) {
                if (CsmKindUtilities.isType((CsmObject)obj)) {
                    CsmType type = (CsmType)obj;
                    return !type.isPointer() && !type.isReference() && type.getArrayDepth() == 0;
                }
                if (CsmOffsetUtilities.endsWithBrace(offs)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isInObject(CsmObject outerObj, CsmObject innerObj) {
        if (!CsmKindUtilities.isOffsetable((Object)outerObj) || !CsmKindUtilities.isOffsetable((Object)innerObj)) {
            return false;
        }
        CsmOffsetable outer = (CsmOffsetable)outerObj;
        CsmOffsetable inner = (CsmOffsetable)innerObj;
        return outer.getContainingFile().equals(inner.getContainingFile()) && outer.getStartOffset() <= inner.getStartOffset() && inner.getEndOffset() <= outer.getEndOffset();
    }

    private static boolean endsWithBrace(CsmOffsetable obj) {
        if (!CsmKindUtilities.isScope((CsmObject)obj)) {
            return false;
        }
        if (!CsmKindUtilities.isStatement((CsmObject)obj) || CsmKindUtilities.isCompoundStatement((CsmObject)obj)) {
            return true;
        }
        CsmStatement stmt = (CsmStatement)obj;
        switch (stmt.getKind()) {
            case IF: {
                CsmStatement elseBranch = ((CsmIfStatement)stmt).getElse();
                if (elseBranch != null) {
                    return CsmKindUtilities.isCompoundStatement((CsmObject)elseBranch);
                }
                return CsmKindUtilities.isCompoundStatement((CsmObject)((CsmIfStatement)stmt).getThen());
            }
            case FOR: 
            case WHILE: {
                return CsmKindUtilities.isCompoundStatement((CsmObject)((CsmLoopStatement)stmt).getBody());
            }
        }
        return false;
    }

    public static boolean isBeforeObject(CsmObject obj, int offset) {
        if (!CsmKindUtilities.isOffsetable((Object)obj)) {
            return false;
        }
        CsmOffsetable offs = (CsmOffsetable)obj;
        return offset < offs.getStartOffset();
    }

    public static boolean isAfterObject(CsmObject obj, int offset) {
        if (!CsmKindUtilities.isOffsetable((Object)obj)) {
            return false;
        }
        CsmOffsetable offs = (CsmOffsetable)obj;
        return offset > offs.getEndOffset();
    }

    public static <T extends CsmObject> T findObject(Collection<T> list, CsmContext context, int offset) {
        assert (list != null) : "expect not null list";
        return CsmOffsetUtilities.findObject(list.iterator(), context, offset);
    }

    public static <T extends CsmObject> T findObject(Iterator<T> it, CsmContext context, int offset) {
        assert (it != null) : "expect not null list";
        while (it.hasNext()) {
            CsmObject obj = (CsmObject)it.next();
            assert (obj != null) : "can't be null declaration";
            if (!CsmOffsetUtilities.isInObject(obj, offset)) continue;
            CsmContextUtilities.updateContextObject(obj, offset, context);
            return (T)obj;
        }
        return null;
    }

    public static boolean isInFunctionScope(CsmFunction fun, int offset) {
        boolean inScope = false;
        if (fun != null) {
            CsmFunctionDefinition funDef;
            Collection izers;
            inScope = true;
            CsmType retType = fun.getReturnType();
            if (CsmOffsetUtilities.isInObject((CsmObject)retType, offset)) {
                return false;
            }
            CsmFunctionParameterList paramList = fun.getParameterList();
            if (paramList != null) {
                if (CsmOffsetUtilities.isInObject((CsmObject)paramList, offset)) {
                    return true;
                }
                Collection params = paramList.getParameters();
                if (!params.isEmpty()) {
                    CsmParameter firstParam = (CsmParameter)params.iterator().next();
                    return !CsmOffsetUtilities.isBeforeObject((CsmObject)firstParam, offset);
                }
            }
            if (CsmKindUtilities.isConstructor((CsmObject)fun) && !(izers = ((CsmInitializerListContainer)fun).getInitializerList()).isEmpty()) {
                CsmExpression firstIzer = (CsmExpression)izers.iterator().next();
                return !CsmOffsetUtilities.isBeforeObject((CsmObject)firstIzer, offset);
            }
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)fun) && CsmOffsetUtilities.isBeforeObject((CsmObject)(funDef = (CsmFunctionDefinition)fun).getBody(), offset)) {
                return false;
            }
            if (CsmKindUtilities.isFunctionDeclaration((CsmObject)fun)) {
                return false;
            }
        }
        return inScope;
    }

    public static boolean isInClassScope(CsmClass clazz, int offset) {
        return CsmOffsetUtilities.isInObject((CsmObject)clazz, offset) && clazz.getLeftBracketOffset() < offset && offset < clazz.getEndOffset();
    }

    public static boolean sameOffsets(CsmObject obj1, CsmObject obj2) {
        if (CsmKindUtilities.isOffsetable((Object)obj1) && CsmKindUtilities.isOffsetable((Object)obj2)) {
            CsmOffsetable ofs1 = (CsmOffsetable)obj1;
            CsmOffsetable ofs2 = (CsmOffsetable)obj2;
            return ofs1.getStartOffset() == ofs2.getStartOffset() && ofs1.getEndOffset() == ofs2.getEndOffset();
        }
        return false;
    }
}

