/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import proguard.util.StringMatcher;

public class VariableStringMatcher
implements StringMatcher {
    private final char[] allowedCharacters;
    private final char[] disallowedCharacters;
    private final int minimumLength;
    private final int maximumLength;
    private final StringMatcher nextMatcher;

    public VariableStringMatcher(char[] cArray, char[] cArray2, int n, int n2, StringMatcher stringMatcher) {
        this.allowedCharacters = cArray;
        this.disallowedCharacters = cArray2;
        this.minimumLength = n;
        this.maximumLength = n2;
        this.nextMatcher = stringMatcher;
    }

    public boolean matches(String string) {
        int n;
        if (string.length() < this.minimumLength) {
            return false;
        }
        for (n = 0; n < this.minimumLength; ++n) {
            if (this.isAllowedCharacter(string.charAt(n))) continue;
            return false;
        }
        n = Math.min(this.maximumLength, string.length());
        for (int i = this.minimumLength; i < n; ++i) {
            if (this.nextMatcher.matches(string.substring(i))) {
                return true;
            }
            if (this.isAllowedCharacter(string.charAt(i))) continue;
            return false;
        }
        return this.nextMatcher.matches(string.substring(n));
    }

    private boolean isAllowedCharacter(char c) {
        if (this.allowedCharacters != null) {
            for (int i = 0; i < this.allowedCharacters.length; ++i) {
                if (this.allowedCharacters[i] != c) continue;
                return true;
            }
            return false;
        }
        if (this.disallowedCharacters != null) {
            for (int i = 0; i < this.disallowedCharacters.length; ++i) {
                if (this.disallowedCharacters[i] != c) continue;
                return false;
            }
        }
        return true;
    }
}

