/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.SpecificIntegerValue;

final class ParticularIntegerValue
extends SpecificIntegerValue {
    private final int value;

    public ParticularIntegerValue(int n) {
        this.value = n;
    }

    public int value() {
        return this.value;
    }

    public IntegerValue negate() {
        return new ParticularIntegerValue(-this.value);
    }

    public IntegerValue convertToByte() {
        byte by = (byte)this.value;
        return by == this.value ? this : new ParticularIntegerValue(by);
    }

    public IntegerValue convertToCharacter() {
        char c = (char)this.value;
        return c == this.value ? this : new ParticularIntegerValue(c);
    }

    public IntegerValue convertToShort() {
        short s = (short)this.value;
        return s == this.value ? this : new ParticularIntegerValue(s);
    }

    public LongValue convertToLong() {
        return new ParticularLongValue(this.value);
    }

    public FloatValue convertToFloat() {
        return new ParticularFloatValue(this.value);
    }

    public DoubleValue convertToDouble() {
        return new ParticularDoubleValue(this.value);
    }

    public IntegerValue generalize(IntegerValue integerValue) {
        return integerValue.generalize(this);
    }

    public IntegerValue add(IntegerValue integerValue) {
        return integerValue.add(this);
    }

    public IntegerValue subtract(IntegerValue integerValue) {
        return integerValue.subtractFrom(this);
    }

    public IntegerValue subtractFrom(IntegerValue integerValue) {
        return integerValue.subtract(this);
    }

    public IntegerValue multiply(IntegerValue integerValue) {
        return integerValue.multiply(this);
    }

    public IntegerValue divide(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.divideOf(this);
    }

    public IntegerValue divideOf(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.divide(this);
    }

    public IntegerValue remainder(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.remainderOf(this);
    }

    public IntegerValue remainderOf(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.remainder(this);
    }

    public IntegerValue shiftLeft(IntegerValue integerValue) {
        return integerValue.shiftLeftOf(this);
    }

    public IntegerValue shiftLeftOf(IntegerValue integerValue) {
        return integerValue.shiftLeft(this);
    }

    public IntegerValue shiftRight(IntegerValue integerValue) {
        return integerValue.shiftRightOf(this);
    }

    public IntegerValue shiftRightOf(IntegerValue integerValue) {
        return integerValue.shiftRight(this);
    }

    public IntegerValue unsignedShiftRight(IntegerValue integerValue) {
        return integerValue.unsignedShiftRightOf(this);
    }

    public IntegerValue unsignedShiftRightOf(IntegerValue integerValue) {
        return integerValue.unsignedShiftRight(this);
    }

    public LongValue shiftLeftOf(LongValue longValue) {
        return longValue.shiftLeft(this);
    }

    public LongValue shiftRightOf(LongValue longValue) {
        return longValue.shiftRight(this);
    }

    public LongValue unsignedShiftRightOf(LongValue longValue) {
        return longValue.unsignedShiftRight(this);
    }

    public IntegerValue and(IntegerValue integerValue) {
        return integerValue.and(this);
    }

    public IntegerValue or(IntegerValue integerValue) {
        return integerValue.or(this);
    }

    public IntegerValue xor(IntegerValue integerValue) {
        return integerValue.xor(this);
    }

    public int equal(IntegerValue integerValue) {
        return integerValue.equal(this);
    }

    public int lessThan(IntegerValue integerValue) {
        return integerValue.greaterThan(this);
    }

    public int lessThanOrEqual(IntegerValue integerValue) {
        return integerValue.greaterThanOrEqual(this);
    }

    public IntegerValue generalize(ParticularIntegerValue particularIntegerValue) {
        return this.generalize((SpecificIntegerValue)particularIntegerValue);
    }

    public IntegerValue add(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value + particularIntegerValue.value);
    }

    public IntegerValue subtract(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value - particularIntegerValue.value);
    }

    public IntegerValue subtractFrom(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(particularIntegerValue.value - this.value);
    }

    public IntegerValue multiply(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value * particularIntegerValue.value);
    }

    public IntegerValue divide(ParticularIntegerValue particularIntegerValue) throws ArithmeticException {
        return new ParticularIntegerValue(this.value / particularIntegerValue.value);
    }

    public IntegerValue divideOf(ParticularIntegerValue particularIntegerValue) throws ArithmeticException {
        return new ParticularIntegerValue(particularIntegerValue.value / this.value);
    }

    public IntegerValue remainder(ParticularIntegerValue particularIntegerValue) throws ArithmeticException {
        return new ParticularIntegerValue(this.value % particularIntegerValue.value);
    }

    public IntegerValue remainderOf(ParticularIntegerValue particularIntegerValue) throws ArithmeticException {
        return new ParticularIntegerValue(particularIntegerValue.value % this.value);
    }

    public IntegerValue shiftLeft(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value << particularIntegerValue.value);
    }

    public IntegerValue shiftRight(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value >> particularIntegerValue.value);
    }

    public IntegerValue unsignedShiftRight(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value >>> particularIntegerValue.value);
    }

    public IntegerValue shiftLeftOf(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(particularIntegerValue.value << this.value);
    }

    public IntegerValue shiftRightOf(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(particularIntegerValue.value >> this.value);
    }

    public IntegerValue unsignedShiftRightOf(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(particularIntegerValue.value >>> this.value);
    }

    public LongValue shiftLeftOf(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(particularLongValue.value() << this.value);
    }

    public LongValue shiftRightOf(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(particularLongValue.value() >> this.value);
    }

    public LongValue unsignedShiftRightOf(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(particularLongValue.value() >>> this.value);
    }

    public IntegerValue and(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value & particularIntegerValue.value);
    }

    public IntegerValue or(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value | particularIntegerValue.value);
    }

    public IntegerValue xor(ParticularIntegerValue particularIntegerValue) {
        return new ParticularIntegerValue(this.value ^ particularIntegerValue.value);
    }

    public int equal(ParticularIntegerValue particularIntegerValue) {
        return this.value == particularIntegerValue.value ? 1 : -1;
    }

    public int lessThan(ParticularIntegerValue particularIntegerValue) {
        return this.value < particularIntegerValue.value ? 1 : -1;
    }

    public int lessThanOrEqual(ParticularIntegerValue particularIntegerValue) {
        return this.value <= particularIntegerValue.value ? 1 : -1;
    }

    public boolean isParticular() {
        return true;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.value == ((ParticularIntegerValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

