/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.navigator.FilterActions;
import org.netbeans.modules.mobility.svgcore.navigator.FiltersDescription;
import org.netbeans.modules.mobility.svgcore.navigator.FiltersManager;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorNode;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorTree;
import org.netbeans.modules.mobility.svgcore.navigator.TapPanel;
import org.netbeans.modules.mobility.svgcore.view.source.SVGSourceMultiViewElement;
import org.netbeans.modules.mobility.svgcore.view.svg.AnimationCookie;
import org.netbeans.modules.mobility.svgcore.view.svg.SelectionCookie;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class SVGNavigatorContent
extends JPanel
implements SceneManager.SelectionListener {
    public static final String ATTRIBUTES_FILTER = "attrs";
    public static final String ID_FILTER = "id";
    public static final String ANIMATION_FILTER = "anim";
    private static SVGNavigatorContent navigatorContentInstance = null;
    private final JPanel emptyPanel;
    private final JLabel msgLabel;
    private SVGDataObject peerDO = null;
    private NavigatorContentPanel navigatorPanel = null;
    private boolean blockNotification = false;
    private final WeakHashMap uiCache = new WeakHashMap();

    public static synchronized SVGNavigatorContent getDefault() {
        if (navigatorContentInstance == null) {
            navigatorContentInstance = new SVGNavigatorContent();
        }
        return navigatorContentInstance;
    }

    private SVGNavigatorContent() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.emptyPanel = new JPanel();
        this.emptyPanel.setBackground(Color.WHITE);
        this.emptyPanel.setLayout(new BorderLayout());
        this.msgLabel = new JLabel();
        this.emptyPanel.add((Component)this.msgLabel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionChanged(SVGObject[] newSelection, SVGObject[] oldSelection, boolean isReadOnly) {
        this.blockNotification = true;
        try {
            this.select(newSelection != null ? newSelection[0].getElementId() : null);
        }
        finally {
            this.blockNotification = false;
        }
    }

    public synchronized void navigate(final SVGDataObject dObj) {
        if (dObj != this.peerDO) {
            NavigatorContentPanel cachedPanel;
            if (this.peerDO != null) {
                this.peerDO.getSceneManager().removeSelectionListener(this);
            }
            this.peerDO = dObj;
            WeakReference panelWR = (WeakReference)this.uiCache.get((Object)dObj);
            if (panelWR != null) {
                NavigatorContentPanel cp = (NavigatorContentPanel)panelWR.get();
                if (cp != null) {
                    System.out.println("panel is cached");
                    if (cp.m_model == dObj.getModel().getModel()) {
                        cachedPanel = cp;
                    } else {
                        this.uiCache.remove((Object)dObj);
                        cachedPanel = null;
                    }
                } else {
                    cachedPanel = null;
                }
            } else {
                cachedPanel = null;
            }
            if (dObj != null) {
                dObj.getSceneManager().addSelectionListener(this);
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        NavigatorContentPanel panel;
                        SVGNavigatorContent.this.showWaitPanel();
                        if (cachedPanel == null) {
                            try {
                                if (dObj.getModel().getModel() == null) {
                                    SVGNavigatorContent.this.showCannotNavigate();
                                    return;
                                }
                                panel = new NavigatorContentPanel(dObj);
                                SVGNavigatorContent.this.uiCache.put(dObj, new WeakReference<NavigatorContentPanel>(panel));
                            }
                            catch (Exception ex) {
                                SceneManager.log(Level.WARNING, "Navigator panel creation failed", ex);
                                SVGNavigatorContent.this.showCannotNavigate();
                                return;
                            }
                        } else {
                            panel = cachedPanel;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SVGNavigatorContent.this.setContent(dObj, panel);
                            }
                        });
                    }
                });
            } else {
                this.setContent(null, null);
            }
        }
    }

    synchronized void setContent(SVGDataObject obj, NavigatorContentPanel panel) {
        this.navigatorPanel = panel;
        this.removeAll();
        if (panel != null) {
            this.add((Component)panel, "Center");
        }
        this.validate();
        this.repaint();
    }

    synchronized void select(String elemId) {
        if (this.navigatorPanel != null) {
            this.navigatorPanel.tree.selectNode(elemId, null);
        }
    }

    public void release() {
        this.removeAll();
        this.peerDO = null;
        this.repaint();
    }

    public void showCannotNavigate() {
        this.removeAll();
        this.msgLabel.setIcon(null);
        this.msgLabel.setForeground(Color.GRAY);
        this.msgLabel.setText(NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_CannotNavigate"));
        this.msgLabel.setHorizontalAlignment(0);
        this.add((Component)this.emptyPanel, "Center");
        this.repaint();
    }

    private void showWaitPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVGNavigatorContent.this.removeAll();
                SVGNavigatorContent.this.msgLabel.setIcon(null);
                SVGNavigatorContent.this.msgLabel.setForeground(Color.GRAY);
                SVGNavigatorContent.this.msgLabel.setHorizontalAlignment(2);
                SVGNavigatorContent.this.msgLabel.setText(NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_Wait"));
                SVGNavigatorContent.this.add((Component)SVGNavigatorContent.this.emptyPanel, "North");
                SVGNavigatorContent.this.repaint();
            }
        });
    }

    private class NavigatorContentPanel
    extends JPanel
    implements FiltersManager.FilterChangeListener {
        private final SVGDataObject m_doj;
        private final SVGNavigatorTree tree;
        private final FiltersManager m_filters;
        final DocumentModel m_model;
        private final SVGFileModel.ModelListener modelListener = new SVGFileModel.ModelListener(){

            @Override
            public void modelChanged() {
                NavigatorContentPanel.this.tree.repaint();
            }
        };

        private String getElementId(DocumentElement de) {
            if (de.getStartOffset() < de.getEndOffset()) {
                return this.m_doj.getModel().getElementId(de);
            }
            SceneManager.log(Level.SEVERE, "Deleted element found: " + de);
            return null;
        }

        public NavigatorContentPanel(SVGDataObject doj) throws Exception {
            this.m_doj = doj;
            this.m_model = doj.getModel().getModel();
            this.setLayout(new BorderLayout());
            this.tree = new SVGNavigatorTree(doj);
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int selRow = NavigatorContentPanel.this.tree.getRowForLocation(e.getX(), e.getY());
                    if (selRow != -1) {
                        TreePath selPath = NavigatorContentPanel.this.tree.getPathForLocation(e.getX(), e.getY());
                        SVGNavigatorNode tna = (SVGNavigatorNode)selPath.getLastPathComponent();
                        DocumentElement de = tna.getDocumentElement();
                        if (e.getClickCount() == 2) {
                            SVGSourceMultiViewElement.selectElement(NavigatorContentPanel.this.m_doj, de.getStartOffset(), true);
                        }
                    }
                }
            };
            this.tree.addMouseListener(ml);
            final DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
            selectionModel.setSelectionMode(1);
            this.tree.setSelectionModel(selectionModel);
            selectionModel.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    if (!SVGNavigatorContent.this.blockNotification) {
                        Lookup lkp;
                        SelectionCookie cookie;
                        TopComponent tc;
                        TreePath selPath = e.getPath();
                        int index = -1;
                        String id = null;
                        if (selPath != null && !selectionModel.isSelectionEmpty()) {
                            SVGNavigatorNode tna = (SVGNavigatorNode)selPath.getLastPathComponent();
                            DocumentElement de = tna.getDocumentElement();
                            id = NavigatorContentPanel.this.getElementId(de);
                            index = de.getStartOffset();
                        }
                        if ((tc = NavigatorContentPanel.this.m_doj.getMTVC()) != null && (cookie = (SelectionCookie)(lkp = tc.getLookup()).lookup(SelectionCookie.class)) != null && id != null) {
                            cookie.updateSelection(NavigatorContentPanel.this.m_doj, id, index, false);
                        }
                    }
                }
            });
            JScrollPane treeView = new JScrollPane(this.tree);
            treeView.setBorder(BorderFactory.createEmptyBorder());
            treeView.setViewportBorder(BorderFactory.createEmptyBorder());
            this.add((Component)treeView, "Center");
            MouseAdapter pmml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() == 1 && e.getModifiers() == 4) {
                        JPopupMenu pm = new JPopupMenu();
                        final AnimationCookie animCookie = (AnimationCookie)NavigatorContentPanel.this.getCookie(AnimationCookie.class);
                        final DocumentElement de = NavigatorContentPanel.this.getElementAt(e.getX(), e.getY());
                        boolean isReadOnly = NavigatorContentPanel.this.m_doj.getSceneManager().isReadOnly();
                        if (animCookie != null && de != null && SVGFileModel.isAnimation(de)) {
                            JMenuItem animStart = new JMenuItem(NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_AnimStart"));
                            animStart.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent evt) {
                                    String id = NavigatorContentPanel.this.getElementId(de);
                                    if (id != null) {
                                        animCookie.startAnimation(NavigatorContentPanel.this.m_doj, id);
                                    }
                                }
                            });
                            animStart.setEnabled(isReadOnly);
                            pm.add(animStart);
                            JMenuItem animStop = new JMenuItem(NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_AnimStop"));
                            animStop.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent evt) {
                                    String id = NavigatorContentPanel.this.getElementId(de);
                                    if (id != null) {
                                        animCookie.stopAnimation(NavigatorContentPanel.this.m_doj, id);
                                    }
                                }
                            });
                            animStop.setEnabled(isReadOnly);
                            pm.add(animStop);
                        }
                        JMenuItem[] items = new FilterActions(NavigatorContentPanel.this.m_filters).createMenuItems();
                        for (int i = 0; i < items.length; ++i) {
                            pm.add(items[i]);
                        }
                        pm.pack();
                        pm.show(NavigatorContentPanel.this.tree, e.getX(), e.getY());
                    }
                }
            };
            this.tree.addMouseListener(pmml);
            TreeNode rootNode = (TreeNode)this.tree.getTreeModel().getRoot();
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                TreeNode node = rootNode.getChildAt(i);
                if (node.getChildCount() <= 0) continue;
                this.tree.expandPath(new TreePath(new TreeNode[]{rootNode, node}));
            }
            TapPanel filtersPanel = new TapPanel();
            JLabel filtersLbl = new JLabel(NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_Filter"));
            filtersLbl.setBorder(new EmptyBorder(0, 5, 5, 0));
            filtersPanel.add(filtersLbl);
            filtersPanel.setOrientation(2);
            KeyStroke toggleKey = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            String keyText = Utilities.keyToString((KeyStroke)toggleKey);
            filtersPanel.setToolTipText(NbBundle.getMessage(SVGNavigatorContent.class, (String)"TIP_TapPanel", (Object)keyText));
            this.m_filters = this.createFilters();
            this.m_filters.hookChangeListener(this);
            filtersPanel.add(this.m_filters.getComponent());
            this.add((Component)filtersPanel, "South");
            doj.getModel().addModelListener(this.modelListener);
        }

        protected Node.Cookie getCookie(Class clazz) {
            Node.Cookie cookie = null;
            TopComponent tc = this.m_doj.getMTVC();
            if (tc != null) {
                cookie = (Node.Cookie)tc.getLookup().lookup(clazz);
            }
            return cookie;
        }

        protected DocumentElement getElementAt(int x, int y) {
            DocumentElement de = null;
            int selRow = this.tree.getRowForLocation(x, y);
            if (selRow != -1) {
                TreePath selPath = this.tree.getPathForLocation(x, y);
                SVGNavigatorNode tna = (SVGNavigatorNode)selPath.getLastPathComponent();
                de = tna.getDocumentElement();
            }
            return de;
        }

        private FiltersManager createFilters() {
            FiltersDescription desc = new FiltersDescription();
            desc.addFilter(SVGNavigatorContent.ATTRIBUTES_FILTER, NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_ShowAttributes"), NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_ShowAttributesTip"), SVGNavigatorTree.showAttributes, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/mobility/svgcore/resources/a.png", (boolean)false), null);
            desc.addFilter(SVGNavigatorContent.ID_FILTER, NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_ShowId"), NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_ShowIdTip"), SVGNavigatorTree.showIdOnly, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/mobility/svgcore/resources/filterIdentified.png", (boolean)false), null);
            desc.addFilter(SVGNavigatorContent.ANIMATION_FILTER, NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_ShowAnimation"), NbBundle.getMessage(SVGNavigatorContent.class, (String)"LBL_ShowAnimationTip"), SVGNavigatorTree.showAnimationsOnly, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/mobility/svgcore/resources/filterAnimations.png", (boolean)false), null);
            return FiltersDescription.createManager(desc);
        }

        @Override
        public void filterStateChanged(ChangeEvent e) {
            boolean filterChanged = false;
            boolean attrVisibilityChanged = false;
            boolean selected = this.m_filters.isSelected(SVGNavigatorContent.ATTRIBUTES_FILTER);
            if (selected != SVGNavigatorTree.showAttributes) {
                SVGNavigatorTree.showAttributes = selected;
                attrVisibilityChanged = true;
            }
            if ((selected = this.m_filters.isSelected(SVGNavigatorContent.ID_FILTER)) != SVGNavigatorTree.showIdOnly) {
                filterChanged = true;
                SVGNavigatorTree.showIdOnly = selected;
            }
            if ((selected = this.m_filters.isSelected(SVGNavigatorContent.ANIMATION_FILTER)) != SVGNavigatorTree.showAnimationsOnly) {
                filterChanged = true;
                SVGNavigatorTree.showAnimationsOnly = selected;
            }
            if (filterChanged) {
                this.tree.filterChanged();
            } else if (attrVisibilityChanged) {
                this.tree.validate();
                this.tree.repaint();
            }
        }
    }
}

