/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.parser;

import com.sun.perseus.j2d.RGB;
import com.sun.perseus.parser.NumberParser;
import com.sun.perseus.platform.MathSupport;
import com.sun.perseus.util.SVGConstants;
import java.util.Hashtable;

public class ColorParser
extends NumberParser
implements SVGConstants {
    private static Hashtable predefinedCssColors = new Hashtable();

    public RGB parseColor(String colorString) {
        this.setString(colorString);
        this.current = this.read();
        RGB c = null;
        if (this.current == 35) {
            c = this.parseHexCSSColor();
        } else if (this.current == 114 && (this.current = this.read()) == 103 && (this.current = this.read()) == 98 && (this.current = this.read()) == 40) {
            c = this.parseRgbCSSColor();
        } else {
            if (this.current == 110 && (this.current = this.read()) == 111 && (this.current = this.read()) == 110 && (this.current = this.read()) == 101) {
                return null;
            }
            c = (RGB)predefinedCssColors.get(this.s);
        }
        if (c == null) {
            throw new IllegalArgumentException();
        }
        return c;
    }

    private RGB parseHexCSSColor() {
        if (this.s.length() == 4) {
            int r = ColorParser.hexCharToInt(this.s.charAt(1));
            int g = ColorParser.hexCharToInt(this.s.charAt(2));
            int b = ColorParser.hexCharToInt(this.s.charAt(3));
            return new RGB(r << 4 | r, g << 4 | g, b << 4 | b);
        }
        if (this.s.length() == 7) {
            int r = ColorParser.hexCharToInt(this.s.charAt(1));
            int r2 = ColorParser.hexCharToInt(this.s.charAt(2));
            int g = ColorParser.hexCharToInt(this.s.charAt(3));
            int g2 = ColorParser.hexCharToInt(this.s.charAt(4));
            int b = ColorParser.hexCharToInt(this.s.charAt(5));
            int b2 = ColorParser.hexCharToInt(this.s.charAt(6));
            return new RGB(r << 4 | r2, g << 4 | g2, b << 4 | b2);
        }
        throw new IllegalArgumentException();
    }

    static int hexCharToInt(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalArgumentException();
    }

    private RGB parseRgbCSSColor() {
        this.current = this.read();
        float r = this.parseNumber();
        boolean isPercent = false;
        if (this.current == 37) {
            isPercent = true;
            this.current = this.read();
        }
        this.skipSpacesCommaSpaces();
        float g = this.parseNumber();
        if (this.current == 37) {
            if (!isPercent) {
                throw new IllegalArgumentException();
            }
            this.current = this.read();
        } else if (isPercent) {
            throw new IllegalArgumentException();
        }
        this.skipSpacesCommaSpaces();
        float b = this.parseNumber();
        if (this.current == 37) {
            if (!isPercent) {
                throw new IllegalArgumentException();
            }
            this.current = this.read();
        } else if (isPercent) {
            throw new IllegalArgumentException();
        }
        this.skipSpaces();
        if (this.current != 41) {
            String msg = ">";
            msg = this.current == -1 ? msg + "-1" : msg + (char)this.current + "< " + r + " " + g + " " + b;
            throw new IllegalArgumentException(msg);
        }
        if (isPercent) {
            r = r < 0.0f ? 0.0f : r;
            r = r > 100.0f ? 100.0f : r;
            g = g < 0.0f ? 0.0f : g;
            g = g > 100.0f ? 100.0f : g;
            b = b < 0.0f ? 0.0f : b;
            b = b > 100.0f ? 100.0f : b;
            r = MathSupport.round(r * 2.55f);
            g = MathSupport.round(g * 2.55f);
            b = MathSupport.round(b * 2.55f);
            return new RGB((int)r, (int)g, (int)b);
        }
        r = r < 0.0f ? 0.0f : r;
        r = r > 255.0f ? 255.0f : r;
        g = g < 0.0f ? 0.0f : g;
        g = g > 255.0f ? 255.0f : g;
        b = b < 0.0f ? 0.0f : b;
        b = b > 255.0f ? 255.0f : b;
        return new RGB((int)r, (int)g, (int)b);
    }

    static {
        predefinedCssColors.put("black", RGB.black);
        predefinedCssColors.put("silver", new RGB(192, 192, 192));
        predefinedCssColors.put("gray", new RGB(128, 128, 128));
        predefinedCssColors.put("white", RGB.white);
        predefinedCssColors.put("maroon", new RGB(128, 0, 0));
        predefinedCssColors.put("red", RGB.red);
        predefinedCssColors.put("purple", new RGB(128, 0, 128));
        predefinedCssColors.put("fuchsia", new RGB(255, 0, 255));
        predefinedCssColors.put("green", new RGB(0, 128, 0));
        predefinedCssColors.put("lime", RGB.green);
        predefinedCssColors.put("olive", new RGB(128, 128, 0));
        predefinedCssColors.put("yellow", RGB.yellow);
        predefinedCssColors.put("navy", new RGB(0, 0, 128));
        predefinedCssColors.put("blue", RGB.blue);
        predefinedCssColors.put("teal", new RGB(0, 128, 128));
        predefinedCssColors.put("aqua", new RGB(0, 255, 255));
    }
}

