/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.Discard;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.Messages;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.SVG;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class CompositeNode
extends ModelNode {
    protected ElementNode firstChild;
    protected ElementNode lastChild;

    protected void clearLayouts() {
        this.clearLayouts(this.firstChild);
    }

    public ModelNode getFirstChildNode() {
        return this.firstChild;
    }

    public ModelNode getLastChildNode() {
        return this.lastChild;
    }

    protected void unhookChildrenQuiet() {
        this.unhookQuiet(this.firstChild);
        this.firstChild = null;
        this.lastChild = null;
    }

    public void add(ElementNode element) {
        if (element == null) {
            throw new NullPointerException();
        }
        element.preValidate();
        if (this.firstChild == null) {
            this.firstChild = element;
            this.lastChild = element;
            element.nextSibling = null;
            element.prevSibling = null;
        } else {
            this.lastChild.nextSibling = element;
            element.nextSibling = null;
            element.prevSibling = this.lastChild;
            this.lastChild = element;
        }
        element.setParent(this);
    }

    public abstract String getNamespaceURI();

    public abstract String getLocalName();

    public abstract Node getParentNode();

    public Node appendChild(Node newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (!this.isChild(oldChild)) {
            if (oldChild == null) {
                throw new NullPointerException();
            }
            throw new DOMException(8, Messages.formatMessage("error.not.a.child", null));
        }
        if (!this.isRemoveChildSupported()) {
            throw new DOMException(9, Messages.formatMessage("error.remove.child.not.supported", new String[]{this.getLocalName(), this.getNamespaceURI()}));
        }
        ElementNode oldNode = (ElementNode)oldChild;
        if (CompositeNode.isIdBranch(oldNode)) {
            throw new DOMException(15, Messages.formatMessage("error.cannot.remove.node.with.id", null));
        }
        if (oldNode.nextSibling != null) {
            oldNode.nextSibling.prevSibling = oldNode.prevSibling;
        } else {
            this.lastChild = (ElementNode)oldNode.prevSibling;
        }
        if (oldNode.prevSibling != null) {
            oldNode.prevSibling.nextSibling = oldNode.nextSibling;
        } else {
            this.firstChild = (ElementNode)oldNode.nextSibling;
        }
        oldNode.nextSibling = null;
        oldNode.prevSibling = null;
        oldNode.setParent(null);
        return oldChild;
    }

    public Node removeChildQuiet(Node oldChild) {
        ElementNode oldNode = (ElementNode)oldChild;
        if (oldNode.nextSibling != null) {
            oldNode.nextSibling.prevSibling = oldNode.prevSibling;
        } else {
            this.lastChild = (ElementNode)oldNode.prevSibling;
        }
        if (oldNode.prevSibling != null) {
            oldNode.prevSibling.nextSibling = oldNode.nextSibling;
        } else {
            this.firstChild = (ElementNode)oldNode.nextSibling;
        }
        oldNode.nextSibling = null;
        oldNode.prevSibling = null;
        oldNode.setParentQuiet(null);
        return oldNode;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild == null) {
            throw new NullPointerException();
        }
        if (newChild == this.ownerDocument) {
            throw new DOMException(3, Messages.formatMessage("error.cannot.insert.document.node", null));
        }
        if (!(newChild instanceof ElementNode)) {
            throw new DOMException(4, Messages.formatMessage("error.cannot.insert.from.other.document", null));
        }
        ElementNode newNode = (ElementNode)newChild;
        if (newNode.ownerDocument != this.ownerDocument) {
            throw new DOMException(4, Messages.formatMessage("error.cannot.insert.from.other.document", null));
        }
        if (!this.isAllowedChild(newNode)) {
            throw new DOMException(3, Messages.formatMessage("error.child.not.allowed", new String[]{newNode.getLocalName(), newNode.getNamespaceURI(), this.getLocalName(), this.getNamespaceURI()}));
        }
        if (this.isAncestor(newNode)) {
            throw new DOMException(3, Messages.formatMessage("error.inserting.ancestor", null));
        }
        if (this == this.ownerDocument && this.firstChild != null) {
            throw new DOMException(3, Messages.formatMessage("error.inserting.under.document", null));
        }
        if (refChild != null && !this.isChild(refChild)) {
            throw new DOMException(8, Messages.formatMessage("error.ref.node.not.a.child", null));
        }
        if (newNode.parent == this.ownerDocument) {
            throw new DOMException(9, Messages.formatMessage("error.inserting.document.element", null));
        }
        if (newNode.parent != null) {
            ((CompositeNode)newNode.parent).removeChild(newNode);
        }
        if (refChild == null) {
            this.add(newNode);
        } else {
            ElementNode refNode = (ElementNode)refChild;
            newNode.prevSibling = refNode.prevSibling;
            newNode.nextSibling = refNode;
            if (refNode.prevSibling != null) {
                refNode.prevSibling.nextSibling = newNode;
            } else {
                this.firstChild = newNode;
            }
            refNode.prevSibling = newNode;
            newNode.nextSibling = refNode;
            newNode.setParent(this);
        }
        return newChild;
    }

    protected boolean isAllowedChild(ElementNode node) {
        return !(node instanceof SVG);
    }

    final boolean isAncestor(ElementNode node) {
        if (node == this) {
            return true;
        }
        if (this.parent != null) {
            return ((CompositeNode)this.parent).isAncestor(node);
        }
        return false;
    }

    final boolean isChild(Node node) {
        ElementNode c = this.firstChild;
        while (c != null) {
            if (c == node) {
                return true;
            }
            c = (ElementNode)c.nextSibling;
        }
        return false;
    }

    protected boolean isRemoveChildSupported() {
        return true;
    }

    protected static boolean isIdBranch(ElementNode node) {
        if (node.id != null) {
            Vector idRefs = (Vector)node.ownerDocument.resolvedIDRefs.get(node.id);
            if (idRefs != null) {
                int size = idRefs.size();
                for (int i = 0; i < size; ++i) {
                    ElementNode elementNode = (ElementNode)idRefs.elementAt(i);
                    if (elementNode instanceof Discard) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        ElementNode c = node.firstChild;
        while (c != null) {
            if (CompositeNode.isIdBranch(c)) {
                return true;
            }
            c = (ElementNode)c.nextSibling;
        }
        return false;
    }

    final void onHookedInDocumentTree() {
        super.onHookedInDocumentTree();
        this.nodeHookedInDocumentTree();
        ModelNode c = this.getFirstExpandedChild();
        while (c != null) {
            c.onHookedInDocumentTree();
            c = c.nextSibling;
        }
        c = this.getFirstChildNode();
        while (c != null) {
            c.onHookedInDocumentTree();
            c = c.nextSibling;
        }
    }

    final void onUnhookedFromDocumentTree() {
        super.onUnhookedFromDocumentTree();
        this.nodeUnhookedFromDocumentTree();
        ModelNode c = this.getFirstExpandedChild();
        while (c != null) {
            c.onUnhookedFromDocumentTree();
            c = c.nextSibling;
        }
        c = this.getFirstChildNode();
        while (c != null) {
            c.onUnhookedFromDocumentTree();
            c = c.nextSibling;
        }
    }

    void nodeHookedInDocumentTree() {
    }

    void nodeUnhookedFromDocumentTree() {
    }
}

