/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.codegen;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.vmd.api.model.Debug;
import org.openide.text.IndentEngine;

public final class CodeWriter {
    private StyledDocument document;
    private String forceValue;
    private SimpleSection section;
    private int offset;
    private int endOffset;
    private Writer writer;
    private StringWriter memory;
    private boolean committed;

    public CodeWriter(StyledDocument document, SimpleSection section) {
        this(document, section.getStartPosition().getOffset(), Integer.MIN_VALUE, null);
        this.section = section;
    }

    public CodeWriter(StyledDocument document, SimpleSection beforeSection, SimpleSection afterSection, String forceValue) {
        this(document, beforeSection.getEndPosition().getOffset() + 1, afterSection.getStartPosition().getOffset(), forceValue);
    }

    private CodeWriter(StyledDocument document, int beginOffset, int endOffset, String forceValue) {
        this.document = document;
        this.forceValue = forceValue;
        this.offset = beginOffset;
        this.endOffset = endOffset;
    }

    public CodeWriter write(String text) {
        assert (!this.committed);
        if (this.forceValue != null) {
            return this;
        }
        try {
            if (this.writer == null) {
                this.memory = new StringWriter(512);
                IndentEngine indentEngine = IndentEngine.find((Document)this.document);
                this.writer = indentEngine != null ? indentEngine.createWriter((Document)this.document, this.offset, (Writer)this.memory) : this.memory;
            }
            this.writer.write(text);
            return this;
        }
        catch (IOException e) {
            throw Debug.error((Object[])new Object[]{e});
        }
    }

    public void commit() {
        assert (!this.committed);
        try {
            String text;
            if (this.forceValue != null) {
                text = this.forceValue;
            } else if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                text = this.memory.getBuffer().toString();
            } else {
                text = "";
            }
            if (this.section != null) {
                this.section.setText(text);
            } else {
                if (this.endOffset != Integer.MIN_VALUE) {
                    this.document.remove(this.offset, this.endOffset - this.offset);
                }
                this.document.insertString(this.offset, text, null);
            }
            this.committed = true;
            this.writer = null;
            this.memory = null;
        }
        catch (IOException e) {
            throw Debug.error((Object[])new Object[]{e});
        }
        catch (BadLocationException e) {
            throw Debug.error((Object[])new Object[]{e});
        }
    }

    public boolean isCommitted() {
        return this.committed;
    }
}

