/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.kenai;

import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.BugzillaConnector;
import org.netbeans.modules.bugzilla.kenai.KenaiQueryController;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.query.QueryController;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;

public class KenaiQuery
extends BugzillaQuery {
    private final String product;
    private boolean predefinedQuery = false;

    public KenaiQuery(String name, BugzillaRepository repository, String urlParameters, String product, boolean saved, boolean predefined) {
        super(name, repository, urlParameters, saved, false, false);
        this.product = product;
        this.predefinedQuery = predefined;
        this.setLastRefresh(repository.getIssueCache().getQueryTimestamp(this.getStoredQueryName()));
        this.controller = this.createControler(repository, this, urlParameters);
        boolean autoRefresh = BugzillaConfig.getInstance().getQueryAutoRefresh(this.getDisplayName());
        if (autoRefresh) {
            this.getRepository().scheduleForRefresh(this);
        }
    }

    @Override
    protected QueryController createControler(BugzillaRepository r, BugzillaQuery q, String parameters) {
        KenaiQueryController c = new KenaiQueryController(r, q, parameters, this.product, this.predefinedQuery);
        return c;
    }

    void setUrlParameters(String urlParameters) {
        this.urlParameters = urlParameters;
    }

    @Override
    protected void logQueryEvent(int count, boolean autoRefresh) {
        BugtrackingUtil.logQueryEvent((String)BugzillaConnector.getConnectorName(), (String)this.getDisplayName(), (int)count, (boolean)true, (boolean)autoRefresh);
    }

    @Override
    public String getStoredQueryName() {
        return super.getStoredQueryName() + "-" + this.product;
    }
}

