/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.push;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.ui.pull.PullAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgRepositoryContextCache;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.hooks.HgHook;
import org.netbeans.modules.versioning.hooks.HgHookContext;
import org.netbeans.modules.versioning.hooks.VCSHooks;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PushAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        return HgUtils.isFromHgRepository(context) && ctxFiles != null && ctxFiles.size() != 0;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_PushLocal";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        final Set<File> repositoryRoots = HgUtils.getRepositoryRoots(context);
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Iterator i$ = repositoryRoots.iterator();
                while (i$.hasNext()) {
                    File repositoryRoot;
                    final File repository = repositoryRoot = (File)i$.next();
                    final boolean[] canceled = new boolean[1];
                    RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
                    HgProgressSupport support = new HgProgressSupport(){

                        @Override
                        public void perform() {
                            PushAction.getDefaultAndPerformPush(repository, this.getLogger());
                            canceled[0] = this.isCanceled();
                        }
                    };
                    support.start(rp, repository, NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_PROGRESS")).waitFinished();
                    if (!canceled[0]) continue;
                    break;
                }
            }
        });
    }

    public static void getDefaultAndPerformPush(File root, OutputLogger logger) {
        HgURL pushTarget;
        String tmpPushPath = HgRepositoryContextCache.getInstance().getPushDefault(root);
        if (HgUtils.isNullOrEmpty(tmpPushPath)) {
            tmpPushPath = HgRepositoryContextCache.getInstance().getPullDefault(root);
        }
        if (HgUtils.isNullOrEmpty(tmpPushPath)) {
            PushAction.notifyDefaultPushUrlNotSpecified(logger);
            return;
        }
        try {
            pushTarget = new HgURL(tmpPushPath);
        }
        catch (URISyntaxException ex) {
            PushAction.notifyDefaultPushUrlInvalid(tmpPushPath, ex.getReason(), logger);
            return;
        }
        String fromPrjName = HgProjectUtils.getProjectName(root);
        String toPrjName = pushTarget.isFile() ? HgProjectUtils.getProjectName(new File(pushTarget.getPath())) : null;
        PushAction.performPush(root, pushTarget, fromPrjName, toPrjName, logger, true);
    }

    private static void notifyDefaultPushUrlNotSpecified(OutputLogger logger) {
        String title = PushAction.getMessage("MSG_PUSH_TITLE", new String[0]);
        logger.outputInRed(title);
        logger.outputInRed(PushAction.getMessage("MSG_PUSH_TITLE_SEP", new String[0]));
        logger.output(PushAction.getMessage("MSG_NO_DEFAULT_PUSH_SET_MSG", new String[0]));
        logger.outputInRed(PushAction.getMessage("MSG_PUSH_DONE", new String[0]));
        logger.output("");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PushAction.getMessage("MSG_NO_DEFAULT_PUSH_SET", new String[0])));
    }

    private static void notifyDefaultPushUrlInvalid(String pushUrl, String reason, OutputLogger logger) {
        String title = PushAction.getMessage("MSG_PUSH_TITLE", new String[0]);
        String msg = PushAction.getMessage("MSG_DEFAULT_PUSH_INVALID", pushUrl);
        logger.outputInRed(title);
        logger.outputInRed(PushAction.getMessage("MSG_PUSH_TITLE_SEP", new String[0]));
        logger.output(msg);
        logger.outputInRed(PushAction.getMessage("MSG_PUSH_DONE", new String[0]));
        logger.output("");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performPush(File root, HgURL pushUrl, String fromPrjName, String toPrjName, OutputLogger logger, boolean showSaveCredsOption) {
        try {
            List<String> list;
            boolean bLocalPush = pushUrl.isFile();
            String pushPath = bLocalPush ? pushUrl.getPath() : null;
            File pushFile = bLocalPush ? new File(pushPath) : null;
            logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE"));
            logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TITLE_SEP"));
            if (toPrjName == null) {
                logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSHING_TO_NONAME", (Object)(bLocalPush ? HgUtils.stripDoubleSlash(pushPath) : pushUrl)));
            } else {
                logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSHING_TO", (Object)toPrjName, (Object)(bLocalPush ? HgUtils.stripDoubleSlash(pushPath) : pushUrl)));
            }
            List<String> listOutgoing = HgCommand.doOutgoing(root, pushUrl, logger, showSaveCredsOption);
            if (listOutgoing == null || listOutgoing.isEmpty()) {
                return;
            }
            ArrayList<HgLogMessage> messages = new ArrayList<HgLogMessage>();
            HgCommand.processLogMessages(root, null, listOutgoing, messages);
            boolean bNoChanges = HgCommand.isNoChanges(listOutgoing.get(listOutgoing.size() - 1));
            if (bLocalPush && !bNoChanges && !PullAction.confirmWithLocalChanges(pushFile, PushAction.class, "MSG_PUSH_LOCALMODS_CONFIRM_TITLE", "MSG_PUSH_LOCALMODS_CONFIRM_QUERY", listOutgoing, logger)) {
                logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_LOCALMODS_CANCEL"));
                logger.output("");
                return;
            }
            HgHookContext context = null;
            Collection hooks = null;
            if (bNoChanges) {
                list = listOutgoing;
            } else {
                hooks = VCSHooks.getInstance().getHooks(HgHook.class);
                if (hooks.size() > 0) {
                    HgHookContext.LogEntry[] entries = new HgHookContext.LogEntry[messages.size()];
                    for (int i = 0; i < messages.size(); ++i) {
                        entries[i] = new HgHookContext.LogEntry(((HgLogMessage)messages.get(i)).getMessage(), ((HgLogMessage)messages.get(i)).getAuthor(), ((HgLogMessage)messages.get(i)).getCSetShortID(), ((HgLogMessage)messages.get(i)).getDate());
                    }
                    context = new HgHookContext(new File[]{root}, null, entries);
                }
                for (HgHook hgHook : hooks) {
                    try {
                        hgHook.beforePush(context);
                    }
                    catch (IOException ex) {}
                }
                list = HgCommand.doPush(root, pushUrl, logger, showSaveCredsOption);
            }
            if (!list.isEmpty() && HgCommand.isErrorAbortPush(list.get(list.size() - 1))) {
                logger.output(list);
                logger.output("");
                HgUtils.warningDialog(PushAction.class, "MSG_PUSH_ERROR_TITLE", "MSG_PUSH_ERROR_QUERY");
                logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_ERROR_CANCELED"));
                return;
            }
            if (hooks != null && context != null) {
                for (HgHook hgHook : hooks) {
                    hgHook.afterPush(context);
                }
            }
            if (list != null && !list.isEmpty()) {
                if (!HgCommand.isNoChanges(listOutgoing.get(listOutgoing.size() - 1))) {
                    logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_CHANGESETS_TO_PUSH"));
                    if (messages.size() > 0) {
                        for (HgLogMessage m : messages) {
                            HgUtils.logHgLog(m, logger);
                        }
                    } else {
                        for (String s : listOutgoing) {
                            if (s.indexOf("changeset:") == 0) {
                                logger.outputInRed(s);
                                continue;
                            }
                            if (s.equals("")) continue;
                            logger.output(HgUtils.replaceHttpPassword(s));
                        }
                    }
                    logger.output("");
                }
                logger.output(HgUtils.replaceHttpPassword(list));
                if (toPrjName == null) {
                    logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TO_NONAME", (Object)(bLocalPush ? HgUtils.stripDoubleSlash(pushPath) : pushUrl)));
                } else {
                    logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_TO", (Object)toPrjName, (Object)(bLocalPush ? HgUtils.stripDoubleSlash(pushPath) : pushUrl)));
                }
                if (fromPrjName == null) {
                    logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_FROM_NONAME", (Object)root));
                } else {
                    logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_FROM", (Object)fromPrjName, (Object)root));
                }
                boolean bMergeNeeded = false;
                if (bLocalPush) {
                    bMergeNeeded = HgCommand.isHeadsCreated(list.get(list.size() - 1));
                }
                boolean bConfirmMerge = false;
                if (!bMergeNeeded) {
                    if (bNoChanges) {
                        return;
                    }
                    if (bLocalPush) {
                        list = HgCommand.doUpdateAll(pushFile, false, null, false);
                        logger.output(list);
                        if (toPrjName != null) {
                            logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_UPDATE_DONE", (Object)toPrjName, (Object)HgUtils.stripDoubleSlash(pushPath)));
                        } else {
                            logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_UPDATE_DONE_NONAME", (Object)HgUtils.stripDoubleSlash(pushPath)));
                        }
                        boolean bOutStandingUncommittedMerges = HgCommand.isMergeAbortUncommittedMsg(list.get(list.size() - 1));
                        if (bOutStandingUncommittedMerges) {
                            bConfirmMerge = HgUtils.confirmDialog(PushAction.class, "MSG_PUSH_MERGE_CONFIRM_TITLE", "MSG_PUSH_MERGE_UNCOMMITTED_CONFIRM_QUERY");
                        } else {
                            HgUtils.notifyUpdatedFiles(pushFile, list);
                        }
                    }
                } else {
                    bConfirmMerge = HgUtils.confirmDialog(PushAction.class, "MSG_PUSH_MERGE_CONFIRM_TITLE", "MSG_PUSH_MERGE_CONFIRM_QUERY");
                }
                if (bConfirmMerge) {
                    logger.output("");
                    logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_MERGE_DO"));
                    MergeAction.doMergeAction(pushFile, null, logger);
                } else {
                    List<String> headRevList = HgCommand.getHeadRevisions(pushPath);
                    if (headRevList != null && headRevList.size() > 1) {
                        MergeAction.printMergeWarning(headRevList, logger);
                    }
                }
            }
            if (bLocalPush && !bNoChanges) {
                HgUtils.forceStatusRefresh(pushFile);
            }
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        finally {
            logger.outputInRed(NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_DONE"));
            logger.output("");
            pushUrl.clearPassword();
        }
    }

    private static String getMessage(String msgKey, String ... args) {
        return NbBundle.getMessage(PushAction.class, (String)msgKey, (Object[])args);
    }
}

