/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.BorderLayout;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.log.DiffResultsView;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchCriteriaPanel;
import org.netbeans.modules.mercurial.ui.log.SearchExecutor;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class SearchHistoryTopComponent
extends TopComponent
implements DiffSetupSource {
    private SearchHistoryPanel shp;
    private SearchCriteriaPanel scp;

    public SearchHistoryTopComponent() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSN_SearchHistoryT_Top_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSD_SearchHistoryT_Top_Component"));
    }

    public SearchHistoryTopComponent(File[] files) {
        this(files, null, null, null, null);
    }

    public SearchHistoryTopComponent(File[] files, String commitMessage, String username, Date from, Date to) {
        this();
        this.initComponents(files, commitMessage, username, from, to);
    }

    SearchHistoryTopComponent(File file, DiffResultsViewFactory fac) {
        this();
        this.initComponents(new File[]{file}, null, null, null, null);
        this.shp.setDiffResultsViewFactory(fac);
        this.shp.disableFileChangesOption(false);
    }

    public void search() {
        this.shp.executeSearch();
        this.shp.setSearchCriteria(false);
    }

    public void searchOut() {
        this.shp.setOutSearch();
        this.scp.setTo("");
    }

    public void searchIncoming() {
        this.shp.setIncomingSearch();
        this.scp.setTo("");
    }

    private void initComponents(File[] roots, String commitMessage, String username, Date from, Date to) {
        this.setLayout(new BorderLayout());
        this.scp = new SearchCriteriaPanel();
        this.scp.setCommitMessage(commitMessage);
        this.scp.setUsername(username);
        if (from != null) {
            this.scp.setFrom(SearchExecutor.simpleDateFormat.format(from));
        }
        if (to != null) {
            this.scp.setTo(SearchExecutor.simpleDateFormat.format(to));
        }
        this.shp = new SearchHistoryPanel(roots, this.scp);
        this.add(this.shp);
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    protected String preferredID() {
        if (this.shp.isIncomingSearch()) {
            return "Hg.IncomingSearchHistoryTopComponent";
        }
        if (this.shp.isOutSearch()) {
            return "Hg.OutSearchHistoryTopComponent";
        }
        return "Hg.SearchHistoryTopComponent";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    @Override
    public Collection getSetups() {
        return this.shp.getSetups();
    }

    @Override
    public String getSetupDisplayName() {
        return this.getDisplayName();
    }

    public static class DiffResultsViewFactory {
        DiffResultsView createDiffResultsView(SearchHistoryPanel panel, List<RepositoryRevision> results) {
            return new DiffResultsView(panel, results);
        }
    }
}

