/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.EventQueue;
import java.util.Collection;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentModelProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class WebFolderListener
extends FileChangeAdapter {
    private final PageFlowController pfc;
    private final FileObject webFolder;
    private final Collection<? extends PageContentModelProvider> impls = PageFlowController.getPageContentModelProviders();
    private String oldFolderName;
    private String newFolderName;

    public WebFolderListener(PageFlowController pageFlowController) {
        this.pfc = pageFlowController;
        this.webFolder = pageFlowController.getWebFolder();
    }

    private boolean isKnownFileEvent(FileObject fileObject) {
        if (FileUtil.isParentOf((FileObject)this.webFolder, (FileObject)fileObject)) {
            if (fileObject.isFolder()) {
                return this.pfc.isKnownFolder(fileObject);
            }
            return this.pfc.isKnownFile(fileObject);
        }
        return false;
    }

    public void fileDataCreated(FileEvent fileEvent) {
        if (this.pfc.getView() == null) {
            return;
        }
        if (!this.pfc.getView().isShowing()) {
            this.pfc.setFilesDirty();
            return;
        }
        final FileObject fileObject = fileEvent.getFile();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebFolderListener.this.fileCreatedEventHandler(fileObject);
            }
        });
    }

    public void fileDeleted(FileEvent fileEvent) {
        if (this.pfc.getView() == null) {
            return;
        }
        if (!this.pfc.getView().isShowing()) {
            this.pfc.setFilesDirty();
            return;
        }
        final FileObject fileObject = fileEvent.getFile();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebFolderListener.this.fileDeletedEventHandler(fileObject);
            }
        });
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        if (this.pfc.getView() == null) {
            return;
        }
        if (!this.pfc.getView().isShowing()) {
            this.pfc.setFilesDirty();
            return;
        }
        final FileObject fileObject = fileRenameEvent.getFile();
        final FileRenameEvent fileRenameEvent2 = fileRenameEvent;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebFolderListener.this.fileRenamedEventHandler(fileObject, fileRenameEvent2.getName(), fileRenameEvent2.getExt());
            }
        });
    }

    private void fileDeletedEventHandler(FileObject fileObject) {
        PageFlowView pageFlowView = this.pfc.getView();
        if (!this.pfc.removeWebFile(fileObject)) {
            return;
        }
        String string = Page.getFolderDisplayName(this.webFolder, fileObject);
        Page page = this.pfc.getPageName2Page(string);
        if (page != null) {
            if (this.pfc.isPageInAnyFacesConfig(page.getDisplayName())) {
                this.pfc.changeToAbstractNode(page, string);
            } else {
                pageFlowView.removeNodeWithEdges(page);
                this.pfc.removePageName2Page(page, true);
            }
            pageFlowView.validateGraph();
        }
    }

    private void fileCreatedEventHandler(FileObject fileObject) {
        PageFlowView pageFlowView = this.pfc.getView();
        if (!this.isKnownFileEvent(fileObject)) {
            for (PageContentModelProvider pageContentModelProvider : this.impls) {
                String string;
                Page page;
                FileObject fileObject2 = pageContentModelProvider.isNewPageContentModel(fileObject);
                if (fileObject2 == null || !this.isKnownFileEvent(fileObject2) || (page = this.pfc.getPageName2Page(string = Page.getFolderDisplayName(this.webFolder, fileObject2))) == null) continue;
                page.updateContentModel();
                pageFlowView.resetNodeWidget(page, true);
                pageFlowView.validateGraph();
            }
            return;
        }
        try {
            if (this.pfc.isKnownFile(fileObject)) {
                this.pfc.addWebFile(fileObject);
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                Node node = dataObject.getNodeDelegate();
                Page page = this.pfc.getPageName2Page(Page.getFolderDisplayName(this.webFolder, fileObject));
                if (page != null) {
                    page.replaceWrappedNode(node);
                    pageFlowView.resetNodeWidget(page, false);
                    pageFlowView.validateGraph();
                } else if (this.pfc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT)) {
                    Page page2 = this.pfc.createPage(node);
                    pageFlowView.createNode(page2, null, null);
                    pageFlowView.validateGraph();
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
    }

    private void fileRenamedEventHandler(FileObject fileObject, String string, String string2) {
        if (!this.pfc.containsWebFile(fileObject) && !this.pfc.isKnownFolder(fileObject)) {
            return;
        }
        if (fileObject.isFolder()) {
            if (string.equals(this.oldFolderName) && fileObject.getName().equals(this.newFolderName)) {
                return;
            }
            this.oldFolderName = string;
            this.newFolderName = fileObject.getName();
            this.renameFolder(fileObject, this.oldFolderName, this.newFolderName);
        } else {
            String string3 = Page.getFolderDisplayName(this.webFolder, fileObject);
            String string4 = fileObject.getPath().replace(fileObject.getNameExt(), "");
            String string5 = Page.getFolderDisplayName(this.webFolder, string4, string + "." + string2);
            this.renameFile(fileObject, string5, string3);
        }
        this.pfc.getView().validateGraph();
    }

    private void renameFolder(FileObject fileObject, String string, String string2) {
        FileObject[] fileObjectArray;
        for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
            if (fileObject2.isFolder()) {
                this.renameFolder(fileObject2, string, string2);
                continue;
            }
            String string3 = Page.getFolderDisplayName(this.webFolder, fileObject2);
            String string4 = string3.replaceFirst(string2, string);
            this.renameFile(fileObject2, string4, string3);
        }
    }

    private void renameFile(FileObject fileObject, String string, String string2) {
        PageFlowView pageFlowView = this.pfc.getView();
        Page page = this.pfc.getPageName2Page(string);
        Page page2 = this.pfc.getPageName2Page(string2);
        if (page == null && page2 != null) {
            Node node = this.getNodeDelegate(fileObject);
            page2.replaceWrappedNode(node);
            pageFlowView.resetNodeWidget(page2, true);
            pageFlowView.validateGraph();
            return;
        }
        if (page != null && page.isRenaming()) {
            return;
        }
        Node node = this.getNodeDelegate(fileObject);
        if (this.pfc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT) && page == null) {
            return;
        }
        if (page2 != null) {
            if (page2.isDataNode()) {
                System.err.println("So Called Abstract Node: " + page2);
                Thread.dumpStack();
            }
            if (this.pfc.isPageInAnyFacesConfig(string)) {
                this.pfc.changeToAbstractNode(page, string);
            } else if (page != null) {
                pageFlowView.removeNodeWithEdges(page);
                this.pfc.removePageName2Page(page, true);
            }
            page2.replaceWrappedNode(node);
            pageFlowView.resetNodeWidget(page2, true);
        } else if (page != null) {
            if (this.pfc.isPageInAnyFacesConfig(string)) {
                this.pfc.changeToAbstractNode(page, string);
                if (this.pfc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT)) {
                    Page page3 = this.pfc.createPage(node);
                    pageFlowView.createNode(page3, null, null);
                }
            } else {
                pageFlowView.resetNodeWidget(page, false);
            }
        }
    }

    private Node getNodeDelegate(FileObject fileObject) {
        Node node = null;
        try {
            node = DataObject.find((FileObject)fileObject).getNodeDelegate();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        return node;
    }
}

