/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import org.netbeans.editor.ext.html.dtd.spi.ReaderProvider;
import org.netbeans.editor.ext.html.dtd.spi.ReaderProviderFactory;
import org.netbeans.modules.html.editor.NbReaderProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class NbReaderProviderFactory
extends ReaderProviderFactory {
    private final String DTD_FOLDER = "DTDs";
    private Collection<ReaderProvider> PROVIDERS;

    public Collection<ReaderProvider> getProviders() {
        if (this.PROVIDERS == null) {
            this.initializeProviders();
        }
        return this.PROVIDERS;
    }

    private void initializeProviders() {
        this.PROVIDERS = new LinkedList<ReaderProvider>();
        FileObject rootFolder = FileUtil.getConfigRoot();
        FileObject dtdFolder = rootFolder.getFileObject("DTDs");
        if (dtdFolder != null) {
            this.processSubfolders(dtdFolder);
        }
    }

    private void processSubfolders(FileObject dtdFolder) {
        Enumeration en = dtdFolder.getFolders(false);
        while (en.hasMoreElements()) {
            FileObject folder = (FileObject)en.nextElement();
            this.addFolder(folder);
        }
    }

    private void addFolder(FileObject folder) {
        this.PROVIDERS.add(new NbReaderProvider(folder));
    }
}

