/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.junit.output.JUnitTestMethodNode;
import org.netbeans.modules.junit.output.JUnitTestSuite;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.wizards.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

final class OutputUtils {
    static final Action[] NO_ACTIONS = new Action[0];

    private OutputUtils() {
    }

    static void openTestsuite(TestsuiteNode testsuiteNode) {
        FileObject fileObject;
        TestSuite testSuite = testsuiteNode.getSuite();
        if (testSuite != null && testSuite instanceof JUnitTestSuite && (fileObject = ((JUnitTestSuite)testSuite).getSuiteFO()) != null) {
            final long[] lArray = new long[]{0L};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Trees trees = compilationController.getTrees();
                            CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                            List<? extends Tree> list = compilationUnitTree.getTypeDecls();
                            for (Tree tree : list) {
                                Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                                if (element == null || element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(fileObject.getName())) continue;
                                long l = trees.getSourcePositions().getStartPosition(compilationUnitTree, tree);
                                lArray[0] = compilationUnitTree.getLineMap().getLineNumber(l);
                                break;
                            }
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            Utils.openFile(fileObject, (int)lArray[0]);
        }
    }

    static void openTestMethod(final JUnitTestMethodNode jUnitTestMethodNode) {
        final FileObject fileObject = jUnitTestMethodNode.getTestcase().getClassFileObject();
        if (fileObject != null) {
            final long[] lArray = new long[]{0L};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Trees trees = compilationController.getTrees();
                            CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                            List<? extends Tree> list = compilationUnitTree.getTypeDecls();
                            block0: for (Tree tree : list) {
                                Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                                if (element == null || element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(fileObject.getName())) continue;
                                List<ExecutableElement> list2 = ElementFilter.methodsIn(element.getEnclosedElements());
                                for (ExecutableElement executableElement : list2) {
                                    if (!executableElement.getSimpleName().contentEquals(jUnitTestMethodNode.getTestcase().getName())) continue;
                                    long l = trees.getSourcePositions().getStartPosition(compilationUnitTree, trees.getTree((Element)executableElement));
                                    lArray[0] = compilationUnitTree.getLineMap().getLineNumber(l);
                                    break block0;
                                }
                            }
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            Utils.openFile(fileObject, (int)lArray[0]);
        }
    }

    static void openCallstackFrame(Node node, String string) {
        String[] stringArray;
        JUnitTestMethodNode jUnitTestMethodNode = OutputUtils.getTestMethodNode(node);
        LineConvertors.FileLocator fileLocator = jUnitTestMethodNode.getTestcase().getSession().getFileLocator();
        if (fileLocator == null) {
            return;
        }
        int[] nArray = new int[1];
        FileObject fileObject = OutputUtils.getFile(string, nArray, fileLocator);
        if (fileObject == null && jUnitTestMethodNode.getTestcase().getTrouble() != null && (stringArray = jUnitTestMethodNode.getTestcase().getTrouble().getStackTrace()) != null && stringArray.length > 0) {
            fileObject = OutputUtils.getFile(stringArray[stringArray.length - 1], nArray, fileLocator);
        }
        Utils.openFile(fileObject, nArray[0]);
    }

    static String determineStackFrame(Trouble trouble) {
        String[] stringArray = trouble.getStackTrace();
        return stringArray != null && stringArray.length != 0 ? stringArray[stringArray.length - 1] : null;
    }

    private static JUnitTestMethodNode getTestMethodNode(Node node) {
        while (!(node instanceof JUnitTestMethodNode)) {
            node = node.getParentNode();
        }
        return (JUnitTestMethodNode)node;
    }

    private static FileObject getFile(String string, int[] nArray, LineConvertors.FileLocator fileLocator) {
        String string2;
        String string3;
        int n;
        int n2;
        String string4;
        String string5;
        block13: {
            int n3;
            String string6 = RegexpUtils.specialTrim(string);
            if (string6.startsWith("[catch] ")) {
                string6 = string6.substring("[catch] ".length());
            }
            if (string6.startsWith("at ")) {
                string6 = string6.substring("at ".length());
            }
            String string7 = (n3 = string6.indexOf(40)) == -1 ? string6 : string6.substring(0, n3).trim();
            String string8 = n3 == -1 ? (String)null : string6.substring(n3 + 1, string6.lastIndexOf(41));
            int n4 = string7.lastIndexOf(46);
            string5 = n4 == -1 ? string7 : string7.substring(0, n4);
            string4 = null;
            n2 = -1;
            if (string8 != null && RegexpUtils.getInstance().getLocationInFilePattern().matcher(string8).matches()) {
                int n5 = string8.lastIndexOf(58);
                if (n5 == -1) {
                    string4 = string8;
                } else {
                    string4 = string8.substring(0, n5);
                    try {
                        n2 = Integer.parseInt(string8.substring(n5 + 1));
                        if (n2 <= 0) {
                            n2 = 1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block13;
                        throw new AssertionError();
                    }
                }
            }
        }
        String string9 = string5.replace('.', '/');
        if (string4 == null) {
            n = string9.length();
            string3 = string9;
            string2 = ".java";
        } else {
            n = string9.lastIndexOf(47);
            string3 = n != -1 ? string9.substring(0, n) : string9;
            string2 = '/' + string4;
        }
        String string10 = string3 + string2;
        FileObject fileObject = fileLocator.find(string10);
        while (fileObject == null && n != -1) {
            string10 = (string3 = string3.substring(0, n)) + string2;
            fileObject = fileLocator.find(string10);
            if (fileObject != null) continue;
            n = string3.lastIndexOf(47, n - 1);
        }
        if (fileObject == null && string4 != null) {
            string10 = string4;
            fileObject = fileLocator.find(string10);
        }
        if (fileObject == null) {
            n2 = -1;
        }
        nArray[0] = n2;
        return fileObject;
    }
}

