/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class DebugPortQuery
extends JPanel {
    private JLabel debugPortLable;
    private JSpinner debugPortSpinner;
    private JCheckBox noAskCheck;

    public DebugPortQuery() {
        this.initComponents();
    }

    public void setDebugPort(String debugPort) {
        try {
            int port = Integer.valueOf(debugPort);
            if (port > 0 && port < 65536) {
                this.debugPortSpinner.getModel().setValue(port);
            } else {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, "Debug port out of range in DebugPortQuery");
            }
        }
        catch (NumberFormatException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, "Invalid debug port, using default = 9009.", ex);
        }
    }

    public String getDebugPort() {
        Object value = this.debugPortSpinner.getModel().getValue();
        return value != null ? value.toString() : "";
    }

    public boolean shouldPersist() {
        return this.noAskCheck.getModel().isSelected();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.height = preferredSize.height * 29 / 25;
        return preferredSize;
    }

    private void initComponents() {
        this.debugPortLable = new JLabel();
        this.debugPortSpinner = new JSpinner();
        this.noAskCheck = new JCheckBox();
        this.debugPortLable.setText(NbBundle.getMessage(DebugPortQuery.class, (String)"DebugPortQuery.debugPortLable.text"));
        this.debugPortLable.setVerticalTextPosition(1);
        this.debugPortSpinner.setModel(new SpinnerNumberModel(9009, 1, 65535, 1));
        this.noAskCheck.setSelected(true);
        this.noAskCheck.setText(NbBundle.getMessage(DebugPortQuery.class, (String)"DebugPortQuery.noAskCheck.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.debugPortLable, -1, 393, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(6, 6, 6).add((Component)this.debugPortSpinner, -2, -1, -2).add(204, 204, 204)).add((Component)this.noAskCheck, -1, 393, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.debugPortLable).addPreferredGap(0).add((Component)this.debugPortSpinner, -2, -1, -2).add(18, 18, 18).add((Component)this.noAskCheck).addContainerGap()));
    }
}

