/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.glassfish.eecommon.api.Utils;
import org.netbeans.modules.glassfish.eecommon.api.XmlFileCreator;
import org.netbeans.modules.glassfish.eecommon.api.config.DescriptorListener;
import org.netbeans.modules.glassfish.eecommon.api.config.FolderListener;
import org.netbeans.modules.glassfish.eecommon.api.config.J2EEBaseVersion;
import org.netbeans.modules.glassfish.eecommon.api.config.J2EEVersion;
import org.netbeans.modules.glassfish.eecommon.api.config.J2eeModuleHelper;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.EjbResourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.MessageDestinationConfiguration;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.RootInterface;
import org.netbeans.modules.j2ee.sun.dd.api.client.SunApplicationClient;
import org.netbeans.modules.j2ee.sun.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.sun.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.sun.dd.api.common.WebserviceEndpoint;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.MdbConnectionFactory;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.SunEjbJar;
import org.netbeans.modules.j2ee.sun.dd.api.web.SunWebApp;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class GlassfishConfiguration
implements ContextRootConfiguration,
EjbResourceConfiguration,
MessageDestinationConfiguration,
DatasourceConfiguration {
    protected final J2eeModule module;
    protected final J2eeModuleHelper moduleHelper;
    protected final File primarySunDD;
    protected final File secondarySunDD;
    protected DescriptorListener descriptorListener;
    private ASDDVersion appServerVersion;
    private ASDDVersion minASVersion;
    private ASDDVersion maxASVersion;
    private boolean deferredAppServerChange;
    private static String[] sunServerIds = new String[]{"APPSERVERSJS", "GlassFishV1", "J2EE", "JavaEEPlusSIP", "gfv3", "gfv3ee6"};
    private static final Object configurationMonitor = new Object();
    private static final WeakHashMap<File, WeakReference<GlassfishConfiguration>> configurationMap = new WeakHashMap();

    protected GlassfishConfiguration(J2eeModule j2eeModule) throws ConfigurationException {
        this(j2eeModule, J2eeModuleHelper.getJ2eeModuleHelper(j2eeModule.getType()));
    }

    protected GlassfishConfiguration(J2eeModule j2eeModule, J2eeModuleHelper j2eeModuleHelper) throws ConfigurationException {
        this.module = j2eeModule;
        this.moduleHelper = j2eeModuleHelper;
        if (j2eeModuleHelper == null) {
            throw new ConfigurationException("Unsupported module type: " + j2eeModule.getType());
        }
        this.primarySunDD = j2eeModuleHelper.getPrimarySunDDFile(j2eeModule);
        this.secondarySunDD = j2eeModuleHelper.getSecondarySunDDFile(j2eeModule);
        try {
            boolean bl;
            if (null == this.primarySunDD.getParentFile()) {
                throw new ConfigurationException("module is not initialized completely");
            }
            GlassfishConfiguration.addConfiguration(this.primarySunDD, this);
            this.appServerVersion = ASDDVersion.SUN_APPSERVER_8_1;
            this.deferredAppServerChange = false;
            J2eeModule.Type type = j2eeModule.getType();
            String string = j2eeModule.getModuleVersion();
            this.minASVersion = this.computeMinASVersion(string);
            this.appServerVersion = this.maxASVersion = this.computeMaxASVersion();
            J2EEBaseVersion j2EEBaseVersion = J2EEBaseVersion.getVersion(type, string);
            boolean bl2 = j2EEBaseVersion != null ? J2EEVersion.J2EE_1_4.compareSpecification(j2EEBaseVersion) >= 0 : (bl = false);
            if (!this.primarySunDD.exists() && (J2eeModule.Type.WAR.equals(type) || bl)) {
                this.createDefaultSunDD(this.primarySunDD);
            }
            if (bl) {
                this.descriptorListener = new DescriptorListener(this);
                File file = this.primarySunDD.getParentFile();
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (fileObject != null) {
                    FolderListener.createListener(this.primarySunDD, fileObject, type);
                }
                this.addDescriptorListener(this.getStandardRootDD());
                this.addDescriptorListener((org.netbeans.modules.j2ee.dd.api.common.RootInterface)this.getWebServicesRootDD());
            }
        }
        catch (IOException iOException) {
            GlassfishConfiguration.removeConfiguration(this.primarySunDD);
            ConfigurationException configurationException = new ConfigurationException(this.primarySunDD.getAbsolutePath(), (Throwable)iOException);
            throw configurationException;
        }
        catch (RuntimeException runtimeException) {
            GlassfishConfiguration.removeConfiguration(this.primarySunDD);
            ConfigurationException configurationException = new ConfigurationException(this.primarySunDD.getAbsolutePath(), (Throwable)runtimeException);
            throw configurationException;
        }
    }

    @Deprecated
    public GlassfishConfiguration() {
        throw new UnsupportedOperationException("JSR-88 configuration not supported.");
    }

    public void dispose() {
        GlassfishConfiguration glassfishConfiguration;
        if (this.descriptorListener != null) {
            this.descriptorListener.removeListeners();
            this.descriptorListener = null;
        }
        if ((glassfishConfiguration = GlassfishConfiguration.getConfiguration(this.primarySunDD)) != this) {
            Logger.getLogger("glassfish-eecommon").log(Level.INFO, "Stored DeploymentConfiguration (" + glassfishConfiguration + ") instance not the one being disposed of (" + this + ").");
        }
        if (glassfishConfiguration != null) {
            GlassfishConfiguration.removeConfiguration(this.primarySunDD);
        }
    }

    private ASDDVersion computeMinASVersion(String string) {
        return this.moduleHelper.getMinASVersion(string, ASDDVersion.SUN_APPSERVER_7_0);
    }

    private ASDDVersion computeMaxASVersion() {
        ASDDVersion aSDDVersion = this.getTargetAppServerVersion();
        if (aSDDVersion == null) {
            aSDDVersion = ASDDVersion.SUN_APPSERVER_9_0;
            Logger.getLogger("glassfish-eecommon").log(Level.WARNING, NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_UnidentifiedTargetServer", (Object)aSDDVersion.toString()));
        }
        return aSDDVersion;
    }

    public ASDDVersion getMinASVersion() {
        return this.minASVersion;
    }

    public ASDDVersion getMaxASVersion() {
        return this.maxASVersion;
    }

    public ASDDVersion getAppServerVersion() {
        return this.appServerVersion;
    }

    public void setAppServerVersion(ASDDVersion aSDDVersion) {
        if (aSDDVersion.compareTo((Object)this.getMinASVersion()) < 0) {
            throw new IllegalArgumentException(aSDDVersion.toString() + " is lower than required minimum version " + this.getMinASVersion().toString());
        }
        if (aSDDVersion.compareTo((Object)this.getMaxASVersion()) > 0) {
            throw new IllegalArgumentException(aSDDVersion.toString() + " is higher than required maximum version " + this.getMaxASVersion().toString());
        }
        if (!aSDDVersion.equals(this.appServerVersion) || this.deferredAppServerChange) {
            this.appServerVersion = aSDDVersion;
            this.deferredAppServerChange = false;
        }
    }

    void internalSetAppServerVersion(ASDDVersion aSDDVersion) {
        if (!aSDDVersion.equals(this.appServerVersion)) {
            this.appServerVersion = aSDDVersion;
            this.deferredAppServerChange = true;
        }
    }

    protected ASDDVersion getTargetAppServerVersion() {
        ASDDVersion aSDDVersion = null;
        J2eeModuleProvider j2eeModuleProvider = this.getProvider(this.primarySunDD.getParentFile());
        String string = j2eeModuleProvider.getServerID();
        if (Arrays.asList(sunServerIds).contains(string)) {
            String string2 = j2eeModuleProvider.getServerInstanceID();
            if (Utils.notEmpty(string2)) {
                try {
                    String string3 = string2.substring(1, string2.indexOf("deployer") - 1);
                    File file = new File(string3);
                    if (file.exists()) {
                        aSDDVersion = this.getInstalledAppServerVersion(file);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    Logger.getLogger("glassfish-eecommon").log(Level.WARNING, NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_NoServerInstallLocation", (Object)string2));
                }
                catch (NullPointerException nullPointerException) {
                    Logger.getLogger("glassfish-eecommon").log(Level.INFO, nullPointerException.getLocalizedMessage(), nullPointerException);
                }
            }
        } else if ("SUNWebserver7".equals(string)) {
            aSDDVersion = ASDDVersion.SUN_APPSERVER_8_1;
        }
        return aSDDVersion;
    }

    protected ASDDVersion getInstalledAppServerVersion(File file) {
        File file2 = new File(file, "lib/dtds/");
        if (file2.exists()) {
            if (new File(file2, "sun-web-app_3_0-0.dtd").exists()) {
                return ASDDVersion.SUN_APPSERVER_10_0;
            }
            if (new File(file2, "sun-domain_1_3.dtd").exists()) {
                return ASDDVersion.SUN_APPSERVER_9_0;
            }
            if (new File(file2, "sun-domain_1_2.dtd").exists()) {
                return ASDDVersion.SUN_APPSERVER_9_0;
            }
            if (new File(file2, "sun-domain_1_1.dtd").exists()) {
                return ASDDVersion.SUN_APPSERVER_8_1;
            }
            if (new File(file2, "sun-domain_1_0.dtd").exists()) {
                return ASDDVersion.SUN_APPSERVER_7_0;
            }
        }
        return null;
    }

    protected void createDefaultSunDD(File file) throws IOException {
        FileObject fileObject = Utils.getSunDDFromProjectsModuleVersion(this.module, file.getName());
        if (fileObject != null) {
            FileObject fileObject2 = FileUtil.createFolder((File)file.getParentFile());
            FileSystem fileSystem = fileObject2.getFileSystem();
            XmlFileCreator xmlFileCreator = new XmlFileCreator(fileObject, fileObject2, fileObject.getName(), fileObject.getExt());
            fileSystem.runAtomicAction((FileSystem.AtomicAction)xmlFileCreator);
        }
    }

    public J2eeModule getJ2eeModule() {
        return this.module;
    }

    public J2EEBaseVersion getJ2eeVersion() {
        return J2EEBaseVersion.getVersion(this.module.getType(), this.module.getModuleVersion());
    }

    public org.netbeans.modules.j2ee.dd.api.common.RootInterface getStandardRootDD() {
        org.netbeans.modules.j2ee.dd.api.common.RootInterface rootInterface = null;
        J2eeModuleHelper j2eeModuleHelper = J2eeModuleHelper.getJ2eeModuleHelper(this.module.getType());
        if (j2eeModuleHelper != null) {
            rootInterface = j2eeModuleHelper.getStandardRootDD(this.module);
        }
        return rootInterface;
    }

    public Webservices getWebServicesRootDD() {
        Webservices webservices = null;
        J2eeModuleHelper j2eeModuleHelper = J2eeModuleHelper.getJ2eeModuleHelper(this.module.getType());
        if (j2eeModuleHelper != null) {
            webservices = j2eeModuleHelper.getWebServicesRootDD(this.module);
        }
        return webservices;
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> clazz) {
        return this.module.getMetadataModel(clazz);
    }

    protected J2eeModuleProvider getProvider(File file) {
        J2eeModuleProvider j2eeModuleProvider = null;
        if (file != null) {
            FileObject fileObject = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
            if (fileObject != null) {
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project != null) {
                    Lookup lookup = project.getLookup();
                    j2eeModuleProvider = (J2eeModuleProvider)lookup.lookup(J2eeModuleProvider.class);
                }
            } else {
                File file2 = file.getParentFile();
                if (file2 != null) {
                    j2eeModuleProvider = this.getProvider(file2);
                }
            }
        }
        return j2eeModuleProvider;
    }

    void updateDefaultEjbJndiName(String string, String string2, ChangeOperation changeOperation) {
        try {
            FileObject fileObject = this.getSunDD(this.primarySunDD, changeOperation == ChangeOperation.CREATE);
            if (fileObject != null) {
                boolean bl = false;
                RootInterface rootInterface = DDProvider.getDefault().getDDRoot(fileObject);
                if (rootInterface instanceof SunEjbJar) {
                    SunEjbJar sunEjbJar = (SunEjbJar)rootInterface;
                    EnterpriseBeans enterpriseBeans = sunEjbJar.getEnterpriseBeans();
                    if (enterpriseBeans == null && changeOperation == ChangeOperation.CREATE) {
                        enterpriseBeans = sunEjbJar.newEnterpriseBeans();
                        sunEjbJar.setEnterpriseBeans(enterpriseBeans);
                    }
                    if (enterpriseBeans != null) {
                        Ejb ejb = (Ejb)this.findNamedBean((CommonDDBean)enterpriseBeans, string, "Ejb", "EjbName");
                        if (ejb == null && changeOperation == ChangeOperation.CREATE) {
                            ejb = enterpriseBeans.newEjb();
                            ejb.setEjbName(string);
                            enterpriseBeans.addEjb(ejb);
                        }
                        if (ejb != null) {
                            String string3;
                            assert (string.equals(ejb.getEjbName()));
                            String string4 = string3 = string.startsWith(string2) ? string : string2 + string;
                            if (changeOperation == ChangeOperation.CREATE && Utils.strEmpty(ejb.getJndiName())) {
                                ejb.setJndiName(string3);
                                bl = true;
                            } else if (changeOperation == ChangeOperation.DELETE && Utils.strEquals(string3, ejb.getJndiName())) {
                                ejb.setJndiName(null);
                                if (ejb.isTrivial("EjbName")) {
                                    enterpriseBeans.removeEjb(ejb);
                                    if (enterpriseBeans.isTrivial(null)) {
                                        sunEjbJar.setEnterpriseBeans(null);
                                    }
                                }
                                bl = true;
                            }
                        }
                    }
                }
                if (bl) {
                    rootInterface.write(fileObject);
                }
            }
        }
        catch (IOException iOException) {
            this.handleEventRelatedIOException(iOException);
        }
        catch (Exception exception) {
            this.handleEventRelatedException(exception);
        }
    }

    void updateDefaultEjbEndpointUri(String string, String string2, ChangeOperation changeOperation) {
        try {
            FileObject fileObject = this.getSunDD(this.primarySunDD, true);
            if (fileObject != null) {
                boolean bl = false;
                RootInterface rootInterface = DDProvider.getDefault().getDDRoot(fileObject);
                if (rootInterface instanceof SunEjbJar) {
                    SunEjbJar sunEjbJar = (SunEjbJar)rootInterface;
                    EnterpriseBeans enterpriseBeans = sunEjbJar.getEnterpriseBeans();
                    if (enterpriseBeans == null && changeOperation == ChangeOperation.CREATE) {
                        enterpriseBeans = sunEjbJar.newEnterpriseBeans();
                        sunEjbJar.setEnterpriseBeans(enterpriseBeans);
                    }
                    if (enterpriseBeans != null) {
                        Ejb ejb = (Ejb)this.findNamedBean((CommonDDBean)enterpriseBeans, string, "Ejb", "EjbName");
                        if (ejb == null && changeOperation == ChangeOperation.CREATE) {
                            ejb = enterpriseBeans.newEjb();
                            ejb.setEjbName(string);
                            enterpriseBeans.addEjb(ejb);
                        }
                        if (ejb != null) {
                            assert (string.equals(ejb.getEjbName()));
                            WebserviceEndpoint webserviceEndpoint = (WebserviceEndpoint)this.findNamedBean((CommonDDBean)ejb, string2, "WebserviceEndpoint", "PortComponentName");
                            if (webserviceEndpoint == null && changeOperation == ChangeOperation.CREATE) {
                                webserviceEndpoint = ejb.newWebserviceEndpoint();
                                webserviceEndpoint.setPortComponentName(string2);
                                ejb.addWebserviceEndpoint(webserviceEndpoint);
                            }
                            if (webserviceEndpoint != null) {
                                assert (string2.equals(webserviceEndpoint.getPortComponentName()));
                                if (changeOperation == ChangeOperation.CREATE && Utils.strEmpty(webserviceEndpoint.getEndpointAddressUri())) {
                                    String string3 = string2;
                                    webserviceEndpoint.setEndpointAddressUri(string3);
                                    bl = true;
                                } else if (changeOperation == ChangeOperation.DELETE) {
                                    webserviceEndpoint.setEndpointAddressUri(null);
                                    if (webserviceEndpoint.isTrivial("PortComponentName")) {
                                        ejb.removeWebserviceEndpoint(webserviceEndpoint);
                                        if (ejb.isTrivial("EjbName")) {
                                            enterpriseBeans.removeEjb(ejb);
                                            if (enterpriseBeans.isTrivial(null)) {
                                                sunEjbJar.setEnterpriseBeans(null);
                                            }
                                        }
                                    }
                                    bl = true;
                                }
                            }
                        }
                    }
                }
                if (bl) {
                    rootInterface.write(fileObject);
                }
            }
        }
        catch (IOException iOException) {
            this.handleEventRelatedIOException(iOException);
        }
        catch (Exception exception) {
            this.handleEventRelatedException(exception);
        }
    }

    public String getContextRoot() throws ConfigurationException {
        String string = null;
        if (J2eeModule.Type.WAR.equals(this.module.getType())) {
            try {
                RootInterface rootInterface = this.getSunDDRoot(false);
                if (rootInterface instanceof SunWebApp && (string = ((SunWebApp)rootInterface).getContextRoot()) != null && string.equals("/")) {
                    string = "";
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish-eecommon").log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                String string2 = " retrieving context-root from sun-web.xml";
                this.displayError(iOException, string2);
            }
        } else {
            Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "GlassfishConfiguration.getContextRoot() invoked on incorrect module type: " + this.module.getType());
        }
        return string;
    }

    public void setContextRoot(final String string) throws ConfigurationException {
        if (J2eeModule.Type.WAR.equals(this.module.getType())) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        RootInterface rootInterface;
                        FileObject fileObject = GlassfishConfiguration.this.getSunDD(GlassfishConfiguration.this.primarySunDD, true);
                        if (fileObject != null && (rootInterface = DDProvider.getDefault().getDDRoot(fileObject)) instanceof SunWebApp) {
                            SunWebApp sunWebApp = (SunWebApp)rootInterface;
                            if (string == null || string.trim().length() == 0) {
                                sunWebApp.setContextRoot("/");
                            } else {
                                sunWebApp.setContextRoot(string);
                            }
                            sunWebApp.write(fileObject);
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("glassfish-eecommon").log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                        String string2 = " trying set context-root in sun-web.xml";
                        GlassfishConfiguration.this.displayError(iOException, string2);
                    }
                    catch (Exception exception) {
                        Logger.getLogger("glassfish-eecommon").log(Level.WARNING, exception.getLocalizedMessage(), exception);
                        String string3 = " trying set context-root in sun-web.xml";
                        GlassfishConfiguration.this.displayError(exception, string3);
                    }
                }
            });
        } else {
            Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "GlassfishConfiguration.setContextRoot() invoked on incorrect module type: " + this.module.getType());
        }
    }

    public abstract Set<Datasource> getDatasources() throws ConfigurationException;

    public abstract boolean supportsCreateDatasource();

    public abstract Datasource createDatasource(String var1, String var2, String var3, String var4, String var5) throws UnsupportedOperationException, ConfigurationException, DatasourceAlreadyExistsException;

    public void bindDatasourceReference(String string, String string2) throws ConfigurationException {
        if (Utils.strEmpty(string) || Utils.strEmpty(string2)) {
            return;
        }
        try {
            FileObject fileObject = this.getSunDD(this.primarySunDD, true);
            if (fileObject != null) {
                RootInterface rootInterface = DDProvider.getDefault().getDDRoot(fileObject);
                ResourceRef resourceRef = (ResourceRef)this.findNamedBean((CommonDDBean)rootInterface, string, "ResourceRef", "ResRefName");
                if (resourceRef != null) {
                    assert (string.equals(resourceRef.getResRefName()));
                    resourceRef.setJndiName(string2);
                } else {
                    if (rootInterface instanceof SunWebApp) {
                        resourceRef = ((SunWebApp)rootInterface).newResourceRef();
                    } else if (rootInterface instanceof SunApplicationClient) {
                        resourceRef = ((SunApplicationClient)rootInterface).newResourceRef();
                    }
                    resourceRef.setResRefName(string);
                    resourceRef.setJndiName(string2);
                    rootInterface.addValue("ResourceRef", (Object)resourceRef);
                }
                rootInterface.write(fileObject);
            }
        }
        catch (IOException iOException) {
            String string3 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingResourceRef", (Object)iOException.getClass().getSimpleName());
            throw new ConfigurationException(string3, (Throwable)iOException);
        }
        catch (Exception exception) {
            String string4 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingResourceRef", (Object)exception.getClass().getSimpleName());
            throw new ConfigurationException(string4, (Throwable)exception);
        }
    }

    public void bindDatasourceReferenceForEjb(String string, String string2, String string3, String string4) throws ConfigurationException {
        if (Utils.strEmpty(string) || Utils.strEmpty(string2) || Utils.strEmpty(string3) || Utils.strEmpty(string4)) {
            return;
        }
        try {
            RootInterface rootInterface;
            FileObject fileObject = this.getSunDD(this.primarySunDD, true);
            if (fileObject != null && (rootInterface = DDProvider.getDefault().getDDRoot(fileObject)) instanceof SunEjbJar) {
                ResourceRef resourceRef;
                Ejb ejb;
                SunEjbJar sunEjbJar = (SunEjbJar)rootInterface;
                EnterpriseBeans enterpriseBeans = sunEjbJar.getEnterpriseBeans();
                if (enterpriseBeans == null) {
                    enterpriseBeans = sunEjbJar.newEnterpriseBeans();
                    sunEjbJar.setEnterpriseBeans(enterpriseBeans);
                }
                if ((ejb = (Ejb)this.findNamedBean((CommonDDBean)enterpriseBeans, string, "Ejb", "EjbName")) == null) {
                    ejb = enterpriseBeans.newEjb();
                    ejb.setEjbName(string);
                    enterpriseBeans.addEjb(ejb);
                }
                if ((resourceRef = (ResourceRef)this.findNamedBean((CommonDDBean)ejb, string3, "ResourceRef", "ResRefName")) != null) {
                    assert (string3.equals(resourceRef.getResRefName()));
                    resourceRef.setJndiName(string4);
                } else {
                    resourceRef = ejb.newResourceRef();
                    resourceRef.setResRefName(string3);
                    resourceRef.setJndiName(string4);
                    ejb.addValue("ResourceRef", (Object)resourceRef);
                }
                sunEjbJar.write(fileObject);
            }
        }
        catch (IOException iOException) {
            String string5 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingResourceRef", (Object)iOException.getClass().getSimpleName());
            throw new ConfigurationException(string5, (Throwable)iOException);
        }
        catch (Exception exception) {
            String string6 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingResourceRef", (Object)exception.getClass().getSimpleName());
            throw new ConfigurationException(string6, (Throwable)exception);
        }
    }

    public String findDatasourceJndiName(String string) throws ConfigurationException {
        if (Utils.strEmpty(string)) {
            return null;
        }
        String string2 = null;
        try {
            RootInterface rootInterface = this.getSunDDRoot(false);
            ResourceRef resourceRef = (ResourceRef)this.findNamedBean((CommonDDBean)rootInterface, string, "ResourceRef", "ResRefName");
            if (resourceRef != null) {
                assert (string.equals(resourceRef.getResRefName()));
                string2 = resourceRef.getJndiName();
            }
        }
        catch (IOException iOException) {
            String string3 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionReadingResourceRef", (Object)iOException.getClass().getSimpleName());
            throw new ConfigurationException(string3, (Throwable)iOException);
        }
        catch (Exception exception) {
            String string4 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionReadingResourceRef", (Object)exception.getClass().getSimpleName());
            throw new ConfigurationException(string4, (Throwable)exception);
        }
        return string2;
    }

    public String findDatasourceJndiNameForEjb(String string, String string2) throws ConfigurationException {
        if (Utils.strEmpty(string) || Utils.strEmpty(string2)) {
            return null;
        }
        String string3 = null;
        try {
            ResourceRef resourceRef;
            Ejb ejb;
            SunEjbJar sunEjbJar;
            EnterpriseBeans enterpriseBeans;
            RootInterface rootInterface = this.getSunDDRoot(false);
            if (rootInterface instanceof SunEjbJar && (enterpriseBeans = (sunEjbJar = (SunEjbJar)rootInterface).getEnterpriseBeans()) != null && (ejb = (Ejb)this.findNamedBean((CommonDDBean)enterpriseBeans, string, "Ejb", "EjbName")) != null && (resourceRef = (ResourceRef)this.findNamedBean((CommonDDBean)ejb, string2, "ResourceRef", "ResRefName")) != null) {
                assert (string2.equals(resourceRef.getResRefName()));
                string3 = resourceRef.getJndiName();
            }
        }
        catch (IOException iOException) {
            String string4 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionReadingResourceRef", (Object)iOException.getClass().getSimpleName());
            throw new ConfigurationException(string4, (Throwable)iOException);
        }
        catch (Exception exception) {
            String string5 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionReadingResourceRef", (Object)exception.getClass().getSimpleName());
            throw new ConfigurationException(string5, (Throwable)exception);
        }
        return string3;
    }

    public String findJndiNameForEjb(String string) throws ConfigurationException {
        if (Utils.strEmpty(string)) {
            return null;
        }
        String string2 = null;
        try {
            Ejb ejb;
            SunEjbJar sunEjbJar;
            EnterpriseBeans enterpriseBeans;
            RootInterface rootInterface = this.getSunDDRoot(false);
            if (rootInterface instanceof SunEjbJar && (enterpriseBeans = (sunEjbJar = (SunEjbJar)rootInterface).getEnterpriseBeans()) != null && (ejb = (Ejb)this.findNamedBean((CommonDDBean)enterpriseBeans, string, "Ejb", "EjbName")) != null) {
                assert (string.equals(ejb.getEjbName()));
                string2 = ejb.getJndiName();
            }
        }
        catch (IOException iOException) {
            String string3 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionReadingEjb", (Object)iOException.getClass().getSimpleName());
            throw new ConfigurationException(string3, (Throwable)iOException);
        }
        catch (Exception exception) {
            String string4 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionReadingEjb", (Object)exception.getClass().getSimpleName());
            throw new ConfigurationException(string4, (Throwable)exception);
        }
        return string2;
    }

    public void bindEjbReference(String string, String string2) throws ConfigurationException {
        if (Utils.strEmpty(string) || Utils.strEmpty(string2)) {
            return;
        }
        try {
            if (Double.parseDouble(this.module.getModuleVersion()) > 2.45) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger("glassfish-eecommon").log(Level.WARNING, numberFormatException.getLocalizedMessage(), numberFormatException);
        }
        try {
            FileObject fileObject = this.getSunDD(this.primarySunDD, true);
            if (fileObject != null) {
                RootInterface rootInterface = DDProvider.getDefault().getDDRoot(fileObject);
                EjbRef ejbRef = (EjbRef)this.findNamedBean((CommonDDBean)rootInterface, string, "EjbRef", "EjbRefName");
                if (ejbRef != null) {
                    assert (string.equals(ejbRef.getEjbRefName()));
                    ejbRef.setJndiName(string2);
                } else {
                    if (rootInterface instanceof SunWebApp) {
                        ejbRef = ((SunWebApp)rootInterface).newEjbRef();
                    } else if (rootInterface instanceof SunApplicationClient) {
                        ejbRef = ((SunApplicationClient)rootInterface).newEjbRef();
                    }
                    ejbRef.setEjbRefName(string);
                    ejbRef.setJndiName(string2);
                    rootInterface.addValue("EjbRef", (Object)ejbRef);
                }
                rootInterface.write(fileObject);
            }
        }
        catch (IOException iOException) {
            String string3 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingEjbRef", (Object)iOException.getClass().getSimpleName());
            throw new ConfigurationException(string3, (Throwable)iOException);
        }
        catch (Exception exception) {
            String string4 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingEjbRef", (Object)exception.getClass().getSimpleName());
            throw new ConfigurationException(string4, (Throwable)exception);
        }
    }

    public void bindEjbReferenceForEjb(String string, String string2, String string3, String string4) throws ConfigurationException {
        if (Utils.strEmpty(string) || Utils.strEmpty(string2) || Utils.strEmpty(string3) || Utils.strEmpty(string4)) {
            return;
        }
        try {
            if (Double.parseDouble(this.module.getModuleVersion()) > 2.15) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger("glassfish-eecommon").log(Level.WARNING, numberFormatException.getLocalizedMessage(), numberFormatException);
        }
        try {
            RootInterface rootInterface;
            FileObject fileObject = this.getSunDD(this.primarySunDD, true);
            if (fileObject != null && (rootInterface = DDProvider.getDefault().getDDRoot(fileObject)) instanceof SunEjbJar) {
                EjbRef ejbRef;
                Ejb ejb;
                SunEjbJar sunEjbJar = (SunEjbJar)rootInterface;
                EnterpriseBeans enterpriseBeans = sunEjbJar.getEnterpriseBeans();
                if (enterpriseBeans == null) {
                    enterpriseBeans = sunEjbJar.newEnterpriseBeans();
                    sunEjbJar.setEnterpriseBeans(enterpriseBeans);
                }
                if ((ejb = (Ejb)this.findNamedBean((CommonDDBean)enterpriseBeans, string, "Ejb", "EjbName")) == null) {
                    ejb = enterpriseBeans.newEjb();
                    ejb.setEjbName(string);
                    enterpriseBeans.addEjb(ejb);
                }
                if ((ejbRef = (EjbRef)this.findNamedBean((CommonDDBean)ejb, string3, "EjbRef", "EjbRefName")) != null) {
                    assert (string3.equals(ejbRef.getEjbRefName()));
                    ejbRef.setJndiName(string4);
                } else {
                    ejbRef = ejb.newEjbRef();
                    ejbRef.setEjbRefName(string3);
                    ejbRef.setJndiName(string4);
                    ejb.addValue("EjbRef", (Object)ejbRef);
                }
                sunEjbJar.write(fileObject);
            }
        }
        catch (IOException iOException) {
            String string5 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingEjbRef", (Object)iOException.getClass().getSimpleName());
            throw new ConfigurationException(string5, (Throwable)iOException);
        }
        catch (Exception exception) {
            String string6 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingEjbRef", (Object)exception.getClass().getSimpleName());
            throw new ConfigurationException(string6, (Throwable)exception);
        }
    }

    public abstract Set<org.netbeans.modules.j2ee.deployment.common.api.MessageDestination> getMessageDestinations() throws ConfigurationException;

    public abstract boolean supportsCreateMessageDestination();

    public abstract org.netbeans.modules.j2ee.deployment.common.api.MessageDestination createMessageDestination(String var1, MessageDestination.Type var2) throws UnsupportedOperationException, ConfigurationException;

    public void bindMdbToMessageDestination(String string, String string2, MessageDestination.Type type) throws ConfigurationException {
        if (Utils.strEmpty(string) || Utils.strEmpty(string2)) {
            return;
        }
        try {
            RootInterface rootInterface;
            FileObject fileObject = this.getSunDD(this.primarySunDD, true);
            if (fileObject != null && (rootInterface = DDProvider.getDefault().getDDRoot(fileObject)) instanceof SunEjbJar) {
                Ejb ejb;
                SunEjbJar sunEjbJar = (SunEjbJar)rootInterface;
                EnterpriseBeans enterpriseBeans = sunEjbJar.getEnterpriseBeans();
                if (enterpriseBeans == null) {
                    enterpriseBeans = sunEjbJar.newEnterpriseBeans();
                    sunEjbJar.setEnterpriseBeans(enterpriseBeans);
                }
                if ((ejb = (Ejb)this.findNamedBean((CommonDDBean)enterpriseBeans, string, "Ejb", "EjbName")) == null) {
                    ejb = enterpriseBeans.newEjb();
                    ejb.setEjbName(string);
                    enterpriseBeans.addEjb(ejb);
                }
                ejb.setJndiName(string2);
                String string3 = string2 + "Factory";
                MdbConnectionFactory mdbConnectionFactory = ejb.newMdbConnectionFactory();
                mdbConnectionFactory.setJndiName(string3);
                ejb.setMdbConnectionFactory(mdbConnectionFactory);
                rootInterface.write(fileObject);
            }
        }
        catch (IOException iOException) {
            String string4 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)iOException.getClass().getSimpleName());
            throw new ConfigurationException(string4, (Throwable)iOException);
        }
        catch (Exception exception) {
            String string5 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)exception.getClass().getSimpleName());
            throw new ConfigurationException(string5, (Throwable)exception);
        }
    }

    public String findMessageDestinationName(String string) throws ConfigurationException {
        if (Utils.strEmpty(string)) {
            return null;
        }
        String string2 = null;
        try {
            Ejb ejb;
            SunEjbJar sunEjbJar;
            EnterpriseBeans enterpriseBeans;
            RootInterface rootInterface = this.getSunDDRoot(false);
            if (rootInterface instanceof SunEjbJar && (enterpriseBeans = (sunEjbJar = (SunEjbJar)rootInterface).getEnterpriseBeans()) != null && (ejb = (Ejb)this.findNamedBean((CommonDDBean)enterpriseBeans, string, "Ejb", "EjbName")) != null) {
                assert (string.equals(ejb.getEjbName()));
                string2 = ejb.getJndiName();
            }
        }
        catch (IOException iOException) {
            String string3 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)iOException.getClass().getSimpleName());
            throw new ConfigurationException(string3, (Throwable)iOException);
        }
        catch (Exception exception) {
            String string4 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)exception.getClass().getSimpleName());
            throw new ConfigurationException(string4, (Throwable)exception);
        }
        return string2;
    }

    public void bindMessageDestinationReference(String string, String string2, String string3, MessageDestination.Type type) throws ConfigurationException {
        if (Utils.strEmpty(string) || Utils.strEmpty(string2) || Utils.strEmpty(string3)) {
            return;
        }
        try {
            FileObject fileObject = this.getSunDD(this.primarySunDD, true);
            if (fileObject != null) {
                RootInterface rootInterface = DDProvider.getDefault().getDDRoot(fileObject);
                MessageDestinationRef messageDestinationRef = (MessageDestinationRef)this.findNamedBean((CommonDDBean)rootInterface, string, "MessageDestinationRef", "MessageDestinationRefName");
                if (messageDestinationRef != null) {
                    assert (string.equals(messageDestinationRef.getMessageDestinationRefName()));
                    messageDestinationRef.setJndiName(string);
                } else {
                    if (rootInterface instanceof SunWebApp) {
                        messageDestinationRef = ((SunWebApp)rootInterface).newMessageDestinationRef();
                    } else if (rootInterface instanceof SunApplicationClient) {
                        messageDestinationRef = ((SunApplicationClient)rootInterface).newMessageDestinationRef();
                    }
                    messageDestinationRef.setJndiName(string);
                    messageDestinationRef.setMessageDestinationRefName(string);
                    rootInterface.addValue("MessageDestinationRef", (Object)messageDestinationRef);
                }
                ResourceRef resourceRef = (ResourceRef)this.findNamedBean((CommonDDBean)rootInterface, string2, "ResourceRef", "ResRefName");
                if (resourceRef != null) {
                    assert (string2.equals(resourceRef.getResRefName()));
                    resourceRef.setJndiName(string2);
                } else {
                    if (rootInterface instanceof SunWebApp) {
                        resourceRef = ((SunWebApp)rootInterface).newResourceRef();
                    } else if (rootInterface instanceof SunApplicationClient) {
                        resourceRef = ((SunApplicationClient)rootInterface).newResourceRef();
                    }
                    resourceRef.setResRefName(string2);
                    resourceRef.setJndiName(string2);
                    rootInterface.addValue("ResourceRef", (Object)resourceRef);
                }
                rootInterface.write(fileObject);
            }
        }
        catch (IOException iOException) {
            String string4 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)iOException.getClass().getSimpleName());
            throw new ConfigurationException(string4, (Throwable)iOException);
        }
        catch (Exception exception) {
            String string5 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)exception.getClass().getSimpleName());
            throw new ConfigurationException(string5, (Throwable)exception);
        }
    }

    public void bindMessageDestinationReferenceForEjb(String string, String string2, String string3, String string4, String string5, MessageDestination.Type type) throws ConfigurationException {
        try {
            FileObject fileObject = this.getSunDD(this.primarySunDD, true);
            if (fileObject != null) {
                Ejb ejb;
                RootInterface rootInterface = DDProvider.getDefault().getDDRoot(fileObject);
                SunEjbJar sunEjbJar = (SunEjbJar)rootInterface;
                EnterpriseBeans enterpriseBeans = sunEjbJar.getEnterpriseBeans();
                if (enterpriseBeans == null) {
                    enterpriseBeans = sunEjbJar.newEnterpriseBeans();
                    sunEjbJar.setEnterpriseBeans(enterpriseBeans);
                }
                if ((ejb = (Ejb)this.findNamedBean((CommonDDBean)enterpriseBeans, string, "Ejb", "EjbName")) == null) {
                    ejb = enterpriseBeans.newEjb();
                    ejb.setEjbName(string);
                    enterpriseBeans.addEjb(ejb);
                }
                if ("Session".equals(string2) || "Entity".equals(string2)) {
                    ResourceRef resourceRef = (ResourceRef)this.findNamedBean((CommonDDBean)ejb, string4, "ResourceRef", "ResRefName");
                    if (resourceRef != null) {
                        assert (string3.equals(resourceRef.getResRefName()));
                        resourceRef.setJndiName(string4);
                    } else {
                        resourceRef = ejb.newResourceRef();
                        resourceRef.setResRefName(string4);
                        resourceRef.setJndiName(string4);
                        ejb.addResourceRef(resourceRef);
                    }
                    MessageDestinationRef messageDestinationRef = (MessageDestinationRef)this.findNamedBean((CommonDDBean)ejb, string3, "MessageDestinationRef", "MessageDestinationRefName");
                    if (messageDestinationRef != null) {
                        assert (string3.equals(messageDestinationRef.getMessageDestinationRefName()));
                        messageDestinationRef.setJndiName(string3);
                    } else {
                        messageDestinationRef = ejb.newMessageDestinationRef();
                        messageDestinationRef.setJndiName(string3);
                        messageDestinationRef.setMessageDestinationRefName(string3);
                        ejb.addMessageDestinationRef(messageDestinationRef);
                    }
                } else if ("MessageDriven".equals(string2)) {
                    ejb.setJndiName(string3);
                    MdbConnectionFactory mdbConnectionFactory = ejb.newMdbConnectionFactory();
                    mdbConnectionFactory.setJndiName(string4);
                    ejb.setMdbConnectionFactory(mdbConnectionFactory);
                    MessageDestination messageDestination = (MessageDestination)this.findNamedBean((CommonDDBean)enterpriseBeans, string3, "MessageDestination", "JndiName");
                    if (messageDestination == null) {
                        messageDestination = enterpriseBeans.newMessageDestination();
                        messageDestination.setJndiName(string3);
                        enterpriseBeans.addMessageDestination(messageDestination);
                    }
                }
                rootInterface.write(fileObject);
            }
        }
        catch (IOException iOException) {
            String string6 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)iOException.getClass().getSimpleName());
            throw new ConfigurationException(string6, (Throwable)iOException);
        }
        catch (Exception exception) {
            String string7 = NbBundle.getMessage(GlassfishConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)exception.getClass().getSimpleName());
            throw new ConfigurationException(string7, (Throwable)exception);
        }
    }

    public void saveConfiguration(OutputStream outputStream) throws ConfigurationException {
        try {
            if (this.module.getType().equals(J2eeModule.Type.WAR)) {
                FileObject fileObject = FileUtil.toFileObject((File)this.primarySunDD);
                if (fileObject != null) {
                    RootInterface rootInterface = DDProvider.getDefault().getDDRoot(fileObject);
                    rootInterface.write(outputStream);
                }
            } else {
                Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "Deployment plan not supported in GlassfishConfiguration.save()");
            }
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.getMessage(), (Throwable)exception);
        }
    }

    protected RootInterface getSunDDRoot(boolean bl) throws IOException {
        RootInterface rootInterface = null;
        FileObject fileObject = this.getSunDD(this.primarySunDD, bl);
        if (fileObject != null) {
            rootInterface = DDProvider.getDefault().getDDRoot(fileObject);
        }
        return rootInterface;
    }

    public RootInterface getSunDDRoot(File file, boolean bl) throws IOException {
        RootInterface rootInterface = null;
        FileObject fileObject = this.getSunDD(file, bl);
        if (fileObject != null) {
            rootInterface = DDProvider.getDefault().getDDRoot(fileObject);
        }
        return rootInterface;
    }

    protected FileObject getSunDD(File file, boolean bl) throws IOException {
        if (!file.exists()) {
            if (bl) {
                this.createDefaultSunDD(file);
            } else {
                return null;
            }
        }
        return FileUtil.toFileObject((File)file);
    }

    protected void displayError(Exception exception, String string) {
        String string2 = exception.getLocalizedMessage();
        if (string2 == null || string2.length() == 0) {
            string2 = exception.getClass().getSimpleName() + string;
        }
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
    }

    protected <T extends CommonDDBean> T findNamedBean(CommonDDBean commonDDBean, String string, String string2, String string3) {
        CommonDDBean commonDDBean2 = null;
        CommonDDBean[] commonDDBeanArray = (CommonDDBean[])commonDDBean.getValues(string2);
        if (commonDDBeanArray != null) {
            for (int i = 0; i < commonDDBeanArray.length; ++i) {
                String string4 = (String)commonDDBeanArray[i].getValue(string3);
                if (!string.equals(string4)) continue;
                commonDDBean2 = commonDDBeanArray[i];
                break;
            }
        }
        return (T)commonDDBean2;
    }

    void addDescriptorListener(FileObject fileObject) {
        this.addDescriptorListener((org.netbeans.modules.j2ee.dd.api.common.RootInterface)("webservices.xml".equals(fileObject.getNameExt()) ? this.getWebServicesRootDD() : this.getStandardRootDD()));
    }

    protected void addDescriptorListener(org.netbeans.modules.j2ee.dd.api.common.RootInterface rootInterface) {
        if (rootInterface != null) {
            this.descriptorListener.addListener(rootInterface);
        }
    }

    protected void handleEventRelatedIOException(IOException iOException) {
        Logger.getLogger("glassfish-eecommon").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
    }

    protected void handleEventRelatedException(Exception exception) {
        Logger.getLogger("glassfish-eecommon").log(Level.INFO, exception.getLocalizedMessage(), exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfiguration(File file, GlassfishConfiguration glassfishConfiguration) {
        Object object = configurationMonitor;
        synchronized (object) {
            configurationMap.put(file, new WeakReference<GlassfishConfiguration>(glassfishConfiguration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConfiguration(File file) {
        Object object = configurationMonitor;
        synchronized (object) {
            configurationMap.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlassfishConfiguration getConfiguration(File file) {
        GlassfishConfiguration glassfishConfiguration = null;
        WeakReference<GlassfishConfiguration> weakReference = null;
        Object object = configurationMonitor;
        synchronized (object) {
            weakReference = configurationMap.get(file);
        }
        if (weakReference != null) {
            glassfishConfiguration = (GlassfishConfiguration)weakReference.get();
        }
        return glassfishConfiguration;
    }

    public static enum ChangeOperation {
        CREATE,
        DELETE;

    }
}

