/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.api;

public interface ThreadState {
    public static final int POINTS = 100;

    public int size();

    public MSAState getMSAState(int var1, boolean var2);

    public byte getState(int var1);

    public long getTimeStamp(int var1);

    public long getTimeStamp();

    public long getMSASamplePeriod();

    public int getSamplingStateIndex(boolean var1);

    public static enum MSAState {
        START_SHORT_LIST(new int[0]),
        Running(0, 1, 2),
        Sleeping(3, 4, 5, 7),
        Waiting(8),
        Blocked(6),
        Stopped(9),
        END_SHORT_LIST(new int[0]),
        START_LONG_LIST(new int[0]),
        RunningUser(0),
        RunningSystemCall(1),
        RunningOther(2),
        SleepingUserTextPageFault(3),
        SleepingUserDataPageFault(4),
        SleepingKernelPageFault(5),
        SleepingUserLock(6),
        SleepingOther(7),
        WaitingCPU(8),
        ThreadStopped(9),
        END_LONG_LIST(new int[0]),
        ThreadFinished(new int[0]);

        private final int[] codes;

        private MSAState(int ... codes) {
            this.codes = codes;
        }

        public boolean matches(int code) {
            for (int x : this.codes) {
                if (x != code) continue;
                return true;
            }
            return false;
        }

        public static MSAState fromCode(int code, boolean full) {
            int start = full ? START_LONG_LIST.ordinal() : START_SHORT_LIST.ordinal();
            int end = full ? END_LONG_LIST.ordinal() : END_SHORT_LIST.ordinal();
            for (int i = start; i < end; ++i) {
                MSAState state = MSAState.values()[i];
                if (!state.matches(code)) continue;
                return state;
            }
            return null;
        }
    }
}

