/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.Component;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;

public class Waiter
implements Waitable,
Timeoutable,
Outputable {
    private static final long TIME_DELTA = 10L;
    private static final long WAIT_TIME = 60000L;
    private static final long AFTER_WAIT_TIME = 0L;
    private Waitable waitable;
    private long startTime = 0L;
    private long endTime = -1L;
    private Object result;
    private Timeouts timeouts;
    private TestOut out;

    public Waiter(Waitable w) {
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.waitable = w;
    }

    protected Waiter() {
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        this.out = out;
    }

    public TestOut getOutput() {
        return this.out;
    }

    public Object waitAction(Object waitableObject) throws InterruptedException {
        this.startTime = System.currentTimeMillis();
        this.out.printTrace(this.getWaitingStartedMessage());
        this.out.printGolden(this.getGoldenWaitingStartedMessage());
        long timeDelta = this.timeouts.getTimeout("Waiter.TimeDelta");
        while ((this.result = this.checkActionProduced(waitableObject)) == null) {
            Thread.currentThread();
            Thread.sleep(timeDelta);
            if (!this.timeoutExpired()) continue;
            this.out.printError(this.getTimeoutExpiredMessage(this.timeFromStart()));
            this.out.printGolden(this.getGoldenTimeoutExpiredMessage());
            throw new TimeoutExpiredException(this.getActualDescription());
        }
        this.endTime = System.currentTimeMillis();
        this.out.printTrace(this.getActionProducedMessage(this.endTime - this.startTime, this.result));
        this.out.printGolden(this.getGoldenActionProducedMessage());
        Thread.currentThread();
        Thread.sleep(this.timeouts.getTimeout("Waiter.AfterWaitingTime"));
        return this.result;
    }

    public Object actionProduced(Object obj) {
        return Boolean.TRUE;
    }

    public String getDescription() {
        return "Unknown waiting";
    }

    protected String getWaitingStartedMessage() {
        return "Start to wait action \"" + this.getActualDescription() + "\"";
    }

    protected String getTimeoutExpiredMessage(long timeSpent) {
        return "\"" + this.getActualDescription() + "\" action has not been produced in " + new Long(timeSpent).toString() + " milliseconds";
    }

    protected String getActionProducedMessage(long timeSpent, final Object result) {
        String resultToString = result instanceof Component ? (String)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("result.toString()"){

            public Object launch() {
                return result.toString();
            }
        }) : result.toString();
        return "\"" + this.getActualDescription() + "\" action has been produced in " + new Long(timeSpent).toString() + " milliseconds with result " + "\n    : " + resultToString;
    }

    protected String getGoldenWaitingStartedMessage() {
        return "Start to wait action \"" + this.getActualDescription() + "\"";
    }

    protected String getGoldenTimeoutExpiredMessage() {
        return "\"" + this.getActualDescription() + "\" action has not been produced";
    }

    protected String getGoldenActionProducedMessage() {
        return "\"" + this.getActualDescription() + "\" action has been produced";
    }

    protected long timeFromStart() {
        return System.currentTimeMillis() - this.startTime;
    }

    private Object checkActionProduced(Object obj) {
        if (this.waitable != null) {
            return this.waitable.actionProduced(obj);
        }
        return this.actionProduced(obj);
    }

    private String getActualDescription() {
        if (this.waitable != null) {
            return this.waitable.getDescription();
        }
        return this.getDescription();
    }

    private boolean timeoutExpired() {
        return this.timeFromStart() > this.timeouts.getTimeout("Waiter.WaitingTime");
    }

    static {
        Timeouts.initDefault("Waiter.TimeDelta", 10L);
        Timeouts.initDefault("Waiter.WaitingTime", 60000L);
        Timeouts.initDefault("Waiter.AfterWaitingTime", 0L);
    }
}

