/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.treeview;

import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.mobility.end2end.ui.treeview.MethodCheckedNodeEditor;
import org.netbeans.modules.mobility.end2end.ui.treeview.MethodCheckedNodeRenderer;
import org.netbeans.modules.mobility.end2end.ui.treeview.MultiStateCheckBox;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class MethodCheckedTreeBeanView
extends BeanTreeView
implements Runnable {
    private Node root;
    private MethodCheckedNodeEditor editor;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    public static final String rootPath = "#root";
    private final Node waitNode = new AbstractNode(Children.LEAF);

    public MethodCheckedTreeBeanView() {
        FocusListener[] fl = this.tree.getFocusListeners();
        for (int i = 0; i < fl.length; ++i) {
            if (!fl[i].getClass().getName().startsWith("org.openide")) continue;
            this.tree.removeFocusListener(fl[i]);
        }
        MouseListener[] ml = this.tree.getMouseListeners();
        for (int i = 0; i < ml.length; ++i) {
            if (!ml[i].getClass().getName().startsWith("org.openide")) continue;
            this.tree.removeMouseListener(ml[i]);
        }
    }

    public String getToolTipText(MouseEvent event) {
        return super.getToolTipText(event);
    }

    public Node getWaitNode() {
        return this.waitNode;
    }

    public void setEditable(boolean editable) {
        this.tree.setEditable(editable);
        this.tree.setBackground(UIManager.getDefaults().getColor(editable ? "Tree.background" : "TextField.inactiveBackground"));
    }

    public void setRoot(Node root) {
        this.root = root;
        this.tree.setCellRenderer(new MethodCheckedNodeRenderer());
        this.editor = new MethodCheckedNodeEditor(this.tree);
        this.tree.setCellEditor(this.editor);
        this.tree.setEditable(true);
        this.editor.setContentStorage(this);
        this.updateMixedStates(root);
    }

    public synchronized void updateTreeNodeStates(Node n) {
        if (this.root == null) {
            return;
        }
        if (n != null) {
            this.forceState(n.getChildren(), (MultiStateCheckBox.State)((Object)n.getValue("isSelected")));
        }
        this.updateMixedStates(this.root);
        this.fireChange();
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        TreePath tp = this.tree.getSelectionPath();
        if (tp != null) {
            this.tree.setSelectionPath(null);
        }
    }

    private void forceState(Children ch, MultiStateCheckBox.State state) {
        for (Node n : ch.getNodes()) {
            n.setValue("isSelected", (Object)state);
            this.forceState(n.getChildren(), state);
        }
    }

    private MultiStateCheckBox.State updateMixedStates(Node pn) {
        Children ch = pn.getChildren();
        MultiStateCheckBox.State ret = null;
        for (Node n : pn.getChildren().getNodes()) {
            if (n.getValue("isValid") == Boolean.FALSE) continue;
            MultiStateCheckBox.State state = this.updateMixedStates(n);
            if (ret == null) {
                ret = state;
                continue;
            }
            if (state == ret) continue;
            ret = MultiStateCheckBox.State.MIXED;
        }
        if (ret == null) {
            ret = (MultiStateCheckBox.State)((Object)pn.getValue("isSelected"));
        }
        if (ret == null) {
            ret = MultiStateCheckBox.State.UNSELECTED;
        }
        pn.setValue("isSelected", (Object)ret);
        return ret;
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(e);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }
}

