/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class ThreadsNodeModel
implements NodeModel {
    public static final String CURRENT_THREAD = "org/netbeans/modules/debugger/resources/threadsView/CurrentThread";
    public static final String RUNNING_THREAD = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    private final Collection<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public ThreadsNodeModel(ContextProvider lookupProvider) {
        GdbDebugger debugger = (GdbDebugger)lookupProvider.lookupFirst(null, GdbDebugger.class);
        new Listener(this, debugger);
    }

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_Column_Name_Name");
        }
        if ("No current thread" == o) {
            return NbBundle.getMessage(ThreadsNodeModel.class, (String)"CTL_ThreadsModel_MSG_NoCurrentThread");
        }
        if ("Thread is running" == o) {
            return NbBundle.getMessage(ThreadsNodeModel.class, (String)"CTL_ThreadsModel_MSG_ThreadIsRunning");
        }
        if (o instanceof String) {
            String line = o.toString();
            if (line.startsWith("* ")) {
                return this.bold(line.substring(2));
            }
            return line;
        }
        throw new UnknownTypeException(o);
    }

    public String getShortDescription(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_Column_Name_Desc");
        }
        if ("No current thread" == o) {
            return NbBundle.getMessage(ThreadsNodeModel.class, (String)"CTL_ThreadsModel_MSG_NoCurrentThread");
        }
        if ("Thread is running" == o) {
            return NbBundle.getMessage(ThreadsNodeModel.class, (String)"CTL_ThreadsModel_MSG_ThreadIsRunning");
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            String row = node.toString();
            if (row.charAt(0) == '*') {
                return CURRENT_THREAD;
            }
            return RUNNING_THREAD;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTreeChanged() {
        for (ModelListener listener : this.listeners) {
            listener.modelChanged(null);
        }
    }

    private String bold(String value) {
        return ThreadsNodeModel.toHTML(value, true, false, null);
    }

    public static String toHTML(String text, boolean bold, boolean italics, Color color) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        if (bold) {
            sb.append("<b>");
        }
        if (italics) {
            sb.append("<i>");
        }
        if (color != null) {
            sb.append("<font color=");
            sb.append(Integer.toHexString(color.getRGB() & 0xFFFFFF));
            sb.append(">");
        }
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        sb.append(text);
        if (color != null) {
            sb.append("</font>");
        }
        if (italics) {
            sb.append("</i>");
        }
        if (bold) {
            sb.append("</b>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    private static class Listener
    implements PropertyChangeListener {
        private final WeakReference<ThreadsNodeModel> ref;
        private final GdbDebugger debugger;

        private Listener(ThreadsNodeModel tnm, GdbDebugger debugger) {
            this.ref = new WeakReference<ThreadsNodeModel>(tnm);
            this.debugger = debugger;
            debugger.addPropertyChangeListener("currentCallStackFrame", this);
        }

        private ThreadsNodeModel getModel() {
            ThreadsNodeModel tnm = (ThreadsNodeModel)this.ref.get();
            if (tnm == null) {
                this.debugger.removePropertyChangeListener("currentCallStackFrame", this);
            }
            return tnm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            ThreadsNodeModel tnm = this.getModel();
            if (tnm == null) {
                return;
            }
            tnm.fireTreeChanged();
        }
    }
}

