/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.api.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.api.customization.model.JavaClass;
import org.netbeans.modules.websvc.api.customization.model.PortTypeOperationFaultCustomization;
import org.netbeans.modules.websvc.api.wseditor.SaveSetter;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.WeakListeners;

public class PortTypeOperationFaultPanel
extends SaveableSectionInnerPanel {
    private Fault fault;
    private SaveSetter setter;
    private WSDLModel model;
    private boolean wsdlDirty;
    private DefaultItemListener defaultListener;
    private JCheckBox defaultJavaClassCB;
    private JLabel javaClassLabel;
    private JTextField javaClassText;
    private JLabel operationLabel;
    private JLabel operationName;

    public PortTypeOperationFaultPanel(SectionView sectionView, Fault fault) {
        super(sectionView);
        this.fault = fault;
        this.model = this.fault.getModel();
        this.initComponents();
        this.disableEnterKey();
        this.sync();
        this.addModifier(this.javaClassText);
        this.addModifier(this.defaultJavaClassCB);
        this.addValidatee(this.javaClassText);
        this.defaultListener = new DefaultItemListener();
        ItemListener itemListener = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.defaultListener, (Object)this.defaultJavaClassCB);
        this.defaultJavaClassCB.addItemListener(itemListener);
    }

    private String getParentOfFault(Fault fault) {
        Operation operation = (Operation)fault.getParent();
        return operation.getName();
    }

    private void sync() {
        List list = this.fault.getExtensibilityElements(PortTypeOperationFaultCustomization.class);
        if (list.size() == 1) {
            PortTypeOperationFaultCustomization portTypeOperationFaultCustomization = (PortTypeOperationFaultCustomization)list.get(0);
            JavaClass javaClass = portTypeOperationFaultCustomization.getJavaClass();
            if (javaClass != null) {
                this.setJavaClass(javaClass.getName());
            } else {
                this.defaultJavaClassCB.setSelected(true);
                this.javaClassText.setEnabled(false);
            }
        } else {
            this.defaultJavaClassCB.setSelected(true);
            this.javaClassText.setEnabled(false);
        }
    }

    public void setJavaClass(String string) {
        this.javaClassText.setText(string);
    }

    public String getJavaClass() {
        return this.javaClassText.getText();
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List list = this.fault.getExtensibilityElements(PortTypeOperationFaultCustomization.class);
        CustomizationComponentFactory customizationComponentFactory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.javaClassText || jComponent == this.defaultJavaClassCB) {
            String string = this.javaClassText.getText();
            if (string != null && !string.trim().equals("") && !this.defaultJavaClassCB.isSelected()) {
                if (!JaxWsUtils.isJavaIdentifier((String)string)) {
                    return;
                }
                if (list.size() == 1) {
                    PortTypeOperationFaultCustomization portTypeOperationFaultCustomization = (PortTypeOperationFaultCustomization)list.get(0);
                    JavaClass javaClass = portTypeOperationFaultCustomization.getJavaClass();
                    if (javaClass == null) {
                        try {
                            javaClass = customizationComponentFactory.createJavaClass(this.model);
                            this.model.startTransaction();
                            javaClass.setName(string);
                            portTypeOperationFaultCustomization.setJavaClass(javaClass);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    } else {
                        try {
                            this.model.startTransaction();
                            javaClass.setName(string);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                } else {
                    PortTypeOperationFaultCustomization portTypeOperationFaultCustomization = customizationComponentFactory.createPortTypeOperationFaultCustomization(this.model);
                    JavaClass javaClass = customizationComponentFactory.createJavaClass(this.model);
                    try {
                        this.model.startTransaction();
                        javaClass.setName(string);
                        portTypeOperationFaultCustomization.setJavaClass(javaClass);
                        this.fault.addExtensibilityElement((ExtensibilityElement)portTypeOperationFaultCustomization);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else if (list.size() == 1) {
                try {
                    PortTypeOperationFaultCustomization portTypeOperationFaultCustomization = (PortTypeOperationFaultCustomization)list.get(0);
                    JavaClass javaClass = portTypeOperationFaultCustomization.getJavaClass();
                    if (javaClass != null) {
                        this.model.startTransaction();
                        portTypeOperationFaultCustomization.removeJavaClass(javaClass);
                        if (portTypeOperationFaultCustomization.getChildren().size() == 0) {
                            this.fault.removeExtensibilityElement((ExtensibilityElement)portTypeOperationFaultCustomization);
                        }
                        this.wsdlDirty = true;
                    }
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        if (jTextComponent == this.javaClassText && !JaxWsUtils.isJavaIdentifier((String)string)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, string, (JComponent)jTextComponent));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (jTextComponent == this.javaClassText) {
            PortTypeOperationFaultCustomization portTypeOperationFaultCustomization;
            JavaClass javaClass;
            String string = "";
            List list = this.fault.getExtensibilityElements(PortTypeOperationFaultCustomization.class);
            if (list.size() == 1 && (javaClass = (portTypeOperationFaultCustomization = (PortTypeOperationFaultCustomization)list.get(0)).getJavaClass()) != null) {
                string = javaClass.getName();
            }
            this.javaClassText.setText(string);
        }
    }

    @Override
    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    @Override
    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.javaClassLabel = new JLabel();
        this.javaClassText = new JTextField();
        this.defaultJavaClassCB = new JCheckBox();
        this.operationLabel = new JLabel();
        this.operationName = new JLabel();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.javaClassLabel.setText(resourceBundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.setToolTipText(resourceBundle.getString("TOOLTIP_PORTTYPE_FAULT_CLASS"));
        this.defaultJavaClassCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultJavaClassCB.setText("Use Default");
        this.defaultJavaClassCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultJavaClassCB.setContentAreaFilled(false);
        this.defaultJavaClassCB.setMargin(new Insets(0, 0, 0, 0));
        this.operationLabel.setText(resourceBundle.getString("LBL_ENCLOSING_OPERATION"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.javaClassLabel).add(15, 15, 15).add((Component)this.javaClassText, -2, 227, -2).add(20, 20, 20).add((Component)this.defaultJavaClassCB)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.operationLabel).add(15, 15, 15).add((Component)this.operationName, -2, 165, -2))).addContainerGap(76, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.operationLabel).add((Component)this.operationName)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.javaClassLabel).add((Component)this.javaClassText, -2, 16, -2).add((Component)this.defaultJavaClassCB)).addContainerGap(19, Short.MAX_VALUE)));
        this.javaClassLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_JAVA_CLASS"));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.operationLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENCLOSING_OPERATION"));
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (PortTypeOperationFaultPanel.this.defaultJavaClassCB.isSelected()) {
                PortTypeOperationFaultPanel.this.javaClassText.setEnabled(false);
            } else {
                PortTypeOperationFaultPanel.this.javaClassText.setEnabled(true);
                PortTypeOperationFaultPanel.this.javaClassText.requestFocus();
            }
        }
    }
}

