/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.AddAPIPanel;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CustomizerPermissions
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ListSelectionListener {
    static final String[] PROPERTY_GROUP = new String[]{"manifest.apipermissions"};
    protected JTable table;
    protected StorableTableModel tableModel;
    private VisualPropertySupport vps;
    private String configuration;
    private String configurationProfileValue;
    private String defaultProfileValue;
    private JButton bAdd;
    private JButton bRemove;
    private JCheckBox cDefault;
    private JLabel lError;
    private JLabel lTable;
    private JScrollPane scrollPane;

    public CustomizerPermissions() {
        this.initComponents();
        this.initAccessibility();
        this.tableModel = new StorableTableModel();
        this.table = new JTable(this.tableModel);
        this.scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        TableColumn col0 = this.table.getColumnModel().getColumn(0);
        TableColumn col1 = this.table.getColumnModel().getColumn(1);
        col0.setResizable(true);
        col0.setPreferredWidth(300);
        col1.setResizable(true);
        col1.setPreferredWidth(80);
    }

    private void initComponents() {
        this.cDefault = new JCheckBox();
        this.lTable = new JLabel();
        this.scrollPane = new JScrollPane();
        this.bAdd = new JButton();
        this.bRemove = new JButton();
        this.lError = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cDefault, (String)NbBundle.getMessage(CustomizerPermissions.class, (String)"LBL_Use_Default"));
        this.cDefault.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cDefault, gridBagConstraints);
        this.lTable.setLabelFor(this.lTable);
        Mnemonics.setLocalizedText((JLabel)this.lTable, (String)NbBundle.getMessage(CustomizerPermissions.class, (String)"LBL_Perm_Table"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.lTable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(CustomizerPermissions.class, (String)"LBL_Perm_Add"));
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPermissions.this.bAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 11, 5, 0);
        this.add((Component)this.bAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(CustomizerPermissions.class, (String)"LBL_Perm_Remove"));
        this.bRemove.setEnabled(false);
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPermissions.this.bRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 5, 0);
        this.add((Component)this.bRemove, gridBagConstraints);
        this.lError.setForeground(new Color(89, 79, 191));
        Mnemonics.setLocalizedText((JLabel)this.lError, (String)NbBundle.getMessage(CustomizerPermissions.class, (String)"ERR_Perm_NotUsed"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.lError, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPermissions.class, (String)"ACSN_Perm"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPermissions.class, (String)"ACSD_Perm"));
    }

    private void bAddActionPerformed(ActionEvent evt) {
        final AddAPIPanel add = new AddAPIPanel(this.tableModel.getKeys());
        DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(CustomizerPermissions.class, (String)"TITLE_AddAPI"), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                    int row = CustomizerPermissions.this.tableModel.addRow(add.getAPIName());
                    CustomizerPermissions.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        });
        add.setDialogDescriptor(dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
    }

    private void bRemoveActionPerformed(ActionEvent evt) {
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return;
        }
        this.tableModel.removeRow(i);
        int max = this.tableModel.getRowCount();
        if (max <= 0) {
            this.table.getSelectionModel().clearSelection();
        } else if (i < max) {
            this.table.getSelectionModel().setSelectionInterval(i, i);
        } else {
            this.table.getSelectionModel().setSelectionInterval(max - 1, max - 1);
        }
    }

    @Override
    public void initValues(ProjectProperties props, String configuration) {
        this.configuration = configuration;
        this.configurationProfileValue = (String)props.get(VisualPropertySupport.translatePropertyName(configuration, "platform.profile", false));
        this.defaultProfileValue = (String)props.get("platform.profile");
        this.vps = VisualPropertySupport.getDefault(props);
        this.vps.register(this.cDefault, configuration, this);
    }

    @Override
    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    @Override
    public void initGroupValues(boolean useDefault) {
        String value = null;
        if (this.configuration != null) {
            value = this.configurationProfileValue;
        }
        if (value == null) {
            value = this.defaultProfileValue;
        }
        boolean notMIDP10 = value != null && !value.equals("MIDP-1.0");
        this.vps.register(this.tableModel, new String[]{"manifest.apipermissions"}, useDefault);
        this.bAdd.setEnabled(!useDefault);
        this.bRemove.setEnabled(!useDefault);
        this.table.setEnabled(!useDefault);
        this.lTable.setEnabled(!useDefault);
        this.table.setBackground(UIManager.getDefaults().getColor(useDefault ? "TextField.inactiveBackground" : "Table.background"));
        this.valueChanged(null);
        this.lError.setVisible(!notMIDP10);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.bRemove.setEnabled(this.table.isEnabled() && this.table.getSelectedRow() >= 0);
    }

    public static class StorableTableModel
    extends AbstractTableModel
    implements VisualPropertySupport.StorableTableModel {
        private HashMap<String, String> map = new HashMap();
        private final ArrayList<Item> items = new ArrayList();
        private static final long serialVersionUID = -6523408202243150812L;

        public HashSet<String> getKeys() {
            HashSet<String> set = new HashSet<String>();
            for (int a = 0; a < this.items.size(); ++a) {
                set.add(this.items.get(a).getName());
            }
            return set;
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return NbBundle.getMessage(CustomizerPermissions.class, (String)"LBL_Perm_Column_API");
                }
                case 1: {
                    return NbBundle.getMessage(CustomizerPermissions.class, (String)"LBL_Perm_Column_Required");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            return null;
        }

        @Override
        public synchronized Object[] getDataDelegates() {
            this.updateMapFromItems();
            return new Object[]{this.map};
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            assert (rowIndex < this.items.size());
            switch (columnIndex) {
                case 0: {
                    return this.items.get(rowIndex);
                }
                case 1: {
                    return this.items.get(rowIndex).isRequired();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            assert (columnIndex == 1 && value instanceof Boolean);
            this.items.get(rowIndex).setRequired((Boolean)value);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        @Override
        public synchronized void setDataDelegates(Object[] data) {
            assert (data != null);
            this.map = data[0] == null ? new HashMap() : (HashMap)data[0];
            this.updateItemsFromMap();
            this.fireTableDataChanged();
        }

        public void updateItemsFromMap() {
            StringTokenizer tokens;
            this.items.clear();
            String perms = this.map.get("MIDlet-Permissions");
            if (perms != null) {
                tokens = new StringTokenizer(perms, ",");
                while (tokens.hasMoreTokens()) {
                    this.items.add(new Item(tokens.nextToken().trim(), true));
                }
            }
            if ((perms = this.map.get("MIDlet-Permissions-Opt")) != null) {
                tokens = new StringTokenizer(perms, ",");
                while (tokens.hasMoreTokens()) {
                    this.items.add(new Item(tokens.nextToken().trim(), false));
                }
            }
        }

        public void updateMapFromItems() {
            ArrayList<String> req = new ArrayList<String>();
            ArrayList<String> opt = new ArrayList<String>();
            for (int a = 0; a < this.items.size(); ++a) {
                Item i = this.items.get(a);
                if (i.isRequired()) {
                    req.add(i.getName());
                    continue;
                }
                opt.add(i.getName());
            }
            this.map = new HashMap();
            if (req.size() > 0) {
                this.map.put("MIDlet-Permissions", this.commaSeparatedList(req));
            }
            if (opt.size() > 0) {
                this.map.put("MIDlet-Permissions-Opt", this.commaSeparatedList(opt));
            }
        }

        public String commaSeparatedList(ArrayList<String> list) {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            if (list != null) {
                for (int a = 0; a < list.size(); ++a) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(list.get(a));
                }
            }
            return sb.toString();
        }

        public int addRow(String name) {
            int row = this.items.size();
            this.items.add(new Item(name, true));
            this.fireTableRowsInserted(row, row);
            return row;
        }

        public void removeRow(int row) {
            assert (row < this.items.size());
            this.items.remove(row);
            this.fireTableRowsDeleted(row, this.items.size() + 1);
        }

        static class Item {
            private final String name;
            private boolean required;

            public Item(String name, boolean required) {
                this.name = name;
                this.required = required;
            }

            public String getName() {
                return this.name;
            }

            public boolean isRequired() {
                return this.required;
            }

            public void setRequired(boolean required) {
                this.required = required;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

