/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfNameLookupTable;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfDebugInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfNameLookupTableSection
extends ElfSection {
    private ArrayList<DwarfNameLookupTable> tables = null;

    public DwarfNameLookupTableSection(DwarfReader reader, int sectionIdx) {
        super(reader, sectionIdx);
    }

    public ArrayList<DwarfNameLookupTable> getNameLookupTables() {
        if (this.tables == null) {
            try {
                this.tables = this.readNameLookupTables();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return this.tables;
    }

    private ArrayList<DwarfNameLookupTable> readNameLookupTables() throws IOException {
        ArrayList<DwarfNameLookupTable> result = new ArrayList<DwarfNameLookupTable>();
        long currPos = this.reader.getFilePointer();
        this.reader.seek(this.header.getSectionOffset());
        DwarfDebugInfoSection debugInfo = (DwarfDebugInfoSection)this.reader.getSection(".debug_info");
        long bytesToRead = this.header.getSectionSize();
        while (bytesToRead > 0L) {
            long entryOffset;
            DwarfNameLookupTable table = new DwarfNameLookupTable();
            table.unit_length = this.reader.readDWlen();
            bytesToRead -= table.unit_length + 4L;
            table.version = this.reader.readShort();
            table.debug_info_offset = this.reader.read3264();
            table.debug_info_length = this.reader.read3264();
            CompilationUnit cu = debugInfo.getCompilationUnit(table.debug_info_offset);
            if (cu == null) continue;
            while ((entryOffset = this.reader.read3264()) != 0L) {
                table.addEntry(entryOffset, this.reader.readString());
            }
            result.add(table);
        }
        this.reader.seek(currPos);
        return result;
    }

    @Override
    public void dump(PrintStream out) {
        super.dump(out);
        for (DwarfNameLookupTable table : this.tables) {
            table.dump(out);
        }
    }

    @Override
    public String toString() {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(st);
        this.dump(out);
        return st.toString();
    }

    public DwarfNameLookupTable getNameLookupTableFor(long info_offset) {
        for (DwarfNameLookupTable table : this.getNameLookupTables()) {
            if (table.debug_info_offset != info_offset) continue;
            return table;
        }
        return null;
    }
}

