/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class Util {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(\\.(\\d+)\\.?(\\w+)?(-\\S+)?)?");
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());
    private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    private static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    private static final String FIRST_TIME_KEY = "platform-manager-called-first-time";
    private static final String FETCH_ALL_VERSIONS = "gem-manager-fetch-all-versions";
    private static final String FETCH_GEM_DESCRIPTIONS = "gem-manager-fetch-descriptions";
    private static final String RVM_RUBIES_PATH = ".rvm" + File.separator + "rubies";
    public static final Comparator<String> VERSION_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String v1, String v2) {
            return Util.compareVersions(v1, v2);
        }
    };

    private Util() {
    }

    public static boolean containsAnsiColors(String line) {
        return line.indexOf("\u001b[") != -1;
    }

    public static String stripAnsiColors(String line) {
        StringBuilder sb = new StringBuilder(line.length());
        int index = 0;
        int max = line.length();
        block0: while (index < max) {
            int n;
            int nextEscape = line.indexOf("\u001b[", index);
            if (nextEscape == -1) {
                nextEscape = line.length();
            }
            int n2 = n = nextEscape == -1 ? max : nextEscape;
            while (index < n) {
                sb.append(line.charAt(index));
                ++index;
            }
            if (nextEscape == -1) continue;
            while (index < max) {
                char c = line.charAt(index);
                if (c == 'm') {
                    ++index;
                    continue block0;
                }
                ++index;
            }
        }
        return sb.toString();
    }

    public static void adjustProxy(ProcessBuilder pb) {
        Map<String, String> env;
        String proxy = Util.getNetBeansHttpProxy();
        if (proxy != null && (env = pb.environment()).get("HTTP_PROXY") == null && env.get("http_proxy") == null) {
            env.put("HTTP_PROXY", proxy);
            env.put("http_proxy", proxy);
        }
    }

    private static String getNetBeansHttpProxy() {
        int port;
        String host = System.getProperty("http.proxyHost");
        if (host == null) {
            return null;
        }
        String portHttp = System.getProperty("http.proxyPort");
        try {
            port = Integer.parseInt(portHttp);
        }
        catch (NumberFormatException e) {
            port = 8080;
        }
        Preferences prefs = NbPreferences.root().node("org/netbeans/core");
        boolean useAuth = prefs.getBoolean(USE_PROXY_AUTHENTICATION, false);
        String auth = "";
        if (useAuth) {
            auth = prefs.get(PROXY_AUTHENTICATION_USERNAME, "") + ":" + prefs.get(PROXY_AUTHENTICATION_PASSWORD, "") + '@';
        }
        if (host.indexOf(58) == -1) {
            host = "http://" + auth + host;
        }
        return host + ":" + port;
    }

    public static Collection<String> dirsOnPath() {
        String rawPath = System.getenv("PATH");
        if (rawPath == null) {
            rawPath = System.getenv("Path");
        }
        if (rawPath == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> candidates = new LinkedHashSet<String>(Arrays.asList(rawPath.split(File.pathSeparator)));
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            String dir = (String)it.next();
            if (new File(dir).isDirectory()) continue;
            LOGGER.fine(dir + " found in the PATH environment variable. But is not a valid directory. Ignoring...");
            it.remove();
        }
        return candidates;
    }

    public static Collection<String> rvmRubies() {
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            return Collections.emptyList();
        }
        File rvmRubies = new File(homeDir, RVM_RUBIES_PATH);
        if (!rvmRubies.exists()) {
            return Collections.emptyList();
        }
        File[] dirs = rvmRubies.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        ArrayList<String> result = new ArrayList<String>(dirs.length);
        for (File dir : dirs) {
            File bin = new File(dir, "bin");
            if (!bin.exists() || !bin.isDirectory()) continue;
            result.add(bin.getAbsolutePath());
        }
        return result;
    }

    public static String findOnPath(String toFind) {
        for (String path : Util.dirsOnPath()) {
            String result = path + File.separator + toFind;
            if (!new File(result).isFile()) continue;
            return result;
        }
        return null;
    }

    public static void preselectPlatform(JComboBox platforms, String preferencePlatformIDKey) {
        RubyPlatform platform;
        String lastPlatformID = RubyPreferences.getPreferences().get(preferencePlatformIDKey, null);
        if (lastPlatformID != null && (platform = RubyPlatformManager.getPlatformByID(lastPlatformID)) != null) {
            platforms.setSelectedItem(platform);
        }
    }

    public static void notifyLocalized(Class aClass, String resName, int type, Object ... params) {
        String message = NbBundle.getMessage((Class)aClass, (String)resName, (Object[])params);
        if (type == 0) {
            LOGGER.severe(message);
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, type));
    }

    public static void notifyLocalized(Class aClass, String resName, Object ... params) {
        Util.notifyLocalized(aClass, resName, 1, params);
    }

    public static boolean confirmLocalized(Class aClass, String resName, Object ... params) {
        String message = NbBundle.getMessage((Class)aClass, (String)resName, (Object[])params);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)message, 2));
        return result.equals(NotifyDescriptor.OK_OPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsString(InputStream is) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)is, (OutputStream)baos);
            String string = baos.toString("UTF-8");
            return string;
        }
        finally {
            is.close();
        }
    }

    public static int compareVersions(String version1, String version2) {
        if (version1.equals(version2)) {
            return 0;
        }
        Matcher matcher1 = VERSION_PATTERN.matcher(version1);
        if (matcher1.matches()) {
            int major1 = Integer.parseInt(matcher1.group(1));
            int minor1 = Integer.parseInt(matcher1.group(2));
            int micro1 = matcher1.group(4) == null ? 0 : Integer.parseInt(matcher1.group(4));
            String suffix1 = matcher1.group(5);
            Matcher matcher2 = VERSION_PATTERN.matcher(version2);
            if (matcher2.matches()) {
                int major2 = Integer.parseInt(matcher2.group(1));
                int minor2 = Integer.parseInt(matcher2.group(2));
                int micro2 = matcher2.group(4) == null ? 0 : Integer.parseInt(matcher2.group(4));
                String suffix2 = matcher2.group(5);
                if (major1 != major2) {
                    return major1 - major2;
                }
                if (minor1 != minor2) {
                    return minor1 - minor2;
                }
                if (micro1 != micro2) {
                    return micro1 - micro2;
                }
                if (suffix1 == null) {
                    return 1;
                }
                if (suffix2 == null) {
                    return -1;
                }
                return suffix1.compareTo(suffix2);
            }
        }
        return version1.compareTo(version2);
    }
}

