/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.symbol;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.jumpto.file.LazyListModel;
import org.netbeans.modules.jumpto.symbol.GoToPanel;
import org.netbeans.modules.jumpto.symbol.SymbolProviderAccessor;
import org.netbeans.modules.jumpto.type.Models;
import org.netbeans.modules.jumpto.type.UiOptions;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.netbeans.spi.jumpto.symbol.SymbolProvider;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class GoToSymbolAction
extends AbstractAction
implements GoToPanel.ContentProvider,
LazyListModel.Filter {
    static final Logger LOGGER = Logger.getLogger(GoToSymbolAction.class.getName());
    private SearchType nameKind;
    private static ListModel EMPTY_LIST_MODEL = new DefaultListModel();
    private static final RequestProcessor rp = new RequestProcessor("GoToSymbolAction-RequestProcessor", 1);
    private Worker running;
    private RequestProcessor.Task task;
    private GoToPanel panel;
    private Dialog dialog;
    private JButton okButton;
    private Collection<? extends SymbolProvider> typeProviders;
    private final String title;
    private static Pattern camelCasePattern = Pattern.compile("(?:\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\p{Digit}|\\.|\\$)*){2,}");
    private Dimension initialDimension;

    public GoToSymbolAction() {
        this(NbBundle.getMessage(GoToSymbolAction.class, (String)"DLG_GoToSymbol"));
    }

    public GoToSymbolAction(String title) {
        super(NbBundle.getMessage(GoToSymbolAction.class, (String)"TXT_GoToSymbol"));
        this.title = title;
    }

    private Collection<? extends SymbolProvider> getTypeProviders() {
        if (this.typeProviders == null) {
            this.typeProviders = Arrays.asList(Lookup.getDefault().lookupAll(SymbolProvider.class).toArray(new SymbolProvider[0]));
        }
        return this.typeProviders;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SymbolDescriptor typeDescriptor = this.getSelectedSymbol();
        if (typeDescriptor != null) {
            typeDescriptor.open();
        }
    }

    public SymbolDescriptor getSelectedSymbol() {
        SymbolDescriptor result = null;
        try {
            JEditorPane[] openedPanes;
            EditorCookie ec;
            this.panel = new GoToPanel(this);
            this.dialog = this.createDialog(this.panel);
            Node[] arr = TopComponent.getRegistry().getActivatedNodes();
            String initSearchText = null;
            if (arr.length > 0 && (ec = (EditorCookie)arr[0].getCookie(EditorCookie.class)) != null && (openedPanes = ec.getOpenedPanes()) != null && (initSearchText = Utilities.getSelectionOrIdentifier((JTextComponent)openedPanes[0])) != null && org.openide.util.Utilities.isJavaIdentifier((String)initSearchText)) {
                this.panel.setInitialText(initSearchText);
            }
            this.dialog.setVisible(true);
            result = this.panel.getSelectedSymbol();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return OpenProjects.getDefault().getOpenProjects().length > 0;
    }

    @Override
    public boolean accept(Object obj) {
        return true;
    }

    @Override
    public void scheduleUpdate(Runnable run) {
        SwingUtilities.invokeLater(run);
    }

    @Override
    public ListCellRenderer getListCellRenderer(JList list) {
        return new Renderer(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListModel(GoToPanel panel, String text) {
        if (this.okButton != null) {
            this.okButton.setEnabled(false);
        }
        if (this.running != null) {
            this.running.cancel();
            this.task.cancel();
            this.running = null;
        }
        if (text == null) {
            panel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        boolean isCaseSensitive = panel.isCaseSensitive();
        boolean exact = text.endsWith(" ");
        if ((text = text.trim()).length() == 0) {
            panel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        int wildcard = GoToSymbolAction.containsWildCard(text);
        this.nameKind = exact ? SearchType.EXACT_NAME : (GoToSymbolAction.isAllUpper(text) && text.length() > 1 || GoToSymbolAction.isCamelCase(text) ? SearchType.CAMEL_CASE : (wildcard != -1 ? (isCaseSensitive ? SearchType.REGEXP : SearchType.CASE_INSENSITIVE_REGEXP) : (isCaseSensitive ? SearchType.PREFIX : SearchType.CASE_INSENSITIVE_PREFIX)));
        GoToSymbolAction goToSymbolAction = this;
        synchronized (goToSymbolAction) {
            this.running = new Worker(text);
            this.task = rp.post((Runnable)this.running, 220);
            if (panel.time != -1L) {
                LOGGER.fine("Worker posted after " + (System.currentTimeMillis() - panel.time) + " ms.");
            }
        }
    }

    private static boolean isAllUpper(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int containsWildCard(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '?' && text.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    private static boolean isCamelCase(String text) {
        return camelCasePattern.matcher(text).matches();
    }

    @Override
    public void closeDialog() {
        this.dialog.setVisible(false);
        this.cleanup();
    }

    @Override
    public boolean hasValidContent() {
        return this.okButton != null && this.okButton.isEnabled();
    }

    private Dialog createDialog(GoToPanel panel) {
        this.okButton = new JButton(NbBundle.getMessage(GoToSymbolAction.class, (String)"CTL_OK"));
        this.okButton.setEnabled(false);
        panel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GoToSymbolAction.class, (String)"AN_GoToSymbol"));
        panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToSymbolAction.class, (String)"AD_GoToSymbol"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, this.title, true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new DialogButtonListener(panel));
        dialogDescriptor.setClosingOptions(new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION});
        Dialog d = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        int width = UiOptions.GoToSymbolDialog.getWidth();
        int height = UiOptions.GoToSymbolDialog.getHeight();
        if (width != -1 && height != -1) {
            d.setPreferredSize(new Dimension(width, height));
        }
        Rectangle r = org.openide.util.Utilities.getUsableScreenBounds();
        int maxW = r.width * 9 / 10;
        int maxH = r.height * 9 / 10;
        Dimension dim = d.getPreferredSize();
        dim.width = Math.min(dim.width, maxW);
        dim.height = Math.min(dim.height, maxH);
        d.setBounds(org.openide.util.Utilities.findCenterBounds((Dimension)dim));
        this.initialDimension = dim;
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                GoToSymbolAction.this.cleanup();
            }
        });
        return d;
    }

    private void cleanup() {
        if (this.dialog != null) {
            int currentWidth = this.dialog.getWidth();
            int currentHeight = this.dialog.getHeight();
            if (this.initialDimension != null && (this.initialDimension.width != currentWidth || this.initialDimension.height != currentHeight)) {
                UiOptions.GoToSymbolDialog.setHeight(currentHeight);
                UiOptions.GoToSymbolDialog.setWidth(currentWidth);
            }
            this.initialDimension = null;
            this.dialog.dispose();
            this.dialog = null;
            for (SymbolProvider symbolProvider : this.getTypeProviders()) {
                symbolProvider.cleanup();
            }
        }
    }

    private int compareStrings(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.compareTo(s2);
    }

    private class SymbolComparator
    implements Comparator<SymbolDescriptor> {
        private SymbolComparator() {
        }

        @Override
        public int compare(SymbolDescriptor t1, SymbolDescriptor t2) {
            int cmpr = GoToSymbolAction.this.compareStrings(t1.getSymbolName(), t2.getSymbolName());
            if (cmpr != 0) {
                return cmpr;
            }
            return cmpr;
        }
    }

    private class DialogButtonListener
    implements ActionListener {
        private GoToPanel panel;

        public DialogButtonListener(GoToPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GoToSymbolAction.this.okButton) {
                this.panel.setSelectedSymbol();
            }
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer
    implements ChangeListener {
        private MyPanel rendererComponent;
        private JLabel jlName = new JLabel();
        private JLabel jlOwner = new JLabel();
        private JLabel jlPrj = new JLabel();
        private int DARKER_COLOR_COMPONENT = 5;
        private int LIGHTER_COLOR_COMPONENT = 80;
        private Color fgColor;
        private Color fgColorLighter;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;
        private JList jList;

        public Renderer(JList list) {
            this.jList = list;
            Container container = list.getParent();
            if (container instanceof JViewport) {
                ((JViewport)container).addChangeListener(this);
                this.stateChanged(new ChangeEvent(container));
            }
            this.rendererComponent = new MyPanel();
            this.rendererComponent.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = 0;
            c.weightx = 0.0;
            c.anchor = 17;
            c.insets = new Insets(0, 0, 0, 7);
            this.rendererComponent.add((Component)this.jlName, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = 2;
            c.weightx = 0.1;
            c.anchor = 17;
            c.insets = new Insets(0, 0, 0, 7);
            this.rendererComponent.add((Component)this.jlOwner, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = 0;
            c.weightx = 0.0;
            c.anchor = 13;
            this.rendererComponent.add((Component)this.jlPrj, c);
            this.jlName.setOpaque(false);
            this.jlPrj.setOpaque(false);
            this.jlName.setFont(list.getFont());
            this.jlPrj.setFont(list.getFont());
            this.jlPrj.setHorizontalAlignment(4);
            this.jlPrj.setHorizontalTextPosition(2);
            this.fgColor = list.getForeground();
            this.fgColorLighter = new Color(Math.min(255, this.fgColor.getRed() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getGreen() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getBlue() + this.LIGHTER_COLOR_COMPONENT));
            this.bgColor = list.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - this.DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = list.getSelectionBackground();
            this.fgSelectionColor = list.getSelectionForeground();
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            int height = list.getFixedCellHeight();
            int width = list.getFixedCellWidth() - 1;
            width = width < 200 ? 200 : width;
            Dimension size = new Dimension(width, height);
            this.rendererComponent.setMaximumSize(size);
            this.rendererComponent.setPreferredSize(size);
            if (isSelected) {
                this.jlName.setForeground(this.fgSelectionColor);
                this.jlOwner.setForeground(this.fgSelectionColor);
                this.jlPrj.setForeground(this.fgSelectionColor);
                this.rendererComponent.setBackground(this.bgSelectionColor);
            } else {
                this.jlName.setForeground(this.fgColor);
                this.jlOwner.setForeground(this.fgColorLighter);
                this.jlPrj.setForeground(this.fgColor);
                this.rendererComponent.setBackground(index % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (value instanceof SymbolDescriptor) {
                long time = System.currentTimeMillis();
                SymbolDescriptor td = (SymbolDescriptor)value;
                this.jlName.setIcon(td.getIcon());
                this.jlName.setText(td.getSymbolName());
                this.jlOwner.setText(NbBundle.getMessage(GoToSymbolAction.class, (String)"MSG_DeclaredIn", (Object)td.getOwnerName()));
                this.jlPrj.setText(td.getProjectName());
                this.jlPrj.setIcon(td.getProjectIcon());
                this.rendererComponent.setDescriptor(td);
                FileObject fo = td.getFileObject();
                if (fo != null) {
                    this.rendererComponent.setToolTipText(FileUtil.getFileDisplayName((FileObject)fo));
                }
                LOGGER.fine("  Time in paint " + (System.currentTimeMillis() - time) + " ms.");
            } else {
                this.jlName.setText(value.toString());
            }
            return this.rendererComponent;
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            JViewport jv = (JViewport)event.getSource();
            this.jlName.setText("Sample");
            this.jlName.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/jumpto/type/sample.png", (boolean)false));
            this.jList.setFixedCellHeight(this.jlName.getPreferredSize().height);
            this.jList.setFixedCellWidth(jv.getExtentSize().width);
        }
    }

    private static class MyPanel
    extends JPanel {
        private SymbolDescriptor td;

        private MyPanel() {
        }

        void setDescriptor(SymbolDescriptor td) {
            this.td = td;
            this.putClientProperty("ToolTipText", null);
        }

        @Override
        public String getToolTipText() {
            String text = (String)this.getClientProperty("ToolTipText");
            if (text == null) {
                FileObject fo;
                if (this.td != null && (fo = this.td.getFileObject()) != null) {
                    text = FileUtil.getFileDisplayName((FileObject)fo);
                }
                this.putClientProperty("ToolTipText", text);
            }
            return text;
        }
    }

    private class Worker
    implements Runnable {
        private volatile boolean isCanceled = false;
        private volatile SymbolProvider current;
        private final String text;
        private final long createTime;

        public Worker(String text) {
            this.text = text;
            this.createTime = System.currentTimeMillis();
            LOGGER.fine("Worker for " + text + " - created after " + (System.currentTimeMillis() - ((GoToSymbolAction)GoToSymbolAction.this).panel.time) + " ms.");
        }

        @Override
        public void run() {
            LOGGER.fine("Worker for " + this.text + " - started " + (System.currentTimeMillis() - this.createTime) + " ms.");
            final List<? extends SymbolDescriptor> types = this.getSymbolNames(this.text);
            if (this.isCanceled) {
                LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
                return;
            }
            final ListModel fmodel = Models.fromList(types);
            if (this.isCanceled) {
                LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
                return;
            }
            if (!this.isCanceled && fmodel != null) {
                LOGGER.fine("Worker for text " + this.text + " finished after " + (System.currentTimeMillis() - this.createTime) + " ms.");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GoToSymbolAction.this.panel.setModel(fmodel);
                        if (GoToSymbolAction.this.okButton != null && !types.isEmpty()) {
                            GoToSymbolAction.this.okButton.setEnabled(true);
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            SymbolProvider _provider;
            if (((GoToSymbolAction)GoToSymbolAction.this).panel.time != -1L) {
                LOGGER.fine("Worker for text " + this.text + " canceled after " + (System.currentTimeMillis() - this.createTime) + " ms.");
            }
            Worker worker = this;
            synchronized (worker) {
                this.isCanceled = true;
                _provider = this.current;
            }
            if (_provider != null) {
                _provider.cancel();
            }
        }

        private List<? extends SymbolDescriptor> getSymbolNames(String text) {
            ArrayList items = new ArrayList(128);
            String[] message = new String[1];
            SymbolProvider.Context context = SymbolProviderAccessor.DEFAULT.createContext(null, text, GoToSymbolAction.this.nameKind);
            SymbolProvider.Result result = SymbolProviderAccessor.DEFAULT.createResult(items, message);
            Iterator i$ = GoToSymbolAction.this.getTypeProviders().iterator();
            while (i$.hasNext()) {
                SymbolProvider provider;
                this.current = provider = (SymbolProvider)i$.next();
                if (this.isCanceled) {
                    return null;
                }
                LOGGER.fine("Calling SymbolProvider: " + provider);
                provider.computeSymbolNames(context, result);
                this.current = null;
            }
            if (!this.isCanceled) {
                Collections.sort(items, new SymbolComparator());
                GoToSymbolAction.this.panel.setWarning(message[0]);
                return items;
            }
            return null;
        }
    }
}

