/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.T1Exception;

public class T1Block {
    byte t1NAD;
    byte t1PCB;
    short t1LEN;
    byte[] t1INF = new byte[32];
    byte t1LRC;
    static final int MAX_INF_SIZE = 32;
    static final int BLOCK_OVERHEAD_SIZE = 4;
    public static final byte NULL_ADDRESS = 0;
    public static final byte S_RESYNC_REQ = -64;
    public static final byte S_RESYNC_RES = -32;
    public static final byte S_IFS_REQ = -63;
    public static final byte S_IFS_RES = -31;
    public static final byte S_ABORT_REQ = -62;
    public static final byte S_ABORT_RES = -30;
    public static final byte S_WTX_REQ = -61;
    public static final byte S_WTX_RES = -29;
    static final byte TYPE_IBLOCK = 0;
    static final byte TYPE_RBLOCK = -128;
    static final byte TYPE_SBLOCK = -64;
    static final byte SEQUENCE_MASK = 64;
    static final byte CHAINING_MASK = 32;
    static final byte BLOCK_MASK = -64;
    static final byte IBLOCK_MASK = -128;
    static final byte RECV_MASK = 16;
    static final byte PARITY_MASK = 1;
    static final byte ERROR_MASK = 2;
    static final byte CARD_ADDR = 2;
    static final byte HOST_ADDR = 1;
    static final int OFFSET_NAD = 0;
    static final int OFFSET_PCB = 1;
    static final int OFFSET_LEN = 2;
    static final int OFFSET_INF = 3;

    public void setIBlock(byte by, byte by2, boolean bl, boolean bl2, byte[] byArray, int n) throws T1Exception {
        this.setIBlock(by, by2, bl, bl2, byArray, 0, n);
    }

    public void setIBlock(byte by, byte by2, boolean bl, boolean bl2, byte[] byArray, int n, int n2) throws T1Exception {
        if (n2 > 32 || n2 < 0) {
            throw new T1Exception(-128);
        }
        this.t1NAD = (byte)(by2 << 4 | by);
        this.t1PCB = 0;
        if (bl) {
            this.t1PCB = (byte)(this.t1PCB | 0x40);
        }
        if (!bl2) {
            this.t1PCB = (byte)(this.t1PCB | 0x20);
        }
        this.t1LEN = (short)n2;
        try {
            if (n2 > 0) {
                System.arraycopy(byArray, n, this.t1INF, 0, n2);
            }
        }
        catch (Exception exception) {
            throw new T1Exception(-128);
        }
        this.t1LRC = this.computeLRC();
    }

    public void setRBlock(byte by, byte by2, boolean bl) throws T1Exception {
        this.t1NAD = (byte)(by2 << 4 | by);
        this.t1PCB = (byte)-128;
        if (bl) {
            this.t1PCB = (byte)(this.t1PCB | 0x10);
        }
        this.t1LEN = 0;
        this.t1LRC = this.computeLRC();
    }

    public void setSBlock(byte by, byte by2, int n, int n2) throws T1Exception {
        this.t1NAD = (byte)(by2 << 4 | by);
        this.t1PCB = (byte)-64;
        this.t1PCB = (byte)(this.t1PCB | n);
        switch (n) {
            case -63: 
            case -61: 
            case -31: 
            case -29: {
                this.t1LEN = 1;
                this.t1INF[0] = (byte)n2;
                break;
            }
            case -64: 
            case -62: 
            case -32: 
            case -30: {
                this.t1LEN = 0;
                break;
            }
            default: {
                throw new T1Exception(-125);
            }
        }
        this.t1LRC = this.computeLRC();
    }

    byte computeLRC() {
        byte by = 0;
        by = (byte)(by ^ this.t1NAD);
        by = (byte)(by ^ this.t1PCB);
        by = (byte)(by ^ (byte)this.t1LEN);
        for (int i = 0; i < this.t1LEN; ++i) {
            by = (byte)(by ^ this.t1INF[i]);
        }
        return by;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.t1LEN + 4];
        byArray[0] = this.t1NAD;
        byArray[1] = this.t1PCB;
        byArray[2] = (byte)this.t1LEN;
        System.arraycopy(this.t1INF, 0, byArray, 3, this.t1LEN);
        byArray[3 + this.t1LEN] = this.t1LRC;
        return byArray;
    }

    public static T1Block readBlock(byte[] byArray, int n, int n2) throws T1Exception {
        T1Block t1Block = null;
        t1Block.readBlockInstance(byArray, n, n2);
        if (!t1Block.checkBlock()) {
            throw new T1Exception(-126);
        }
        return t1Block;
    }

    public void readBlockInstance(byte[] byArray, int n, int n2) throws T1Exception {
        if ((byArray[n + 2] & 0xFF) != n2 - 4) {
            throw new T1Exception(-126);
        }
        this.t1NAD = byArray[n + 0];
        this.t1PCB = byArray[n + 1];
        this.t1LEN = byArray[n + 2];
        try {
            System.arraycopy(byArray, n + 3, this.t1INF, 0, this.t1LEN);
            this.t1LRC = byArray[n + 3 + this.t1LEN];
        }
        catch (Exception exception) {
            throw new T1Exception(-126);
        }
        if (!this.checkBlock()) {
            throw new T1Exception(-126);
        }
    }

    public boolean checkBlock() {
        return T1Block.checkBlock(this);
    }

    public static boolean checkBlock(T1Block t1Block) {
        byte by = 0;
        by = (byte)(by ^ t1Block.t1NAD);
        by = (byte)(by ^ t1Block.t1PCB);
        by = (byte)(by ^ (byte)(t1Block.t1LEN & 0xFF));
        for (int i = 0; i < t1Block.t1LEN; ++i) {
            by = (byte)(by ^ t1Block.t1INF[i]);
        }
        return (by = (byte)(by ^ t1Block.t1LRC)) == 0;
    }

    public byte getBlockType() {
        byte by = (byte)(this.t1PCB & 0xFFFFFFC0);
        if (by == 64) {
            by = (byte)(by & 0xFFFFFF80);
        }
        return by;
    }

    public byte[] getINFBytes() {
        return this.t1INF;
    }

    public int getIntINF() {
        return this.t1INF[0] & 0xFF;
    }

    public int getLEN() {
        return this.t1LEN & 0xFF;
    }

    public boolean isLastBlock() {
        byte by = this.getBlockType();
        if (by != 0) {
            return true;
        }
        byte by2 = (byte)(this.t1PCB & 0x20);
        return by2 == 0;
    }

    public boolean getSequence() {
        byte by = this.getBlockType();
        switch (by) {
            case 0: {
                byte by2 = (byte)(this.t1PCB & 0x40);
                return by2 != 0;
            }
            case -128: {
                byte by3 = (byte)(this.t1PCB & 0x10);
                return by3 != 0;
            }
        }
        return false;
    }

    public byte getSBlockType() {
        byte by = this.getBlockType();
        if (by != -64) {
            return -1;
        }
        return this.t1PCB;
    }

    private String getIBlockStr() {
        boolean bl = this.isLastBlock();
        boolean bl2 = this.getSequence();
        String string = "I(";
        string = bl ? string + "0, " : string + "1, ";
        string = bl2 ? string + "1)" : string + "0)";
        return string;
    }

    private String getRBlockStr() {
        boolean bl = this.getSequence();
        String string = "R(";
        string = bl ? string + "1)" : string + "0)";
        return string;
    }

    private String getSBlockStr() {
        String string = "S(";
        byte by = (byte)(this.t1PCB & 0xE3);
        switch (by) {
            case -63: {
                string = string + "IFS_REQ";
                break;
            }
            case -31: {
                string = string + "IFS_RES";
                break;
            }
            case -61: {
                string = string + "WTX_REQ";
                break;
            }
            case -29: {
                string = string + "WTX_RES";
                break;
            }
            case -62: {
                string = string + "ABORT_REQ";
                break;
            }
            case -30: {
                string = string + "ABORT_RES";
                break;
            }
            case -64: {
                string = string + "RESYNC_REQ";
                break;
            }
            case -32: {
                string = string + "RESYNC_RES";
            }
        }
        string = string + ")";
        return string;
    }

    public String toString() {
        String string = "";
        switch (this.getBlockType()) {
            case 0: {
                string = this.getIBlockStr();
                break;
            }
            case -128: {
                string = this.getRBlockStr();
                break;
            }
            case -64: {
                string = this.getSBlockStr();
            }
        }
        string = string + ": " + "NAD:" + Integer.toHexString(this.t1NAD & 0xFF) + " LEN:" + Integer.toHexString(this.t1LEN & 0xFF);
        return string;
    }
}

