/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.kenai.api.KenaiActivity;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.collab.chat.ChatPanel;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CreateChatAction
extends AbstractAction {
    private KenaiProject project;

    public CreateChatAction(KenaiProject project) {
        this.project = project;
        String name = project.getDisplayName();
        this.putValue("Name", name);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final JButton source = e.getSource() instanceof JButton ? (JButton)e.getSource() : null;
        final TopComponent mainWindow = WindowManager.getDefault().findTopComponent("KenaiTopComponent");
        mainWindow.setCursor(Cursor.getPredefinedCursor(3));
        final ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CreateChatAction.class, (String)"LBL_CheckPermissions"));
        progress.setInitialDelay(0);
        progress.start();
        if (source != null) {
            source.setEnabled(true);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!CreateChatAction.this.project.getKenai().isAuthorized(CreateChatAction.this.project, KenaiActivity.PROJECTS_ADMIN)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                progress.finish();
                                JOptionPane.showMessageDialog(null, NbBundle.getMessage(CreateChatAction.class, (String)"CTL_NotAuthorizedToCreateChat", (Object)CreateChatAction.this.getValue("Name")));
                                mainWindow.setCursor(Cursor.getDefaultCursor());
                                if (source != null) {
                                    source.setEnabled(true);
                                }
                            }
                        });
                        return;
                    }
                }
                catch (KenaiException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int value = JOptionPane.showOptionDialog(null, NbBundle.getMessage(CreateChatAction.class, (String)"LBL_CreateChatQuestions"), NbBundle.getMessage(CreateChatAction.class, (String)"LBL_CreateChatTitle"), 0, 3, null, null, null);
                        if (value == 0) {
                            progress.setDisplayName(NbBundle.getMessage(CreateChatAction.class, (String)"CTL_CreatingChatProgress"));
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    block2: {
                                        try {
                                            final KenaiFeature f = CreateChatAction.this.project.createProjectFeature(CreateChatAction.this.project.getName(), NbBundle.getMessage(CreateChatAction.class, (String)"CTL_ChatRoomName", (Object)CreateChatAction.this.project.getName()), NbBundle.getMessage(CreateChatAction.class, (String)"CTL_ChatRoomDescription", (Object)CreateChatAction.this.project.getName()), "instant_messenger", null, null, null);
                                            SwingUtilities.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    ChatTopComponent chatTc = ChatTopComponent.findInstance();
                                                    chatTc.open();
                                                    chatTc.addChat(new ChatPanel(KenaiConnection.getDefault(CreateChatAction.this.project.getKenai()).getChat(f)));
                                                    mainWindow.setCursor(Cursor.getDefaultCursor());
                                                    progress.finish();
                                                    if (source != null) {
                                                        source.setEnabled(true);
                                                    }
                                                    chatTc.requestActive();
                                                }
                                            });
                                        }
                                        catch (KenaiException kenaiException) {
                                            Exceptions.printStackTrace((Throwable)kenaiException);
                                            mainWindow.setCursor(Cursor.getDefaultCursor());
                                            progress.finish();
                                            if (source == null) break block2;
                                            source.setEnabled(true);
                                        }
                                    }
                                }
                            });
                        } else {
                            mainWindow.setCursor(Cursor.getDefaultCursor());
                            progress.finish();
                            if (source != null) {
                                source.setEnabled(true);
                            }
                        }
                    }
                });
            }
        });
    }
}

