/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;

public abstract class BaseProjectPathSupport
extends BasePathSupport {
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper referenceHelper;
    private final AntProjectHelper antProjectHelper;

    public BaseProjectPathSupport(PropertyEvaluator evaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper) {
        assert (evaluator != null);
        assert (referenceHelper != null);
        assert (antProjectHelper != null);
        this.evaluator = evaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
    }

    protected abstract boolean isWellKnownPath(String var1);

    public Iterator<BasePathSupport.Item> itemsIterator(String propertyValue) {
        return this.itemsList(propertyValue).iterator();
    }

    public List<BasePathSupport.Item> itemsList(String propertyValue) {
        String[] pe = PropertyUtils.tokenizePath((String)(propertyValue == null ? "" : propertyValue));
        ArrayList<BasePathSupport.Item> items = new ArrayList<BasePathSupport.Item>(pe.length);
        for (String p : pe) {
            BasePathSupport.Item item = null;
            if (this.isWellKnownPath(p)) {
                item = BasePathSupport.Item.create(p);
            } else {
                File f = null;
                String eval = this.evaluator.evaluate(p);
                if (eval != null) {
                    f = this.antProjectHelper.resolveFile(eval);
                }
                item = f == null || !f.exists() ? BasePathSupport.Item.createBroken(eval, p) : BasePathSupport.Item.create(eval, p);
            }
            items.add(item);
        }
        return items;
    }

    public String[] encodeToStrings(Iterator<BasePathSupport.Item> classpath) {
        ArrayList<String> result = new ArrayList<String>();
        while (classpath.hasNext()) {
            BasePathSupport.Item item = classpath.next();
            String reference = item.getReference();
            switch (item.getType()) {
                case FOLDER: {
                    if (reference != null) break;
                    File file = new File(item.getFilePath());
                    item.property = reference = this.referenceHelper.createForeignFileReference(file, null);
                }
            }
            if (reference == null) continue;
            result.add(reference);
        }
        String[] items = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            items[i] = i < result.size() - 1 ? (String)result.get(i) + ":" : (String)result.get(i);
        }
        return items;
    }
}

