/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.extras.api.ViewportAware;
import org.netbeans.modules.dlight.extras.api.ViewportModel;
import org.netbeans.modules.dlight.extras.api.support.DefaultViewportModel;
import org.netbeans.modules.dlight.extras.api.support.ViewportBar;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.dlight.util.TimeFormatter;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;
import org.openide.util.NbBundle;

public final class IndicatorsContainer
extends JPanel
implements AdjustmentListener,
ChangeListener {
    private static final long EXTENT = 20000000000L;
    private static final TimeFormatter TIME_FORMATTER = new TimeFormatter();
    private final JScrollPane indicatorsScrollPane;
    private final ViewportBar viewportBar;
    private final JScrollBar hScrollBar;
    private final JScrollBar vScrollBar;
    private final DefaultViewportModel viewportModel = new DefaultViewportModel((Range<Long>)new Range((Number)0L, (Number)0L), (Range<Long>)new Range((Number)0L, (Number)20000000000L));
    private final JLabel timeLabel;
    private boolean isAdjusting;

    public IndicatorsContainer(DataFilterManager filterManager, List<Indicator<?>> indicators) {
        this.viewportModel.setMinViewportSize(1000000000L);
        this.viewportModel.addChangeListener(this);
        this.indicatorsScrollPane = IndicatorsContainer.packIndicatorsIntoScrollPane(indicators, this.viewportModel);
        this.vScrollBar = this.indicatorsScrollPane.getVerticalScrollBar();
        this.vScrollBar.setVisible(false);
        this.indicatorsScrollPane.setHorizontalScrollBarPolicy(31);
        this.indicatorsScrollPane.setVerticalScrollBarPolicy(21);
        this.indicatorsScrollPane.getViewport().addChangeListener(this);
        this.timeLabel = new JLabel(TIME_FORMATTER.format(0L), 0);
        this.timeLabel.setOpaque(false);
        this.timeLabel.setFont(DLightUIPrefs.getFont((String)"indicator.title.font"));
        this.timeLabel.setForeground(DLightUIPrefs.getColor((String)"indicator.title.font.color"));
        int scrollBarButtonSize = UIManager.getInt("ScrollBar.width");
        int padding = DLightUIPrefs.getInt((String)"indicator.padding");
        int leftMargin = padding + DLightUIPrefs.getInt((String)"indicator.y_axis.width") - scrollBarButtonSize;
        int rightMargin = padding + DLightUIPrefs.getInt((String)"indicator.legend.width") - scrollBarButtonSize;
        this.viewportBar = new ViewportBar(this.viewportModel, filterManager, scrollBarButtonSize, scrollBarButtonSize);
        this.hScrollBar = new JScrollBar(0);
        this.hScrollBar.setToolTipText(IndicatorsContainer.getMessage("IndicatorsContainer.hScrollBar.tooltip"));
        this.adjust();
        this.hScrollBar.addAdjustmentListener(this);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.indicatorsScrollPane, 200, 200, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap(leftMargin, leftMargin).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.hScrollBar, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.viewportBar, GroupLayout.Alignment.LEADING, 200 - leftMargin - rightMargin, 200 - leftMargin - rightMargin, Short.MAX_VALUE)).addComponent(this.timeLabel, -2, rightMargin, -2))).addComponent(this.vScrollBar));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.indicatorsScrollPane, 100, 100, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addGroup(layout.createSequentialGroup().addComponent(this.viewportBar, -2, -1, -2).addComponent(this.hScrollBar, -2, -1, -2)).addComponent(this.timeLabel, -1, -1, Short.MAX_VALUE))).addComponent(this.vScrollBar));
    }

    private static JScrollPane packIndicatorsIntoScrollPane(List<Indicator<?>> indicators, ViewportModel viewportModel) {
        JScrollPane indicatorsComponent = null;
        if (indicators != null && !indicators.isEmpty()) {
            int i;
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            JSplitPane prevSplit = null;
            int freeSizeComponentsNumber = 0;
            for (i = 0; i < indicators.size(); ++i) {
                JComponent component = indicators.get(i).getComponent();
                if (component.isMaximumSizeSet()) continue;
                ++freeSizeComponentsNumber;
            }
            for (i = 0; i < indicators.size(); ++i) {
                Indicator<?> indicator = indicators.get(i);
                JComponent component = indicators.get(i).getComponent();
                if (indicator instanceof ViewportAware) {
                    ((ViewportAware)indicator).setViewportModel(viewportModel);
                }
                if (i + 1 < indicators.size()) {
                    JSplitPane splitPane = new JSplitPane(0);
                    splitPane.setBorder(BorderFactory.createEmptyBorder());
                    splitPane.setContinuousLayout(true);
                    splitPane.setDividerSize(5);
                    if (!component.isMaximumSizeSet()) {
                        splitPane.setResizeWeight(1.0 / (double)(freeSizeComponentsNumber - i));
                    }
                    splitPane.setTopComponent(component);
                    component = splitPane;
                }
                if (prevSplit == null) {
                    scrollPane.setViewportView(component);
                } else {
                    prevSplit.setBottomComponent(component);
                }
                if (!(component instanceof JSplitPane)) continue;
                prevSplit = (JSplitPane)component;
            }
            indicatorsComponent = scrollPane;
        } else {
            JLabel emptyLabel = new JLabel(IndicatorsContainer.getMessage("IndicatorsContainer.EmptyContent"));
            emptyLabel.setAlignmentX(0.5f);
            indicatorsComponent = new JScrollPane(emptyLabel);
        }
        indicatorsComponent.setBorder(new ThreeSidesBorder());
        return indicatorsComponent;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(DLightUIPrefs.getColor((String)"indicator.border.color"));
        g.fillRect(0, this.viewportBar.getY(), this.indicatorsScrollPane.getWidth(), 2);
    }

    private void adjust() {
        Range limits = this.viewportModel.getLimits();
        this.timeLabel.setText(TIME_FORMATTER.format(Math.max(0L, (Long)limits.getEnd() - 1000000000L)));
        Range<Long> viewport = this.viewportModel.getViewport();
        limits = limits.extend(viewport);
        this.isAdjusting = true;
        this.hScrollBar.setMinimum((int)TimeUnit.MILLISECONDS.toSeconds((Long)limits.getStart()));
        this.hScrollBar.setMaximum((int)TimeUnit.MILLISECONDS.toSeconds((Long)limits.getEnd()));
        this.hScrollBar.setValue((int)TimeUnit.MILLISECONDS.toSeconds((Long)viewport.getStart()));
        this.hScrollBar.setVisibleAmount((int)TimeUnit.MILLISECONDS.toSeconds((Long)viewport.getEnd() - (Long)viewport.getStart()));
        this.isAdjusting = false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.viewportModel) {
            UIThread.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    IndicatorsContainer.this.adjust();
                }
            });
        } else if (e.getSource() == this.indicatorsScrollPane.getViewport()) {
            UIThread.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    Dimension viewSize = IndicatorsContainer.this.indicatorsScrollPane.getViewport().getViewSize();
                    Dimension portSize = IndicatorsContainer.this.indicatorsScrollPane.getViewport().getExtentSize();
                    IndicatorsContainer.this.vScrollBar.setVisible(portSize.height < viewSize.height);
                }
            });
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.isAdjusting) {
            Range<Long> viewport = this.viewportModel.getViewport();
            long newViewportStart = TimeUnit.SECONDS.toMillis(e.getValue());
            this.viewportModel.setViewport((Range<Long>)new Range((Number)newViewportStart, (Number)(newViewportStart + (Long)viewport.getEnd() - (Long)viewport.getStart())));
        }
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(IndicatorsContainer.class, (String)key);
    }

    private static class ThreeSidesBorder
    implements Border {
        private ThreeSidesBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(DLightUIPrefs.getColor((String)"indicator.border.color"));
            g.fillRect(0, 0, width, 2);
            g.fillRect(0, 0, 2, height);
            g.fillRect(width - 2, 0, 2, height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 0, 2);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

