/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlRenderer;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

final class SourceLevelComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private static final SpecificationVersion JDK_1_5 = new SpecificationVersion("1.5");
    private static final Logger LOGGER = Logger.getLogger(PlatformUiSupport.class.getName());
    private static final long serialVersionUID = 1L;
    private static final String VERSION_PREFIX = "1.";
    private static final int INITIAL_VERSION_MINOR = 2;
    private final SpecificationVersion minimalSpecificationVersion;
    private SpecificationVersion selectedSourceLevel;
    private SpecificationVersion originalSourceLevel;
    private SourceLevelKey[] sourceLevelCache;
    private JavacardPlatform activePlatform;
    private final JCProjectProperties props;
    private boolean inPlatformChanged = false;

    public SourceLevelComboBoxModel(JCProjectProperties props, String initialSourceLevel, String initialTargetLevel, SpecificationVersion minimalSpecificationVersion) {
        this.activePlatform = props.getPlatform();
        this.props = props;
        if (initialSourceLevel != null && initialSourceLevel.length() > 0) {
            try {
                this.originalSourceLevel = new SpecificationVersion(initialSourceLevel);
            }
            catch (NumberFormatException nfe) {
                LOGGER.warning("Invalid javac.source: " + initialSourceLevel);
            }
        }
        if (initialTargetLevel != null && initialTargetLevel.length() > 0) {
            try {
                SpecificationVersion originalTargetLevel = new SpecificationVersion(initialTargetLevel);
                if (this.originalSourceLevel == null || this.originalSourceLevel.compareTo((Object)originalTargetLevel) < 0) {
                    this.originalSourceLevel = originalTargetLevel;
                }
            }
            catch (NumberFormatException nfe) {
                LOGGER.warning("Invalid javac.target: " + initialTargetLevel);
            }
        }
        this.selectedSourceLevel = this.originalSourceLevel;
        this.minimalSpecificationVersion = minimalSpecificationVersion;
    }

    @Override
    public int getSize() {
        SourceLevelKey[] sLevels = this.getSourceLevels();
        return sLevels.length;
    }

    @Override
    public Object getElementAt(int index) {
        SourceLevelKey[] sLevels = this.getSourceLevels();
        assert (index >= 0 && index < sLevels.length);
        return sLevels[index];
    }

    @Override
    public Object getSelectedItem() {
        for (SourceLevelKey key : this.getSourceLevels()) {
            SpecificationVersion ver = key.getSourceLevel();
            if (!ver.toString().equals(this.selectedSourceLevel == null ? "" : this.selectedSourceLevel.toString())) continue;
            return key;
        }
        return null;
    }

    @Override
    public void setSelectedItem(Object obj) {
        this.selectedSourceLevel = obj == null ? null : ((SourceLevelKey)obj).getSourceLevel();
        this.fireContentsChanged(this, -1, -1);
        SourceLevelKey key = (SourceLevelKey)obj;
        if (key != null) {
            this.props.setJavacSourceLevel(key.getSourceLevel().toString());
            this.props.setJavacTargetLevel(key.getSourceLevel().toString());
        }
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void platformChanged() {
        if (this.inPlatformChanged) {
            return;
        }
        this.inPlatformChanged = true;
        try {
            JavacardPlatform platform = this.activePlatform;
            if (platform != null) {
                SpecificationVersion version = platform.getSpecification().getVersion();
                if (this.selectedSourceLevel != null && this.selectedSourceLevel.compareTo((Object)version) > 0 && !this.shouldChangePlatform(this.selectedSourceLevel, version)) {
                    this.props.setPlatformName(platform.getSystemName());
                    return;
                }
                this.originalSourceLevel = null;
            }
            this.activePlatform = this.props.getPlatform();
            this.resetCache();
        }
        finally {
            this.inPlatformChanged = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        SourceLevelComboBoxModel sourceLevelComboBoxModel = this;
        synchronized (sourceLevelComboBoxModel) {
            this.sourceLevelCache = null;
        }
        this.fireContentsChanged(this, -1, -1);
    }

    private SourceLevelKey[] getSourceLevels() {
        if (this.sourceLevelCache == null) {
            int min;
            JavacardPlatform platform = this.props.getPlatform();
            ArrayList<SourceLevelKey> sLevels = new ArrayList<SourceLevelKey>();
            boolean selSourceLevelValid = false;
            SpecificationVersion version = platform == null ? new SpecificationVersion("9.9") : platform.getSpecification().getVersion();
            Pattern p = Pattern.compile("\\d*.\\.(\\d).*?");
            int maxVersion = 6;
            Matcher m = p.matcher(version.toString());
            if (m.find() && m.groupCount() > 0) {
                maxVersion = Integer.parseInt(m.group(1));
            }
            for (int i = min = this.getMinimalIndex(version); i < maxVersion + 1; ++i) {
                SpecificationVersion ver = new SpecificationVersion(VERSION_PREFIX + i);
                sLevels.add(new SourceLevelKey(ver));
                selSourceLevelValid |= ver.equals((Object)this.selectedSourceLevel);
            }
            this.sourceLevelCache = sLevels.toArray(new SourceLevelKey[sLevels.size()]);
            if (!selSourceLevelValid) {
                this.selectedSourceLevel = this.sourceLevelCache.length == 0 ? null : this.sourceLevelCache[this.sourceLevelCache.length - 1].getSourceLevel();
            }
        }
        return this.sourceLevelCache;
    }

    private int getMinimalIndex(SpecificationVersion platformVersion) {
        int index = 2;
        if (this.minimalSpecificationVersion != null) {
            SpecificationVersion min = new SpecificationVersion(VERSION_PREFIX + Integer.toString(index));
            while (min.compareTo((Object)platformVersion) <= 0) {
                if (min.equals((Object)this.minimalSpecificationVersion)) {
                    return index;
                }
                min = new SpecificationVersion(VERSION_PREFIX + Integer.toString(++index));
            }
        }
        return index;
    }

    private boolean shouldChangePlatform(SpecificationVersion selectedSourceLevel, SpecificationVersion platformSourceLevel) {
        JButton changeOption = new JButton(NbBundle.getMessage(PlatformUiSupport.class, (String)"CTL_ChangePlatform"));
        changeOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformUiSupport.class, (String)"AD_ChangePlatform"));
        String message = MessageFormat.format(NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_ChangePlatform"), selectedSourceLevel.toString(), platformSourceLevel.toString());
        return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)message, NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_ChangePlatformTitle"), -1, 2, new Object[]{changeOption, NotifyDescriptor.CANCEL_OPTION}, (Object)changeOption)) == changeOption;
    }

    private static final class SourceLevelKey
    implements Comparable<SourceLevelKey> {
        private final SpecificationVersion sourceLevel;
        private final boolean broken;

        public SourceLevelKey(SpecificationVersion sourceLevel) {
            this(sourceLevel, false);
        }

        public SourceLevelKey(SpecificationVersion sourceLevel, boolean broken) {
            assert (sourceLevel != null) : "Source level cannot be null";
            this.sourceLevel = sourceLevel;
            this.broken = broken;
        }

        public SpecificationVersion getSourceLevel() {
            return this.sourceLevel;
        }

        public boolean isBroken() {
            return this.broken;
        }

        @Override
        public int compareTo(SourceLevelKey other) {
            SourceLevelKey otherKey = other;
            return this.sourceLevel.compareTo((Object)otherKey.sourceLevel);
        }

        public boolean equals(Object other) {
            return other instanceof SourceLevelKey && ((SourceLevelKey)other).sourceLevel.equals((Object)this.sourceLevel);
        }

        public int hashCode() {
            return this.sourceLevel.hashCode();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            if (this.broken) {
                buffer.append("Broken: ");
            }
            buffer.append(this.sourceLevel.toString());
            return buffer.toString();
        }

        public String getDisplayName() {
            String tmp = this.sourceLevel.toString();
            if (JDK_1_5.compareTo((Object)this.sourceLevel) <= 0) {
                tmp = tmp.replaceFirst("^1\\.([5-9]|\\d\\d+)$", "$1");
            }
            return NbBundle.getMessage(PlatformUiSupport.class, (String)"LBL_JDK", (Object)tmp);
        }
    }

    static final class SourceLevelListCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate = HtmlRenderer.createRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String message;
            if (value == null) {
                message = "";
            } else {
                assert (value instanceof SourceLevelKey);
                SourceLevelKey key = (SourceLevelKey)value;
                message = key.isBroken() ? "<html><font color=\"#A40000\">" + NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_InvalidSourceLevel", (Object)key.getDisplayName()) : key.getDisplayName();
            }
            return this.delegate.getListCellRendererComponent(list, message, index, isSelected, cellHasFocus);
        }
    }
}

