/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.ArrayNode;
import org.jruby.nb.ast.BlockAcceptingNode;
import org.jruby.nb.ast.IArgumentNode;
import org.jruby.nb.ast.IterNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.InterpretedBlock;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class FCallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private Node argsNode;
    private Node iterNode;
    public CallSite callAdapter;

    @Deprecated
    public FCallNode(ISourcePosition position, String name, Node argsNode) {
        this(position, name, argsNode, null);
    }

    protected FCallNode(ISourcePosition position, String name, Node argsNode, Node iterNode) {
        super(position, NodeType.FCALLNODE);
        this.setArgsNode(argsNode);
        this.iterNode = iterNode;
        this.callAdapter = MethodIndex.getFunctionalCallSite(name);
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitFCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        this.callAdapter = MethodIndex.getFunctionalCallSite(this.callAdapter.methodName);
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        return argsNode;
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    @Override
    public List<Node> childNodes() {
        return FCallNode.createList(this.argsNode, this.iterNode);
    }

    @Override
    public String toString() {
        return "FCallNode: " + this.getName();
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        assert (false) : "Should not happen anymore";
        return null;
    }

    public Block getBlock(ThreadContext context, IRubyObject self) {
        IterNode iter = (IterNode)this.iterNode;
        iter.getScope().determineModule();
        return InterpretedBlock.newInterpretedClosure(context, iter.getBlockBody(), self);
    }

    public Block getBlock(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return RuntimeHelpers.getBlockFromBlockPassBody(runtime, this.iterNode.interpret(runtime, context, self, aBlock), aBlock);
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (self.getMetaClass().isMethodBound(this.getName(), false)) {
            return ASTInterpreter.getArgumentDefinition(runtime, context, this.getArgsNode(), "method", self, aBlock);
        }
        return null;
    }
}

