/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.EntityClosure;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PersistenceClientEntitySelectionVisual
extends JPanel {
    private WizardDescriptor wizard;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Project project;
    boolean waitingForScan;
    boolean waitingForEntities;
    private boolean createPU = true;
    private EntityClosure entityClosure;
    private JButton buttonAdd;
    private JButton buttonAddAll;
    private JButton buttonRemove;
    private JButton buttonRemoveAll;
    private JCheckBox cbAddRelated;
    private JCheckBox createPUCheckbox;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labelAvailableEntities;
    private JLabel labelSelectedEntities;
    private JList listAvailable;
    private JList listSelected;
    private JPanel panelButtons;
    private final ListCellRenderer ENTITY_LIST_RENDERER = new EntityListCellRenderer();

    public PersistenceClientEntitySelectionVisual(String string, WizardDescriptor wizardDescriptor) {
        this.setName(string);
        this.wizard = wizardDescriptor;
        this.initComponents();
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PersistenceClientEntitySelectionVisual.this.updateButtons();
            }
        };
        this.listAvailable.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.listSelected.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public boolean getCreatePersistenceUnit() {
        return this.createPU && this.createPUCheckbox.isVisible();
    }

    private Set<String> getSelectedEntities(JList jList) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : jList.getSelectedValues()) {
            hashSet.add((String)object);
        }
        return hashSet;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.listAvailable = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.listSelected = new JList();
        this.cbAddRelated = new JCheckBox();
        this.labelAvailableEntities = new JLabel();
        this.panelButtons = new JPanel();
        this.buttonRemove = new JButton();
        this.buttonAdd = new JButton();
        this.buttonAddAll = new JButton();
        this.buttonRemoveAll = new JButton();
        this.labelSelectedEntities = new JLabel();
        this.createPUCheckbox = new JCheckBox();
        this.listAvailable.setCellRenderer(this.ENTITY_LIST_RENDERER);
        this.jScrollPane1.setViewportView(this.listAvailable);
        this.listAvailable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_AvailableEntitiesList"));
        this.listAvailable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_AvailableEntitiesList"));
        this.listSelected.setCellRenderer(this.ENTITY_LIST_RENDERER);
        this.jScrollPane2.setViewportView(this.listSelected);
        this.listSelected.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_SelectedEntitiesList"));
        this.listSelected.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_SelectedEntitiesList"));
        this.cbAddRelated.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_InludeRelated").charAt(0));
        this.cbAddRelated.setSelected(true);
        this.cbAddRelated.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_IncludeReferenced"));
        this.cbAddRelated.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAddRelated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceClientEntitySelectionVisual.this.cbAddRelatedActionPerformed(actionEvent);
            }
        });
        this.labelAvailableEntities.setDisplayedMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_AvailableEntityClasses").charAt(0));
        this.labelAvailableEntities.setLabelFor(this.listAvailable);
        this.labelAvailableEntities.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_AvailableEntities"));
        this.buttonRemove.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_Remove").charAt(0));
        this.buttonRemove.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_Remove"));
        this.buttonRemove.setActionCommand("< &Remove");
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceClientEntitySelectionVisual.this.buttonRemoveActionPerformed(actionEvent);
            }
        });
        this.buttonAdd.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_Add").charAt(0));
        this.buttonAdd.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_Add"));
        this.buttonAdd.setActionCommand("&Add >");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceClientEntitySelectionVisual.this.buttonAddActionPerformed(actionEvent);
            }
        });
        this.buttonAddAll.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_AddAll").charAt(0));
        this.buttonAddAll.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_AddAll"));
        this.buttonAddAll.setActionCommand("Add A&ll >>");
        this.buttonAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceClientEntitySelectionVisual.this.buttonAddAllActionPerformed(actionEvent);
            }
        });
        this.buttonRemoveAll.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_RemoveAll").charAt(0));
        this.buttonRemoveAll.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_RemoveAll"));
        this.buttonRemoveAll.setActionCommand("<< Re&moveAll");
        this.buttonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceClientEntitySelectionVisual.this.buttonRemoveAllActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.panelButtons);
        this.panelButtons.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.buttonAdd, -1, 124, Short.MAX_VALUE).add(2, (Component)this.buttonRemove, -1, 124, Short.MAX_VALUE).add(2, (Component)this.buttonRemoveAll, -1, 124, Short.MAX_VALUE).add(2, (Component)this.buttonAddAll, -1, 124, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(67, 67, 67).add((Component)this.buttonAdd).addPreferredGap(0).add((Component)this.buttonRemove).add(20, 20, 20).add((Component)this.buttonAddAll).addPreferredGap(0).add((Component)this.buttonRemoveAll).addContainerGap(103, Short.MAX_VALUE)));
        this.buttonRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_Remove"));
        this.buttonAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_Add"));
        this.buttonAddAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_AddAll"));
        this.buttonRemoveAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_RemoveAll"));
        this.labelSelectedEntities.setDisplayedMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_SelectedEntityClasses").charAt(0));
        this.labelSelectedEntities.setLabelFor(this.listSelected);
        this.labelSelectedEntities.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_SelectedEntities"));
        this.createPUCheckbox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createPUCheckbox, (String)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_CreatePersistenceUnit"));
        this.createPUCheckbox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.createPUCheckbox.setEnabled(false);
        this.createPUCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PersistenceClientEntitySelectionVisual.this.createPUCheckboxItemStateChanged(itemEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.labelAvailableEntities).add((Component)this.jScrollPane1, -1, 306, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.panelButtons, -2, -1, -2).add(0, 0, 0)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.createPUCheckbox).addPreferredGap(0))).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.cbAddRelated).add((Component)this.labelSelectedEntities).add((Component)this.jScrollPane2, -1, 196, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.labelSelectedEntities).add((Component)this.labelAvailableEntities)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 318, Short.MAX_VALUE).add((Component)this.panelButtons, -1, -1, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 318, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.cbAddRelated).add((Component)this.createPUCheckbox)).add(31, 31, 31)));
        this.cbAddRelated.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_IncludeReferencedCheckbox"));
        this.cbAddRelated.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_IncludeReferencedCheckbox"));
    }

    private void cbAddRelatedActionPerformed(ActionEvent actionEvent) {
        this.listSelected.clearSelection();
        this.listAvailable.clearSelection();
        this.entityClosure.setClosureEnabled(this.cbAddRelated.isSelected());
        this.changeSupport.fireChange();
    }

    private void buttonRemoveAllActionPerformed(ActionEvent actionEvent) {
        this.entityClosure.removeAllEntities();
        this.listSelected.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void buttonAddAllActionPerformed(ActionEvent actionEvent) {
        this.entityClosure.addAllEntities();
        this.listAvailable.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void buttonRemoveActionPerformed(ActionEvent actionEvent) {
        this.entityClosure.removeEntities(this.getSelectedEntities(this.listSelected));
        this.listSelected.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void buttonAddActionPerformed(ActionEvent actionEvent) {
        this.entityClosure.addEntities(this.getSelectedEntities(this.listAvailable));
        this.listAvailable.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void createPUCheckboxItemStateChanged(ItemEvent itemEvent) {
        this.createPU = this.createPUCheckbox.isVisible() && this.createPUCheckbox.isSelected();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        ClassPath classPath;
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)this.project);
        if (sourceGroupArray.length > 0 && (classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile")).findResource("javax/persistence/Entity.class") == null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ERR_NoPersistenceProvider"));
            return false;
        }
        if (!this.entityClosure.isModelReady()) {
            classPath = RequestProcessor.getDefault().create(new Runnable(){

                @Override
                public void run() {
                    PersistenceClientEntitySelectionVisual.this.entityClosure.waitModelIsReady();
                    PersistenceClientEntitySelectionVisual.this.changeSupport.fireChange();
                    PersistenceClientEntitySelectionVisual.this.updateButtons();
                }
            });
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"scanning-in-progress"));
            classPath.schedule(0);
            return false;
        }
        if (this.listSelected.getModel().getSize() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MSG_NoEntityClassesSelected"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        return true;
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        EntityClassScope entityClassScope = EntityClassScope.getEntityClassScope((FileObject)this.project.getProjectDirectory());
        this.entityClosure = EntityClosure.create(entityClassScope, this.project);
        this.entityClosure.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PersistenceClientEntitySelectionVisual.this.updateAddAllButton();
            }
        });
        this.entityClosure.setClosureEnabled(this.cbAddRelated.isSelected());
        this.listAvailable.setModel(new EntityListModel(this.entityClosure, true));
        this.listSelected.setModel(new EntityListModel(this.entityClosure, false));
        ArrayList arrayList = (ArrayList)wizardDescriptor.getProperty("EntityClass");
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.entityClosure.addEntities(new HashSet<String>(arrayList));
        this.updateButtons();
        this.updatePersistenceUnitButton();
    }

    void store(WizardDescriptor wizardDescriptor) {
        ListModel listModel = this.listSelected.getModel();
        if (listModel instanceof EntityListModel) {
            EntityListModel entityListModel = (EntityListModel)listModel;
            wizardDescriptor.putProperty("EntityClass", entityListModel.getEntityClasses());
        }
    }

    private void updateButtons() {
        this.buttonAdd.setEnabled(this.listAvailable.getSelectedValues().length > 0);
        this.updateAddAllButton();
        this.buttonRemove.setEnabled(this.listSelected.getSelectedValues().length > 0);
        this.buttonRemoveAll.setEnabled(this.entityClosure.getSelectedEntities().size() > 0);
    }

    private void updateAddAllButton() {
        this.buttonAddAll.setEnabled(this.entityClosure.getAvailableEntities().size() > 0);
    }

    public void updatePersistenceUnitButton() {
        boolean bl = true;
        if (ProviderUtil.isValidServerInstanceOrNone(this.project) && bl) {
            PersistenceScope[] persistenceScopeArray = PersistenceUtils.getPersistenceScopes(this.project);
            for (int i = 0; i < persistenceScopeArray.length; ++i) {
                FileObject fileObject = persistenceScopeArray[i].getPersistenceXml();
                if (fileObject == null) continue;
                try {
                    Persistence persistence = PersistenceMetadata.getDefault().getRoot(fileObject);
                    if (persistence.getPersistenceUnit().length <= 0) continue;
                    bl = false;
                    break;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        this.createPUCheckbox.setVisible(bl);
    }

    private final class EntityListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public EntityListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = null;
            if (object instanceof Entity) {
                string = ((Entity)object).getClass2();
                if (string != null) {
                    String string2 = JavaIdentifiers.unqualify((String)string);
                    String string3 = string.length() > string2.length() ? string.substring(0, string.length() - string2.length() - 1) : "<default package>";
                    string = string2 + " (" + string3 + ")";
                } else {
                    Logger.getLogger("global").log(Level.INFO, "Entity:" + object + " returns null from getClass2(); see IZ 80024");
                }
            }
            if (string == null) {
                string = object.toString();
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(PersistenceClientEntitySelectionVisual.this.entityClosure.getAvailableEntities().contains(object) || PersistenceClientEntitySelectionVisual.this.entityClosure.getWantedEntities().contains(object));
            this.setFont(jList.getFont());
            this.setText(string);
            return this;
        }
    }

    private class EntityListModel
    extends AbstractListModel
    implements ChangeListener {
        private EntityClosure entityClosure;
        private List<String> entities = new ArrayList<String>();
        private boolean available;

        EntityListModel(EntityClosure entityClosure, boolean bl) {
            this.entityClosure = entityClosure;
            this.available = bl;
            entityClosure.addChangeListener(this);
            this.refresh();
        }

        @Override
        public int getSize() {
            return this.entities.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.entities.get(n);
        }

        public List<String> getEntityClasses() {
            return this.entities;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.refresh();
        }

        private void refresh() {
            int n = this.getSize();
            this.entities = new ArrayList<String>(this.available ? this.entityClosure.getAvailableEntities() : this.entityClosure.getSelectedEntities());
            Collections.sort(this.entities);
            this.fireContentsChanged(this, 0, Math.max(n, this.getSize()));
        }
    }
}

