/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.util.SQLTypeUtil;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.SQLType;

class DbSchemaEntityMember
extends EntityMember {
    private boolean isPrimaryKey;
    private boolean isAutoIncrement;
    private SQLType sqlType;
    private Integer length;
    private Integer precision;
    private Integer scale;
    private ColumnElement columnElement;

    public DbSchemaEntityMember(ColumnElement columnElement) {
        this.columnElement = columnElement;
        this.sqlType = SQLType.getSQLType(columnElement.getType());
        this.setMemberName(DbSchemaEntityMember.makeFieldName(columnElement.getName().getName()));
        this.isPrimaryKey = false;
        this.isAutoIncrement = columnElement.isAutoIncrement();
        this.setMemberType(this.sqlType.getMemberType(columnElement));
        if (columnElement.isCharacterType()) {
            this.length = columnElement.getLength();
        }
        if (columnElement.isNumericType()) {
            this.precision = columnElement.getPrecision();
            this.scale = columnElement.getScale();
        }
    }

    @Override
    public boolean isNullable() {
        return this.columnElement.isNullable();
    }

    @Override
    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    @Override
    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    @Override
    public void setPrimaryKey(boolean bl, boolean bl2) {
        this.isPrimaryKey = bl;
        if (bl2) {
            this.setMemberType(this.getRespectiveNonPrimitiveType());
        }
    }

    private String getRespectiveNonPrimitiveType() {
        String string = this.getMemberType();
        if ("int".equals(string)) {
            return Integer.class.getName();
        }
        if ("long".equals(string)) {
            return Long.class.getName();
        }
        if ("short".equals(string)) {
            return Short.class.getName();
        }
        if ("byte".equals(string)) {
            return Byte.class.getName();
        }
        if ("double".equals(string)) {
            return Double.class.getName();
        }
        if ("float".equals(string)) {
            return Float.class.getName();
        }
        if ("char".equals(string)) {
            return Character.class.getName();
        }
        return this.sqlType.getFirstNonPrimitiveType();
    }

    private ColumnElement getColumnElement() {
        return this.columnElement;
    }

    @Override
    public boolean supportsFinder() {
        return this.sqlType.supportsFinder();
    }

    @Override
    public String getColumnName() {
        return this.getColumnElement().getName().getName();
    }

    @Override
    public String getTableName() {
        return this.getColumnElement().getDeclaringTable().getName().getName();
    }

    @Override
    public boolean isLobType() {
        return SQLTypeUtil.isLob((int)this.getColumnElement().getType());
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }
}

