/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxrpc.support;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.remoting.jaxrpc.JaxRpcServicePostProcessor;
import org.springframework.util.ClassUtils;

public class AxisBeanMappingServicePostProcessor
implements JaxRpcServicePostProcessor,
BeanClassLoaderAware {
    private String encodingStyleUri;
    private String typeNamespaceUri;
    private Map beanMappings;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public void setEncodingStyleUri(String encodingStyleUri) {
        this.encodingStyleUri = encodingStyleUri;
    }

    public void setTypeNamespaceUri(String typeNamespaceUri) {
        this.typeNamespaceUri = typeNamespaceUri;
    }

    public void setBeanMappings(Properties beanMappingProps) {
        if (beanMappingProps != null) {
            this.beanMappings = new HashMap(beanMappingProps.size());
            Enumeration<?> propertyNames = beanMappingProps.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String javaTypeName = (String)propertyNames.nextElement();
                String wsdlTypeName = beanMappingProps.getProperty(javaTypeName);
                this.beanMappings.put(javaTypeName, wsdlTypeName);
            }
        } else {
            this.beanMappings = null;
        }
    }

    public void setBeanClasses(Class[] beanClasses) {
        if (beanClasses != null) {
            this.beanMappings = new HashMap(beanClasses.length);
            for (int i = 0; i < beanClasses.length; ++i) {
                Class beanClass = beanClasses[i];
                String wsdlTypeName = ClassUtils.getShortName(beanClass);
                this.beanMappings.put(beanClass, wsdlTypeName);
            }
        } else {
            this.beanMappings = null;
        }
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void postProcessJaxRpcService(Service service) {
        TypeMappingRegistry registry = service.getTypeMappingRegistry();
        TypeMapping mapping = registry.createTypeMapping();
        this.registerBeanMappings(mapping);
        if (this.encodingStyleUri != null) {
            registry.register(this.encodingStyleUri, mapping);
        } else {
            registry.registerDefault(mapping);
        }
    }

    protected void registerBeanMappings(TypeMapping mapping) {
        if (this.beanMappings != null) {
            Iterator it = this.beanMappings.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                Class javaType = null;
                javaType = key instanceof Class ? (Class)key : ClassUtils.resolveClassName((String)key, this.beanClassLoader);
                String wsdlTypeName = (String)entry.getValue();
                this.registerBeanMapping(mapping, javaType, wsdlTypeName);
            }
        }
    }

    protected void registerBeanMapping(TypeMapping mapping, Class javaType, String wsdlTypeName) {
        this.registerBeanMapping(mapping, javaType, this.getTypeQName(wsdlTypeName));
    }

    protected void registerBeanMapping(TypeMapping mapping, Class javaType, QName wsdlType) {
        mapping.register(javaType, wsdlType, (SerializerFactory)new BeanSerializerFactory(javaType, wsdlType), (DeserializerFactory)new BeanDeserializerFactory(javaType, wsdlType));
    }

    protected final QName getTypeQName(String name) {
        return this.typeNamespaceUri != null ? new QName(this.typeNamespaceUri, name) : new QName(name);
    }
}

