(** sourceView2 enums *)

open Gpointer

type source_search_flag = [ `VISIBLE_ONLY | `TEXT_ONLY | `CASE_INSENSITIVE ]
type source_smart_home_end_type = [ `DISABLED | `BEFORE | `AFTER | `ALWAYS ]
type source_draw_spaces_flags =
  [ `SPACE | `TAB | `NEWLINE | `NBSP | `LEADING | `TEXT | `TRAILING ]
type source_completion_activation_flags = [ `INTERACTIVE | `USER_REQUESTED ]

(**/**)

external _get_tables : unit ->
    source_search_flag variant_table
  * source_smart_home_end_type variant_table
  * source_draw_spaces_flags variant_table
  * source_completion_activation_flags variant_table
  = "ml_source_view2_get_tables"


let source_search_flag, source_smart_home_end_type, source_draw_spaces_flags,
    source_completion_activation_flags = _get_tables ()

let source_search_flag_conv = Gobject.Data.enum source_search_flag
let source_smart_home_end_type_conv = Gobject.Data.enum source_smart_home_end_type
let source_draw_spaces_flags_conv = Gobject.Data.enum source_draw_spaces_flags
let source_completion_activation_flags_conv = Gobject.Data.enum source_completion_activation_flags
