'use strict';

exports.__esModule = true;

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _warnOnce = require('./warn-once');

var _warnOnce2 = _interopRequireDefault(_warnOnce);

var _warning = require('./warning');

var _warning2 = _interopRequireDefault(_warning);

var Result = (function () {
    function Result(processor, root, opts) {
        _classCallCheck(this, Result);

        this.processor = processor;
        this.messages = [];
        this.root = root;
        this.opts = opts;
        this.css = undefined;
        this.map = undefined;
    }

    Result.prototype.toString = function toString() {
        return this.css;
    };

    Result.prototype.warn = function warn(text) {
        var opts = arguments[1] === undefined ? {} : arguments[1];

        if (!opts.plugin) {
            if (this.lastPlugin && this.lastPlugin.postcssPlugin) {
                opts.plugin = this.lastPlugin.postcssPlugin;
            }
        }

        this.messages.push(new _warning2['default'](text, opts));
    };

    Result.prototype.warnings = function warnings() {
        return this.messages.filter(function (i) {
            return i.type === 'warning';
        });
    };

    _createClass(Result, [{
        key: 'from',
        get: function get() {
            _warnOnce2['default']('result.from is deprecated and will be removed in 5.0. ' + 'Use result.opts.from instead.');
            return this.opts.from;
        }
    }, {
        key: 'to',
        get: function get() {
            _warnOnce2['default']('result.to is deprecated and will be removed in 5.0. ' + 'Use result.opts.to instead.');
            return this.opts.to;
        }
    }]);

    return Result;
})();

exports['default'] = Result;
module.exports = exports['default'];