'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var cloneNode = function cloneNode(obj, parent) {
    if (typeof obj !== 'object') {
        return obj;
    }

    var cloned = new obj.constructor();

    for (var i in obj) {
        if (!obj.hasOwnProperty(i)) {
            continue;
        }
        var value = obj[i];
        var type = typeof value;

        if (i === 'parent' && type === 'object') {
            if (parent) {
                cloned[i] = parent;
            }
        } else if (value instanceof Array) {
            cloned[i] = value.map(function (j) {
                return cloneNode(j, cloned);
            });
        } else {
            cloned[i] = cloneNode(value, cloned);
        }
    }

    return cloned;
};

var _default = (function () {
    function _default() {
        var opts = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

        _classCallCheck(this, _default);

        for (var key in opts) {
            this[key] = opts[key];
        }
        this.spaces = { before: '', after: '' };
    }

    _createClass(_default, [{
        key: 'removeSelf',
        value: function removeSelf() {
            if (this.parent) {
                this.parent.remove(this);
            }
            this.parent = undefined;
            return this;
        }
    }, {
        key: 'replaceWith',
        value: function replaceWith() {
            if (this.parent) {
                for (var index in arguments) {
                    this.parent.insertBefore(this, arguments[index]);
                }
                this.removeSelf();
            }
            return this;
        }
    }, {
        key: 'next',
        value: function next() {
            return this.parent.at(this.parent.index(this) + 1);
        }
    }, {
        key: 'prev',
        value: function prev() {
            return this.parent.at(this.parent.index(this) - 1);
        }
    }, {
        key: 'clone',
        value: function clone() {
            var overrides = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

            var cloned = cloneNode(this);
            for (var _name in overrides) {
                cloned[_name] = overrides[_name];
            }
            return cloned;
        }
    }, {
        key: 'toString',
        value: function toString() {
            return [this.spaces.before, String(this.value), this.spaces.after].join('');
        }
    }]);

    return _default;
})();

exports['default'] = _default;
module.exports = exports['default'];