"use strict";

var _interopRequire = function (obj) { return obj && obj.__esModule ? obj["default"] : obj; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var CssSyntaxError = _interopRequire(require("./css-syntax-error"));

var PreviousMap = _interopRequire(require("./previous-map"));

var Parser = _interopRequire(require("./parser"));

var path = _interopRequire(require("path"));

var sequence = 0;

var Input = (function () {
    function Input(css) {
        var opts = arguments[1] === undefined ? {} : arguments[1];

        _classCallCheck(this, Input);

        this.css = css.toString();

        if (this.css[0] == "﻿" || this.css[0] == "￾") {
            this.css = this.css.slice(1);
        }

        this.safe = !!opts.safe;

        if (opts.from) this.file = path.resolve(opts.from);

        var map = new PreviousMap(this.css, opts, this.id);
        if (map.text) {
            this.map = map;
            var file = map.consumer().file;
            if (!this.file && file) this.file = this.mapResolve(file);
        }

        if (this.file) {
            this.from = this.file;
        } else {
            sequence += 1;
            this.id = "<input css " + sequence + ">";
            this.from = this.id;
        }
        if (this.map) this.map.file = this.from;
    }

    // Throw syntax error from this input

    Input.prototype.error = (function (_error) {
        var _errorWrapper = function error() {
            return _error.apply(this, arguments);
        };

        _errorWrapper.toString = function () {
            return _error.toString();
        };

        return _errorWrapper;
    })(function (message, line, column) {
        var error = new CssSyntaxError(message);

        var origin = this.origin(line, column);
        if (origin) {
            error = new CssSyntaxError(message, origin.line, origin.column, origin.source, origin.file);

            error.generated = {
                line: line,
                column: column,
                source: this.css
            };
            if (this.file) error.generated.file = this.file;
        } else {
            error = new CssSyntaxError(message, line, column, this.css, this.file);
        }

        return error;
    });

    // Get origin position of code if source map was given

    Input.prototype.origin = function origin(line, column) {
        if (!this.map) {
            return false;
        }var consumer = this.map.consumer();

        var from = consumer.originalPositionFor({ line: line, column: column });
        if (!from.source) {
            return false;
        }var result = {
            file: this.mapResolve(from.source),
            line: from.line,
            column: from.column
        };

        var source = consumer.sourceContentFor(result.file);
        if (source) result.source = source;

        return result;
    };

    // Return path relative from source map root

    Input.prototype.mapResolve = function mapResolve(file) {
        return path.resolve(this.map.consumer().sourceRoot || ".", file);
    };

    return Input;
})();

module.exports = Input;