"use strict";

var _interopRequire = function (obj) { return obj && obj.__esModule ? obj["default"] : obj; };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var Container = _interopRequire(require("./container"));

// CSS at-rule like “this.keyframes name { }”.
//
// Can contain declarations (like this.font-face or this.page) ot another rules.

var AtRule = (function (Container) {
    function AtRule(defaults) {
        _classCallCheck(this, AtRule);

        this.type = "atrule";
        Container.call(this, defaults);
    }

    _inherits(AtRule, Container);

    // Stringify at-rule

    AtRule.prototype.stringify = function stringify(builder, semicolon) {
        var name = "@" + this.name;
        var params = this.params ? this.stringifyRaw("params") : "";

        if (typeof this.afterName != "undefined") {
            name += this.afterName;
        } else if (params) {
            name += " ";
        }

        if (this.nodes) {
            this.stringifyBlock(builder, name + params);
        } else {
            var before = this.style("before");
            if (before) builder(before);
            var end = (this.between || "") + (semicolon ? ";" : "");
            builder(name + params + end, this);
        }
    };

    // Hack to mark, that at-rule contains children

    AtRule.prototype.append = function append(child) {
        if (!this.nodes) this.nodes = [];
        return Container.prototype.append.call(this, child);
    };

    // Hack to mark, that at-rule contains children

    AtRule.prototype.prepend = function prepend(child) {
        if (!this.nodes) this.nodes = [];
        return Container.prototype.prepend.call(this, child);
    };

    // Hack to mark, that at-rule contains children

    AtRule.prototype.insertBefore = function insertBefore(exist, add) {
        if (!this.nodes) this.nodes = [];
        return Container.prototype.insertBefore.call(this, exist, add);
    };

    // Hack to mark, that at-rule contains children

    AtRule.prototype.insertAfter = function insertAfter(exist, add) {
        if (!this.nodes) this.nodes = [];
        return Container.prototype.insertAfter.call(this, exist, add);
    };

    return AtRule;
})(Container);

module.exports = AtRule;