/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.ssl.CipherBox;
import sun.security.ssl.Debug;
import sun.security.ssl.JsseJce;
import sun.security.ssl.MAC;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SunJSSE;

final class CipherSuite
implements Comparable {
    static final int SUPPORTED_SUITES_PRIORITY = 1;
    static final int DEFAULT_SUITES_PRIORITY = 300;
    static final boolean DYNAMIC_AVAILABILITY = true;
    private static final boolean ALLOW_ECC = Debug.getBooleanProperty("com.sun.net.ssl.enableECC", true);
    private static final boolean PRESERVE_RC4 = Debug.getBooleanProperty("jdk.tls.preserveRC4CipherSuites", false);
    private static final Map<Integer, CipherSuite> idMap;
    private static final Map<String, CipherSuite> nameMap;
    final String name;
    final int id;
    final int priority;
    final KeyExchange keyExchange;
    final BulkCipher cipher;
    final MacAlg macAlg;
    final PRF prfAlg;
    final boolean exportable;
    final boolean allowed;
    final int obsoleted;
    final int supported;
    static final BulkCipher B_NULL;
    static final BulkCipher B_RC4_40;
    static final BulkCipher B_RC2_40;
    static final BulkCipher B_DES_40;
    static final BulkCipher B_RC4_128;
    static final BulkCipher B_DES;
    static final BulkCipher B_3DES;
    static final BulkCipher B_IDEA;
    static final BulkCipher B_AES_128;
    static final BulkCipher B_AES_256;
    static final MacAlg M_NULL;
    static final MacAlg M_MD5;
    static final MacAlg M_SHA;
    static final MacAlg M_SHA256;
    static final MacAlg M_SHA384;
    static final CipherSuite C_NULL;
    static final CipherSuite C_SCSV;

    private CipherSuite(String string, int n, int n2, KeyExchange keyExchange, BulkCipher bulkCipher, boolean bl, int n3, int n4, PRF pRF) {
        this.name = string;
        this.id = n;
        this.priority = n2;
        this.keyExchange = keyExchange;
        this.cipher = bulkCipher;
        this.exportable = bulkCipher.exportable;
        if (string.endsWith("_MD5")) {
            this.macAlg = M_MD5;
        } else if (string.endsWith("_SHA")) {
            this.macAlg = M_SHA;
        } else if (string.endsWith("_SHA256")) {
            this.macAlg = M_SHA256;
        } else if (string.endsWith("_SHA384")) {
            this.macAlg = M_SHA384;
        } else if (string.endsWith("_NULL")) {
            this.macAlg = M_NULL;
        } else if (string.endsWith("_SCSV")) {
            this.macAlg = M_NULL;
        } else {
            throw new IllegalArgumentException("Unknown MAC algorithm for ciphersuite " + string);
        }
        bl &= keyExchange.allowed;
        this.allowed = bl &= bulkCipher.allowed;
        this.obsoleted = n3;
        this.supported = n4;
        this.prfAlg = pRF;
    }

    private CipherSuite(String string, int n) {
        this.name = string;
        this.id = n;
        this.allowed = false;
        this.priority = 0;
        this.keyExchange = null;
        this.cipher = null;
        this.macAlg = null;
        this.exportable = false;
        this.obsoleted = 65535;
        this.supported = 0;
        this.prfAlg = PRF.P_NONE;
    }

    boolean isAvailable() {
        return this.allowed && this.keyExchange.isAvailable() && this.cipher.isAvailable();
    }

    boolean isNegotiable() {
        return this != C_SCSV && this.isAvailable();
    }

    public int compareTo(Object object) {
        return ((CipherSuite)object).priority - this.priority;
    }

    public String toString() {
        return this.name;
    }

    static CipherSuite valueOf(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        CipherSuite cipherSuite = nameMap.get(string);
        if (cipherSuite == null || !cipherSuite.allowed) {
            throw new IllegalArgumentException("Unsupported ciphersuite " + string);
        }
        return cipherSuite;
    }

    static CipherSuite valueOf(int n, int n2) {
        int n3 = (n &= 0xFF) << 8 | (n2 &= 0xFF);
        CipherSuite cipherSuite = idMap.get(n3);
        if (cipherSuite == null) {
            String string = Integer.toString(n, 16);
            String string2 = Integer.toString(n2, 16);
            cipherSuite = new CipherSuite("Unknown 0x" + string + ":0x" + string2, n3);
        }
        return cipherSuite;
    }

    static Collection<CipherSuite> allowedCipherSuites() {
        return nameMap.values();
    }

    private static void add(String string, int n, int n2, KeyExchange keyExchange, BulkCipher bulkCipher, boolean bl, int n3, int n4, PRF pRF) {
        CipherSuite cipherSuite = new CipherSuite(string, n, n2, keyExchange, bulkCipher, bl, n3, n4, pRF);
        if (idMap.put(n, cipherSuite) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + n + ", " + string);
        }
        if (cipherSuite.allowed && nameMap.put(string, cipherSuite) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + n + ", " + string);
        }
    }

    private static void add(String string, int n, int n2, KeyExchange keyExchange, BulkCipher bulkCipher, boolean bl, int n3) {
        PRF pRF = PRF.P_SHA256;
        if (n3 < ProtocolVersion.TLS12.v) {
            pRF = PRF.P_NONE;
        }
        CipherSuite.add(string, n, n2, keyExchange, bulkCipher, bl, n3, 0, pRF);
    }

    private static void add(String string, int n, int n2, KeyExchange keyExchange, BulkCipher bulkCipher, boolean bl) {
        CipherSuite.add(string, n, n2, keyExchange, bulkCipher, bl, 65535);
    }

    private static void add(String string, int n) {
        CipherSuite cipherSuite = new CipherSuite(string, n);
        if (idMap.put(n, cipherSuite) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + n + ", " + string);
        }
    }

    static /* synthetic */ boolean access$000() {
        return ALLOW_ECC;
    }

    static {
        B_NULL = new BulkCipher("NULL", 0, 0, 0, true);
        B_RC4_40 = new BulkCipher("RC4", 5, 16, 0, true);
        B_RC2_40 = new BulkCipher("RC2", 5, 16, 8, false);
        B_DES_40 = new BulkCipher("DES/CBC/NoPadding", 5, 8, 8, true);
        B_RC4_128 = new BulkCipher("RC4", 16, 0, true);
        B_DES = new BulkCipher("DES/CBC/NoPadding", 8, 8, true);
        B_3DES = new BulkCipher("DESede/CBC/NoPadding", 24, 8, true);
        B_IDEA = new BulkCipher("IDEA", 16, 8, false);
        B_AES_128 = new BulkCipher("AES/CBC/NoPadding", 16, 16, true);
        B_AES_256 = new BulkCipher("AES/CBC/NoPadding", 32, 16, true);
        M_NULL = new MacAlg("NULL", 0, 0, 0);
        M_MD5 = new MacAlg("MD5", 16, 64, 9);
        M_SHA = new MacAlg("SHA", 20, 64, 9);
        M_SHA256 = new MacAlg("SHA256", 32, 64, 9);
        M_SHA384 = new MacAlg("SHA384", 48, 128, 17);
        idMap = new HashMap<Integer, CipherSuite>();
        nameMap = new HashMap<String, CipherSuite>();
        boolean bl = !SunJSSE.isFIPS();
        CipherSuite.add("SSL_NULL_WITH_NULL_NULL", 0, 1, KeyExchange.K_NULL, B_NULL, false);
        int n = 600;
        int n2 = 65535;
        int n3 = ProtocolVersion.TLS11.v;
        int n4 = ProtocolVersion.TLS12.v;
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 49188, --n, KeyExchange.K_ECDHE_ECDSA, B_AES_256, true, n2, n4, PRF.P_SHA384);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 49192, --n, KeyExchange.K_ECDHE_RSA, B_AES_256, true, n2, n4, PRF.P_SHA384);
        CipherSuite.add("TLS_RSA_WITH_AES_256_CBC_SHA256", 61, --n, KeyExchange.K_RSA, B_AES_256, true, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", 49190, --n, KeyExchange.K_ECDH_ECDSA, B_AES_256, true, n2, n4, PRF.P_SHA384);
        CipherSuite.add("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", 49194, --n, KeyExchange.K_ECDH_RSA, B_AES_256, true, n2, n4, PRF.P_SHA384);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", 107, --n, KeyExchange.K_DHE_RSA, B_AES_256, true, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", 106, --n, KeyExchange.K_DHE_DSS, B_AES_256, true, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", 49162, --n, KeyExchange.K_ECDHE_ECDSA, B_AES_256, true);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", 49172, --n, KeyExchange.K_ECDHE_RSA, B_AES_256, true);
        CipherSuite.add("TLS_RSA_WITH_AES_256_CBC_SHA", 53, --n, KeyExchange.K_RSA, B_AES_256, true);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", 49157, --n, KeyExchange.K_ECDH_ECDSA, B_AES_256, true);
        CipherSuite.add("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", 49167, --n, KeyExchange.K_ECDH_RSA, B_AES_256, true);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", 57, --n, KeyExchange.K_DHE_RSA, B_AES_256, true);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", 56, --n, KeyExchange.K_DHE_DSS, B_AES_256, true);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 49187, --n, KeyExchange.K_ECDHE_ECDSA, B_AES_128, true, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 49191, --n, KeyExchange.K_ECDHE_RSA, B_AES_128, true, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_RSA_WITH_AES_128_CBC_SHA256", 60, --n, KeyExchange.K_RSA, B_AES_128, true, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", 49189, --n, KeyExchange.K_ECDH_ECDSA, B_AES_128, true, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", 49193, --n, KeyExchange.K_ECDH_RSA, B_AES_128, true, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", 103, --n, KeyExchange.K_DHE_RSA, B_AES_128, true, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", 64, --n, KeyExchange.K_DHE_DSS, B_AES_128, true, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 49161, --n, KeyExchange.K_ECDHE_ECDSA, B_AES_128, true);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", 49171, --n, KeyExchange.K_ECDHE_RSA, B_AES_128, true);
        CipherSuite.add("TLS_RSA_WITH_AES_128_CBC_SHA", 47, --n, KeyExchange.K_RSA, B_AES_128, true);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", 49156, --n, KeyExchange.K_ECDH_ECDSA, B_AES_128, true);
        CipherSuite.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", 49166, --n, KeyExchange.K_ECDH_RSA, B_AES_128, true);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", 51, --n, KeyExchange.K_DHE_RSA, B_AES_128, true);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", 50, --n, KeyExchange.K_DHE_DSS, B_AES_128, true);
        if (PRESERVE_RC4) {
            CipherSuite.add("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", 49159, --n, KeyExchange.K_ECDHE_ECDSA, B_RC4_128, bl);
            CipherSuite.add("TLS_ECDHE_RSA_WITH_RC4_128_SHA", 49169, --n, KeyExchange.K_ECDHE_RSA, B_RC4_128, bl);
            CipherSuite.add("SSL_RSA_WITH_RC4_128_SHA", 5, --n, KeyExchange.K_RSA, B_RC4_128, bl);
            CipherSuite.add("TLS_ECDH_ECDSA_WITH_RC4_128_SHA", 49154, --n, KeyExchange.K_ECDH_ECDSA, B_RC4_128, bl);
            CipherSuite.add("TLS_ECDH_RSA_WITH_RC4_128_SHA", 49164, --n, KeyExchange.K_ECDH_RSA, B_RC4_128, bl);
        }
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", 49160, --n, KeyExchange.K_ECDHE_ECDSA, B_3DES, true);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", 49170, --n, KeyExchange.K_ECDHE_RSA, B_3DES, true);
        CipherSuite.add("SSL_RSA_WITH_3DES_EDE_CBC_SHA", 10, --n, KeyExchange.K_RSA, B_3DES, true);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", 49155, --n, KeyExchange.K_ECDH_ECDSA, B_3DES, true);
        CipherSuite.add("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", 49165, --n, KeyExchange.K_ECDH_RSA, B_3DES, true);
        CipherSuite.add("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 22, --n, KeyExchange.K_DHE_RSA, B_3DES, true);
        CipherSuite.add("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19, --n, KeyExchange.K_DHE_DSS, B_3DES, bl);
        if (!PRESERVE_RC4) {
            CipherSuite.add("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", 49159, --n, KeyExchange.K_ECDHE_ECDSA, B_RC4_128, bl);
            CipherSuite.add("TLS_ECDHE_RSA_WITH_RC4_128_SHA", 49169, --n, KeyExchange.K_ECDHE_RSA, B_RC4_128, bl);
            CipherSuite.add("SSL_RSA_WITH_RC4_128_SHA", 5, --n, KeyExchange.K_RSA, B_RC4_128, bl);
            CipherSuite.add("TLS_ECDH_ECDSA_WITH_RC4_128_SHA", 49154, --n, KeyExchange.K_ECDH_ECDSA, B_RC4_128, bl);
            CipherSuite.add("TLS_ECDH_RSA_WITH_RC4_128_SHA", 49164, --n, KeyExchange.K_ECDH_RSA, B_RC4_128, bl);
        }
        CipherSuite.add("SSL_RSA_WITH_RC4_128_MD5", 4, --n, KeyExchange.K_RSA, B_RC4_128, bl);
        CipherSuite.add("TLS_EMPTY_RENEGOTIATION_INFO_SCSV", 255, --n, KeyExchange.K_SCSV, B_NULL, true);
        n = 300;
        CipherSuite.add("TLS_DH_anon_WITH_AES_256_CBC_SHA256", 109, --n, KeyExchange.K_DH_ANON, B_AES_256, bl, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDH_anon_WITH_AES_256_CBC_SHA", 49177, --n, KeyExchange.K_ECDH_ANON, B_AES_256, true);
        CipherSuite.add("TLS_DH_anon_WITH_AES_256_CBC_SHA", 58, --n, KeyExchange.K_DH_ANON, B_AES_256, bl);
        CipherSuite.add("TLS_DH_anon_WITH_AES_128_CBC_SHA256", 108, --n, KeyExchange.K_DH_ANON, B_AES_128, bl, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDH_anon_WITH_AES_128_CBC_SHA", 49176, --n, KeyExchange.K_ECDH_ANON, B_AES_128, true);
        CipherSuite.add("TLS_DH_anon_WITH_AES_128_CBC_SHA", 52, --n, KeyExchange.K_DH_ANON, B_AES_128, bl);
        if (!PRESERVE_RC4) {
            CipherSuite.add("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", 49175, --n, KeyExchange.K_ECDH_ANON, B_3DES, true);
            CipherSuite.add("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", 27, --n, KeyExchange.K_DH_ANON, B_3DES, bl);
        }
        CipherSuite.add("TLS_ECDH_anon_WITH_RC4_128_SHA", 49174, --n, KeyExchange.K_ECDH_ANON, B_RC4_128, bl);
        CipherSuite.add("SSL_DH_anon_WITH_RC4_128_MD5", 24, --n, KeyExchange.K_DH_ANON, B_RC4_128, bl);
        if (!PRESERVE_RC4) {
            CipherSuite.add("SSL_RSA_WITH_DES_CBC_SHA", 9, --n, KeyExchange.K_RSA, B_DES, bl, n4);
            CipherSuite.add("SSL_DHE_RSA_WITH_DES_CBC_SHA", 21, --n, KeyExchange.K_DHE_RSA, B_DES, bl, n4);
            CipherSuite.add("SSL_DHE_DSS_WITH_DES_CBC_SHA", 18, --n, KeyExchange.K_DHE_DSS, B_DES, bl, n4);
            CipherSuite.add("SSL_DH_anon_WITH_DES_CBC_SHA", 26, --n, KeyExchange.K_DH_ANON, B_DES, bl, n4);
            CipherSuite.add("SSL_RSA_EXPORT_WITH_RC4_40_MD5", 3, --n, KeyExchange.K_RSA_EXPORT, B_RC4_40, bl, n3);
            CipherSuite.add("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", 23, --n, KeyExchange.K_DH_ANON, B_RC4_40, bl, n3);
            CipherSuite.add("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", 8, --n, KeyExchange.K_RSA_EXPORT, B_DES_40, bl, n3);
            CipherSuite.add("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", 20, --n, KeyExchange.K_DHE_RSA, B_DES_40, bl, n3);
            CipherSuite.add("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", 17, --n, KeyExchange.K_DHE_DSS, B_DES_40, bl, n3);
            CipherSuite.add("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", 25, --n, KeyExchange.K_DH_ANON, B_DES_40, bl, n3);
        }
        if (PRESERVE_RC4) {
            CipherSuite.add("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", 49175, --n, KeyExchange.K_ECDH_ANON, B_3DES, true);
            CipherSuite.add("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", 27, --n, KeyExchange.K_DH_ANON, B_3DES, bl);
        }
        CipherSuite.add("TLS_RSA_WITH_NULL_SHA256", 59, --n, KeyExchange.K_RSA, B_NULL, bl, n2, n4, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_NULL_SHA", 49158, --n, KeyExchange.K_ECDHE_ECDSA, B_NULL, bl);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_NULL_SHA", 49168, --n, KeyExchange.K_ECDHE_RSA, B_NULL, bl);
        CipherSuite.add("SSL_RSA_WITH_NULL_SHA", 2, --n, KeyExchange.K_RSA, B_NULL, bl);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_NULL_SHA", 49153, --n, KeyExchange.K_ECDH_ECDSA, B_NULL, bl);
        CipherSuite.add("TLS_ECDH_RSA_WITH_NULL_SHA", 49163, --n, KeyExchange.K_ECDH_RSA, B_NULL, bl);
        CipherSuite.add("TLS_ECDH_anon_WITH_NULL_SHA", 49173, --n, KeyExchange.K_ECDH_ANON, B_NULL, bl);
        CipherSuite.add("SSL_RSA_WITH_NULL_MD5", 1, --n, KeyExchange.K_RSA, B_NULL, bl);
        if (PRESERVE_RC4) {
            CipherSuite.add("SSL_RSA_WITH_DES_CBC_SHA", 9, --n, KeyExchange.K_RSA, B_DES, bl, n4);
            CipherSuite.add("SSL_DHE_RSA_WITH_DES_CBC_SHA", 21, --n, KeyExchange.K_DHE_RSA, B_DES, bl, n4);
            CipherSuite.add("SSL_DHE_DSS_WITH_DES_CBC_SHA", 18, --n, KeyExchange.K_DHE_DSS, B_DES, bl, n4);
            CipherSuite.add("SSL_DH_anon_WITH_DES_CBC_SHA", 26, --n, KeyExchange.K_DH_ANON, B_DES, bl, n4);
            CipherSuite.add("SSL_RSA_EXPORT_WITH_RC4_40_MD5", 3, --n, KeyExchange.K_RSA_EXPORT, B_RC4_40, bl, n3);
            CipherSuite.add("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", 23, --n, KeyExchange.K_DH_ANON, B_RC4_40, bl, n3);
            CipherSuite.add("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", 8, --n, KeyExchange.K_RSA_EXPORT, B_DES_40, bl, n3);
            CipherSuite.add("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", 20, --n, KeyExchange.K_DHE_RSA, B_DES_40, bl, n3);
            CipherSuite.add("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", 17, --n, KeyExchange.K_DHE_DSS, B_DES_40, bl, n3);
            CipherSuite.add("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", 25, --n, KeyExchange.K_DH_ANON, B_DES_40, bl, n3);
        }
        if (!PRESERVE_RC4) {
            CipherSuite.add("TLS_KRB5_WITH_3DES_EDE_CBC_SHA", 31, --n, KeyExchange.K_KRB5, B_3DES, bl);
            CipherSuite.add("TLS_KRB5_WITH_3DES_EDE_CBC_MD5", 35, --n, KeyExchange.K_KRB5, B_3DES, bl);
        }
        CipherSuite.add("TLS_KRB5_WITH_RC4_128_SHA", 32, --n, KeyExchange.K_KRB5, B_RC4_128, bl);
        CipherSuite.add("TLS_KRB5_WITH_RC4_128_MD5", 36, --n, KeyExchange.K_KRB5, B_RC4_128, bl);
        if (PRESERVE_RC4) {
            CipherSuite.add("TLS_KRB5_WITH_3DES_EDE_CBC_SHA", 31, --n, KeyExchange.K_KRB5, B_3DES, bl);
            CipherSuite.add("TLS_KRB5_WITH_3DES_EDE_CBC_MD5", 35, --n, KeyExchange.K_KRB5, B_3DES, bl);
        }
        CipherSuite.add("TLS_KRB5_WITH_DES_CBC_SHA", 30, --n, KeyExchange.K_KRB5, B_DES, bl, n4);
        CipherSuite.add("TLS_KRB5_WITH_DES_CBC_MD5", 34, --n, KeyExchange.K_KRB5, B_DES, bl, n4);
        if (!PRESERVE_RC4) {
            CipherSuite.add("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", 38, --n, KeyExchange.K_KRB5_EXPORT, B_DES_40, bl, n3);
            CipherSuite.add("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", 41, --n, KeyExchange.K_KRB5_EXPORT, B_DES_40, bl, n3);
        }
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_RC4_40_SHA", 40, --n, KeyExchange.K_KRB5_EXPORT, B_RC4_40, bl, n3);
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_RC4_40_MD5", 43, --n, KeyExchange.K_KRB5_EXPORT, B_RC4_40, bl, n3);
        if (PRESERVE_RC4) {
            CipherSuite.add("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", 38, --n, KeyExchange.K_KRB5_EXPORT, B_DES_40, bl, n3);
            CipherSuite.add("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", 41, --n, KeyExchange.K_KRB5_EXPORT, B_DES_40, bl, n3);
        }
        CipherSuite.add("SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", 6);
        CipherSuite.add("SSL_RSA_WITH_IDEA_CBC_SHA", 7);
        CipherSuite.add("SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", 11);
        CipherSuite.add("SSL_DH_DSS_WITH_DES_CBC_SHA", 12);
        CipherSuite.add("SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA", 13);
        CipherSuite.add("SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", 14);
        CipherSuite.add("SSL_DH_RSA_WITH_DES_CBC_SHA", 15);
        CipherSuite.add("SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA", 16);
        CipherSuite.add("SSL_FORTEZZA_DMS_WITH_NULL_SHA", 28);
        CipherSuite.add("SSL_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA", 29);
        CipherSuite.add("SSL_RSA_EXPORT1024_WITH_DES_CBC_SHA", 98);
        CipherSuite.add("SSL_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA", 99);
        CipherSuite.add("SSL_RSA_EXPORT1024_WITH_RC4_56_SHA", 100);
        CipherSuite.add("SSL_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA", 101);
        CipherSuite.add("SSL_DHE_DSS_WITH_RC4_128_SHA", 102);
        CipherSuite.add("NETSCAPE_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", 65504);
        CipherSuite.add("NETSCAPE_RSA_FIPS_WITH_DES_CBC_SHA", 65505);
        CipherSuite.add("SSL_RSA_FIPS_WITH_DES_CBC_SHA", 65278);
        CipherSuite.add("SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", 65279);
        CipherSuite.add("TLS_KRB5_WITH_IDEA_CBC_SHA", 33);
        CipherSuite.add("TLS_KRB5_WITH_IDEA_CBC_MD5", 37);
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA", 39);
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5", 42);
        CipherSuite.add("TLS_RSA_WITH_SEED_CBC_SHA", 150);
        CipherSuite.add("TLS_DH_DSS_WITH_SEED_CBC_SHA", 151);
        CipherSuite.add("TLS_DH_RSA_WITH_SEED_CBC_SHA", 152);
        CipherSuite.add("TLS_DHE_DSS_WITH_SEED_CBC_SHA", 153);
        CipherSuite.add("TLS_DHE_RSA_WITH_SEED_CBC_SHA", 154);
        CipherSuite.add("TLS_DH_anon_WITH_SEED_CBC_SHA", 155);
        CipherSuite.add("TLS_PSK_WITH_RC4_128_SHA", 138);
        CipherSuite.add("TLS_PSK_WITH_3DES_EDE_CBC_SHA", 139);
        CipherSuite.add("TLS_PSK_WITH_AES_128_CBC_SHA", 140);
        CipherSuite.add("TLS_PSK_WITH_AES_256_CBC_SHA", 141);
        CipherSuite.add("TLS_DHE_PSK_WITH_RC4_128_SHA", 142);
        CipherSuite.add("TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA", 143);
        CipherSuite.add("TLS_DHE_PSK_WITH_AES_128_CBC_SHA", 144);
        CipherSuite.add("TLS_DHE_PSK_WITH_AES_256_CBC_SHA", 145);
        CipherSuite.add("TLS_RSA_PSK_WITH_RC4_128_SHA", 146);
        CipherSuite.add("TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA", 147);
        CipherSuite.add("TLS_RSA_PSK_WITH_AES_128_CBC_SHA", 148);
        CipherSuite.add("TLS_RSA_PSK_WITH_AES_256_CBC_SHA", 149);
        CipherSuite.add("TLS_PSK_WITH_NULL_SHA", 44);
        CipherSuite.add("TLS_DHE_PSK_WITH_NULL_SHA", 45);
        CipherSuite.add("TLS_RSA_PSK_WITH_NULL_SHA", 46);
        CipherSuite.add("TLS_DH_DSS_WITH_AES_128_CBC_SHA", 48);
        CipherSuite.add("TLS_DH_RSA_WITH_AES_128_CBC_SHA", 49);
        CipherSuite.add("TLS_DH_DSS_WITH_AES_256_CBC_SHA", 54);
        CipherSuite.add("TLS_DH_RSA_WITH_AES_256_CBC_SHA", 55);
        CipherSuite.add("TLS_DH_DSS_WITH_AES_128_CBC_SHA256", 62);
        CipherSuite.add("TLS_DH_RSA_WITH_AES_128_CBC_SHA256", 63);
        CipherSuite.add("TLS_DH_DSS_WITH_AES_256_CBC_SHA256", 104);
        CipherSuite.add("TLS_DH_RSA_WITH_AES_256_CBC_SHA256", 105);
        CipherSuite.add("TLS_RSA_WITH_AES_128_GCM_SHA256", 156);
        CipherSuite.add("TLS_RSA_WITH_AES_256_GCM_SHA384", 157);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", 158);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", 159);
        CipherSuite.add("TLS_DH_RSA_WITH_AES_128_GCM_SHA256", 160);
        CipherSuite.add("TLS_DH_RSA_WITH_AES_256_GCM_SHA384", 161);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", 162);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", 163);
        CipherSuite.add("TLS_DH_DSS_WITH_AES_128_GCM_SHA256", 164);
        CipherSuite.add("TLS_DH_DSS_WITH_AES_256_GCM_SHA384", 165);
        CipherSuite.add("TLS_DH_anon_WITH_AES_128_GCM_SHA256", 166);
        CipherSuite.add("TLS_DH_anon_WITH_AES_256_GCM_SHA384", 167);
        CipherSuite.add("TLS_PSK_WITH_AES_128_GCM_SHA256", 168);
        CipherSuite.add("TLS_PSK_WITH_AES_256_GCM_SHA384", 169);
        CipherSuite.add("TLS_DHE_PSK_WITH_AES_128_GCM_SHA256", 170);
        CipherSuite.add("TLS_DHE_PSK_WITH_AES_256_GCM_SHA384", 171);
        CipherSuite.add("TLS_RSA_PSK_WITH_AES_128_GCM_SHA256", 172);
        CipherSuite.add("TLS_RSA_PSK_WITH_AES_256_GCM_SHA384", 173);
        CipherSuite.add("TLS_PSK_WITH_AES_128_CBC_SHA256", 174);
        CipherSuite.add("TLS_PSK_WITH_AES_256_CBC_SHA384", 175);
        CipherSuite.add("TLS_PSK_WITH_NULL_SHA256", 176);
        CipherSuite.add("TLS_PSK_WITH_NULL_SHA384", 177);
        CipherSuite.add("TLS_DHE_PSK_WITH_AES_128_CBC_SHA256", 178);
        CipherSuite.add("TLS_DHE_PSK_WITH_AES_256_CBC_SHA384", 179);
        CipherSuite.add("TLS_DHE_PSK_WITH_NULL_SHA256", 180);
        CipherSuite.add("TLS_DHE_PSK_WITH_NULL_SHA384", 181);
        CipherSuite.add("TLS_RSA_PSK_WITH_AES_128_CBC_SHA256", 182);
        CipherSuite.add("TLS_RSA_PSK_WITH_AES_256_CBC_SHA384", 183);
        CipherSuite.add("TLS_RSA_PSK_WITH_NULL_SHA256", 184);
        CipherSuite.add("TLS_RSA_PSK_WITH_NULL_SHA384", 185);
        CipherSuite.add("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA", 65);
        CipherSuite.add("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA", 66);
        CipherSuite.add("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA", 67);
        CipherSuite.add("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA", 68);
        CipherSuite.add("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA", 69);
        CipherSuite.add("TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA", 70);
        CipherSuite.add("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA", 132);
        CipherSuite.add("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA", 133);
        CipherSuite.add("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA", 134);
        CipherSuite.add("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA", 135);
        CipherSuite.add("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA", 136);
        CipherSuite.add("TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA", 137);
        CipherSuite.add("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256", 186);
        CipherSuite.add("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256", 187);
        CipherSuite.add("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256", 188);
        CipherSuite.add("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256", 189);
        CipherSuite.add("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", 190);
        CipherSuite.add("TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256", 191);
        CipherSuite.add("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256", 192);
        CipherSuite.add("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256", 193);
        CipherSuite.add("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256", 194);
        CipherSuite.add("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256", 195);
        CipherSuite.add("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256", 196);
        CipherSuite.add("TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256", 197);
        CipherSuite.add("TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA", 49178);
        CipherSuite.add("TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA", 49179);
        CipherSuite.add("TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA", 49180);
        CipherSuite.add("TLS_SRP_SHA_WITH_AES_128_CBC_SHA", 49181);
        CipherSuite.add("TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA", 49182);
        CipherSuite.add("TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA", 49183);
        CipherSuite.add("TLS_SRP_SHA_WITH_AES_256_CBC_SHA", 49184);
        CipherSuite.add("TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA", 49185);
        CipherSuite.add("TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA", 49186);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 49195);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 49196);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", 49197);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", 49198);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 49199);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 49200);
        CipherSuite.add("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", 49201);
        CipherSuite.add("TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", 49202);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_RC4_128_SHA", 49203);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA", 49204);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA", 49205);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA", 49206);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256", 49207);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384", 49208);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_NULL_SHA", 49209);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_NULL_SHA256", 49210);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_NULL_SHA384", 49211);
        C_NULL = CipherSuite.valueOf(0, 0);
        C_SCSV = CipherSuite.valueOf(0, 255);
    }

    static enum PRF {
        P_NONE("NONE", 0, 0),
        P_SHA256("SHA-256", 32, 64),
        P_SHA384("SHA-384", 48, 128),
        P_SHA512("SHA-512", 64, 128);

        private final String prfHashAlg;
        private final int prfHashLength;
        private final int prfBlockSize;

        private PRF(String string2, int n2, int n3) {
            this.prfHashAlg = string2;
            this.prfHashLength = n2;
            this.prfBlockSize = n3;
        }

        String getPRFHashAlg() {
            return this.prfHashAlg;
        }

        int getPRFHashLength() {
            return this.prfHashLength;
        }

        int getPRFBlockSize() {
            return this.prfBlockSize;
        }
    }

    static final class MacAlg {
        final String name;
        final int size;
        final int hashBlockSize;
        final int minimalPaddingSize;

        MacAlg(String string, int n, int n2, int n3) {
            this.name = string;
            this.size = n;
            this.hashBlockSize = n2;
            this.minimalPaddingSize = n3;
        }

        MAC newMac(ProtocolVersion protocolVersion, SecretKey secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
            return new MAC(this, protocolVersion, secretKey);
        }

        public String toString() {
            return this.name;
        }
    }

    static final class BulkCipher {
        private static final Map<BulkCipher, Boolean> availableCache = new HashMap<BulkCipher, Boolean>(8);
        final String description;
        final String transformation;
        final String algorithm;
        final boolean allowed;
        final int keySize;
        final int expandedKeySize;
        final int ivSize;
        final boolean exportable;
        final boolean isCBCMode;

        BulkCipher(String string, int n, int n2, int n3, boolean bl) {
            this.transformation = string;
            String[] stringArray = string.split("/");
            this.algorithm = stringArray[0];
            this.isCBCMode = stringArray.length <= 1 ? false : "CBC".equalsIgnoreCase(stringArray[1]);
            this.description = this.algorithm + "/" + (n << 3);
            this.keySize = n;
            this.ivSize = n3;
            this.allowed = bl;
            this.expandedKeySize = n2;
            this.exportable = true;
        }

        BulkCipher(String string, int n, int n2, boolean bl) {
            this.transformation = string;
            String[] stringArray = string.split("/");
            this.algorithm = stringArray[0];
            this.isCBCMode = stringArray.length <= 1 ? false : "CBC".equalsIgnoreCase(stringArray[1]);
            this.description = this.algorithm + "/" + (n << 3);
            this.keySize = n;
            this.ivSize = n2;
            this.allowed = bl;
            this.expandedKeySize = n;
            this.exportable = false;
        }

        CipherBox newCipher(ProtocolVersion protocolVersion, SecretKey secretKey, IvParameterSpec ivParameterSpec, SecureRandom secureRandom, boolean bl) throws NoSuchAlgorithmException {
            return CipherBox.newCipherBox(protocolVersion, this, secretKey, ivParameterSpec, secureRandom, bl);
        }

        boolean isAvailable() {
            if (!this.allowed) {
                return false;
            }
            if (this == B_AES_256) {
                return BulkCipher.isAvailable(this);
            }
            return true;
        }

        static synchronized void clearAvailableCache() {
            availableCache.clear();
        }

        private static synchronized boolean isAvailable(BulkCipher bulkCipher) {
            Boolean bl = availableCache.get(bulkCipher);
            if (bl == null) {
                try {
                    SecretKeySpec secretKeySpec = new SecretKeySpec(new byte[bulkCipher.expandedKeySize], bulkCipher.algorithm);
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[bulkCipher.ivSize]);
                    bulkCipher.newCipher(ProtocolVersion.DEFAULT, secretKeySpec, ivParameterSpec, null, true);
                    bl = Boolean.TRUE;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    bl = Boolean.FALSE;
                }
                availableCache.put(bulkCipher, bl);
            }
            return bl;
        }

        public String toString() {
            return this.description;
        }
    }

    static enum KeyExchange {
        K_NULL("NULL", false),
        K_RSA("RSA", true),
        K_RSA_EXPORT("RSA_EXPORT", true),
        K_DH_RSA("DH_RSA", false),
        K_DH_DSS("DH_DSS", false),
        K_DHE_DSS("DHE_DSS", true),
        K_DHE_RSA("DHE_RSA", true),
        K_DH_ANON("DH_anon", true),
        K_ECDH_ECDSA("ECDH_ECDSA", CipherSuite.access$000()),
        K_ECDH_RSA("ECDH_RSA", CipherSuite.access$000()),
        K_ECDHE_ECDSA("ECDHE_ECDSA", CipherSuite.access$000()),
        K_ECDHE_RSA("ECDHE_RSA", CipherSuite.access$000()),
        K_ECDH_ANON("ECDH_anon", CipherSuite.access$000()),
        K_KRB5("KRB5", true),
        K_KRB5_EXPORT("KRB5_EXPORT", true),
        K_SCSV("SCSV", true);

        final String name;
        final boolean allowed;
        private final boolean alwaysAvailable;

        private KeyExchange(String string2, boolean bl) {
            this.name = string2;
            this.allowed = bl;
            this.alwaysAvailable = bl && !string2.startsWith("EC") && !string2.startsWith("KRB");
        }

        boolean isAvailable() {
            if (this.alwaysAvailable) {
                return true;
            }
            if (this.name.startsWith("EC")) {
                return this.allowed && JsseJce.isEcAvailable();
            }
            if (this.name.startsWith("KRB")) {
                return this.allowed && JsseJce.isKerberosAvailable();
            }
            return this.allowed;
        }

        public String toString() {
            return this.name;
        }
    }
}

