/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XDragAndDropProtocols;
import sun.awt.X11.XDragSourceProtocol;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XEmbedCanvasPeer;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XErrorHandlerUtil;
import sun.awt.X11.XException;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.util.logging.PlatformLogger;

final class XDropTargetRegistry {
    private static final PlatformLogger logger = PlatformLogger.getLogger("sun.awt.X11.xembed.xdnd.XDropTargetRegistry");
    private static final long DELAYED_REGISTRATION_PERIOD = 200L;
    private static final XDropTargetRegistry theInstance = new XDropTargetRegistry();
    private final HashMap<Long, Runnable> delayedRegistrationMap = new HashMap();
    private final HashMap<Long, EmbeddedDropSiteEntry> embeddedDropSiteRegistry = new HashMap();
    private static final boolean XEMBED_PROTOCOLS = true;
    private static final boolean NON_XEMBED_PROTOCOLS = false;

    private XDropTargetRegistry() {
    }

    static XDropTargetRegistry getRegistry() {
        return theInstance;
    }

    private long getToplevelWindow(long l) {
        XWindowPeer xWindowPeer;
        XBaseWindow xBaseWindow = XToolkit.windowToXWindow(l);
        if (xBaseWindow != null && (xWindowPeer = xBaseWindow.getToplevelXWindow()) != null && !(xWindowPeer instanceof XEmbeddedFramePeer)) {
            return xWindowPeer.getWindow();
        }
        do {
            if (!XlibUtil.isTrueToplevelWindow(l)) continue;
            return l;
        } while ((l = XlibUtil.getParentWindow(l)) != 0L);
        return l;
    }

    static final long getDnDProxyWindow() {
        return XWindow.getXAWTRootWindow().getWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmbeddedDropSiteEntry registerEmbedderDropSite(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
        List<XDropTargetProtocol> list = new ArrayList();
        while (iterator.hasNext()) {
            XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
            if (!xDropTargetProtocol.isProtocolSupported(l)) continue;
            list.add(xDropTargetProtocol);
        }
        list = Collections.unmodifiableList(list);
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            long l2 = 0L;
            long l3 = 0L;
            XWindowAttributes xWindowAttributes = new XWindowAttributes();
            try {
                XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                int n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
                XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
                if (n == 0 || XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                    throw new XException("XGetWindowAttributes failed");
                }
                l3 = xWindowAttributes.get_your_event_mask();
                l2 = xWindowAttributes.get_root();
            }
            finally {
                xWindowAttributes.dispose();
            }
            if ((l3 & 0x400000L) == 0L) {
                XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), l, l3 | 0x400000L);
                XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
                if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                    throw new XException("XSelectInput failed");
                }
            }
            EmbeddedDropSiteEntry embeddedDropSiteEntry = new EmbeddedDropSiteEntry(l2, l3, list);
            return embeddedDropSiteEntry;
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProtocols(long l, boolean bl, List<XDropTargetProtocol> list) {
        Iterator<XDropTargetProtocol> iterator = null;
        iterator = !list.isEmpty() ? list.iterator() : XDragAndDropProtocols.getDropTargetProtocols();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            while (iterator.hasNext()) {
                XDropTargetProtocol xDropTargetProtocol;
                if (bl != (xDropTargetProtocol = iterator.next()).isXEmbedSupported()) continue;
                xDropTargetProtocol.registerEmbedderDropSite(l);
            }
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEmbedderDropSite(long l) {
        Object object;
        XBaseWindow xBaseWindow = XToolkit.windowToXWindow(l);
        if (xBaseWindow != null) {
            return;
        }
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        Iterator<XDropTargetProtocol> iterator = XDragAndDropProtocols.getDropTargetProtocols();
        List<XDropTargetProtocol> list = new ArrayList();
        while (iterator.hasNext()) {
            object = (XDropTargetProtocol)iterator.next();
            if (!((XDropTargetProtocol)object).isProtocolSupported(l)) continue;
            list.add((XDropTargetProtocol)object);
        }
        list = Collections.unmodifiableList(list);
        object = l;
        boolean bl = false;
        Object object2 = this;
        synchronized (object2) {
            EmbeddedDropSiteEntry embeddedDropSiteEntry = this.embeddedDropSiteRegistry.get(object);
            if (embeddedDropSiteEntry == null) {
                return;
            }
            embeddedDropSiteEntry.setSupportedProtocols(list);
            bl = !embeddedDropSiteEntry.hasNonXEmbedClientSites();
        }
        iterator = !list.isEmpty() ? list.iterator() : XDragAndDropProtocols.getDropTargetProtocols();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (bl && ((XDropTargetProtocol)object2).isXEmbedSupported()) continue;
                ((XDropTargetProtocol)object2).registerEmbedderDropSite(l);
            }
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterEmbedderDropSite(long l, EmbeddedDropSiteEntry embeddedDropSiteEntry) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            while (iterator.hasNext()) {
                XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                xDropTargetProtocol.unregisterEmbedderDropSite(l);
            }
            long l2 = embeddedDropSiteEntry.getEventMask();
            if ((l2 & 0x400000L) == 0L) {
                XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), l, l2);
                XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
                if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                    throw new XException("XSelectInput failed");
                }
            }
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEmbeddedDropSite(long l, long l2) {
        XBaseWindow xBaseWindow = XToolkit.windowToXWindow(l2);
        boolean bl = xBaseWindow instanceof XEmbeddedFramePeer && ((XEmbeddedFramePeer)xBaseWindow).isXEmbedActive();
        XEmbedCanvasPeer xEmbedCanvasPeer = null;
        Object object = XToolkit.windowToXWindow(l);
        if (object != null) {
            if (object instanceof XEmbedCanvasPeer) {
                xEmbedCanvasPeer = (XEmbedCanvasPeer)object;
            } else {
                throw new UnsupportedOperationException();
            }
        }
        object = l;
        EmbeddedDropSiteEntry embeddedDropSiteEntry = null;
        Object object2 = this;
        synchronized (object2) {
            embeddedDropSiteEntry = this.embeddedDropSiteRegistry.get(object);
            if (embeddedDropSiteEntry == null) {
                if (xEmbedCanvasPeer != null) {
                    xEmbedCanvasPeer.setXEmbedDropTarget();
                    embeddedDropSiteEntry = new EmbeddedDropSiteEntry(0L, 0L, Collections.emptyList());
                } else {
                    embeddedDropSiteEntry = this.registerEmbedderDropSite(l);
                    this.registerProtocols(l, false, embeddedDropSiteEntry.getSupportedProtocols());
                }
                this.embeddedDropSiteRegistry.put((Long)object, embeddedDropSiteEntry);
            }
        }
        assert (embeddedDropSiteEntry != null);
        object2 = embeddedDropSiteEntry;
        synchronized (object2) {
            if (xEmbedCanvasPeer == null) {
                if (!bl) {
                    this.registerProtocols(l, true, embeddedDropSiteEntry.getSupportedProtocols());
                } else {
                    Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
                    while (iterator.hasNext()) {
                        XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                        if (!xDropTargetProtocol.isXEmbedSupported()) continue;
                        xDropTargetProtocol.registerEmbedderDropSite(l2);
                    }
                }
            }
            embeddedDropSiteEntry.addSite(l2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unregisterEmbeddedDropSite(long l, long l2) {
        Long l3 = l;
        EmbeddedDropSiteEntry embeddedDropSiteEntry = null;
        XDropTargetRegistry xDropTargetRegistry = this;
        synchronized (xDropTargetRegistry) {
            embeddedDropSiteEntry = this.embeddedDropSiteRegistry.get(l3);
            if (embeddedDropSiteEntry == null) {
                return;
            }
            embeddedDropSiteEntry.removeSite(l2);
            if (embeddedDropSiteEntry.hasSites()) return;
            this.embeddedDropSiteRegistry.remove(l3);
            XBaseWindow xBaseWindow = XToolkit.windowToXWindow(l);
            if (xBaseWindow != null) {
                if (!(xBaseWindow instanceof XEmbedCanvasPeer)) throw new UnsupportedOperationException();
                XEmbedCanvasPeer xEmbedCanvasPeer = (XEmbedCanvasPeer)xBaseWindow;
                xEmbedCanvasPeer.removeXEmbedDropTarget();
            } else {
                this.unregisterEmbedderDropSite(l, embeddedDropSiteEntry);
            }
            return;
        }
    }

    public long getEmbeddedDropSite(long l, int n, int n2) {
        Long l2 = l;
        EmbeddedDropSiteEntry embeddedDropSiteEntry = this.embeddedDropSiteRegistry.get(l2);
        if (embeddedDropSiteEntry == null) {
            return 0L;
        }
        return embeddedDropSiteEntry.getSite(n, n2);
    }

    public void registerDropSite(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        if (l == 0L) {
            throw new IllegalArgumentException();
        }
        XDropTargetEventProcessor.activate();
        long l2 = this.getToplevelWindow(l);
        if (l2 == 0L) {
            this.addDelayedRegistrationEntry(l);
            return;
        }
        if (l2 == l) {
            Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
            while (iterator.hasNext()) {
                XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                xDropTargetProtocol.registerDropTarget(l2);
            }
        } else {
            this.registerEmbeddedDropSite(l2, l);
        }
    }

    public void unregisterDropSite(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        if (l == 0L) {
            throw new IllegalArgumentException();
        }
        long l2 = this.getToplevelWindow(l);
        if (l2 == l) {
            Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
            this.removeDelayedRegistrationEntry(l);
            while (iterator.hasNext()) {
                XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                xDropTargetProtocol.unregisterDropTarget(l);
            }
        } else {
            this.unregisterEmbeddedDropSite(l2, l);
        }
    }

    public void registerXEmbedClient(long l, long l2) {
        XDragSourceProtocol xDragSourceProtocol = XDragAndDropProtocols.getDragSourceProtocol("XDnD");
        XDragSourceProtocol.TargetWindowInfo targetWindowInfo = xDragSourceProtocol.getTargetWindowInfo(l2);
        if (targetWindowInfo != null && targetWindowInfo.getProtocolVersion() >= 3) {
            if (logger.isLoggable(500)) {
                logger.fine("        XEmbed drop site will be registered for " + Long.toHexString(l2));
            }
            this.registerEmbeddedDropSite(l, l2);
            Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
            while (iterator.hasNext()) {
                XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                xDropTargetProtocol.registerEmbeddedDropSite(l2);
            }
            if (logger.isLoggable(500)) {
                logger.fine("        XEmbed drop site has been registered for " + Long.toHexString(l2));
            }
        }
    }

    public void unregisterXEmbedClient(long l, long l2) {
        if (logger.isLoggable(500)) {
            logger.fine("        XEmbed drop site will be unregistered for " + Long.toHexString(l2));
        }
        Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
        while (iterator.hasNext()) {
            XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
            xDropTargetProtocol.unregisterEmbeddedDropSite(l2);
        }
        this.unregisterEmbeddedDropSite(l, l2);
        if (logger.isLoggable(500)) {
            logger.fine("        XEmbed drop site has beed unregistered for " + Long.toHexString(l2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDelayedRegistrationEntry(final long l) {
        Long l2 = l;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                XDropTargetRegistry.this.removeDelayedRegistrationEntry(l);
                XDropTargetRegistry.this.registerDropSite(l);
            }
        };
        XToolkit.awtLock();
        try {
            this.removeDelayedRegistrationEntry(l);
            this.delayedRegistrationMap.put(l2, runnable);
            XToolkit.schedule(runnable, 200L);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDelayedRegistrationEntry(long l) {
        Long l2 = l;
        XToolkit.awtLock();
        try {
            Runnable runnable = this.delayedRegistrationMap.remove(l2);
            if (runnable != null) {
                XToolkit.remove(runnable);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private static final class EmbeddedDropSiteEntry {
        private final long root;
        private final long event_mask;
        private List<XDropTargetProtocol> supportedProtocols;
        private final HashSet<Long> nonXEmbedClientSites = new HashSet();
        private final List<Long> sites = new ArrayList<Long>();

        public EmbeddedDropSiteEntry(long l, long l2, List<XDropTargetProtocol> list) {
            if (list == null) {
                throw new NullPointerException("Null supportedProtocols");
            }
            this.root = l;
            this.event_mask = l2;
            this.supportedProtocols = list;
        }

        public long getRoot() {
            return this.root;
        }

        public long getEventMask() {
            return this.event_mask;
        }

        public boolean hasNonXEmbedClientSites() {
            return !this.nonXEmbedClientSites.isEmpty();
        }

        public synchronized void addSite(long l, boolean bl) {
            Long l2 = l;
            if (!this.sites.contains(l2)) {
                this.sites.add(l2);
            }
            if (!bl) {
                this.nonXEmbedClientSites.add(l2);
            }
        }

        public synchronized void removeSite(long l) {
            Long l2 = l;
            this.sites.remove(l2);
            this.nonXEmbedClientSites.remove(l2);
        }

        public void setSupportedProtocols(List<XDropTargetProtocol> list) {
            this.supportedProtocols = list;
        }

        public List<XDropTargetProtocol> getSupportedProtocols() {
            return this.supportedProtocols;
        }

        public boolean hasSites() {
            return !this.sites.isEmpty();
        }

        public long[] getSites() {
            long[] lArray = new long[this.sites.size()];
            Iterator<Long> iterator = this.sites.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Long l = iterator.next();
                lArray[n++] = l;
            }
            return lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getSite(int n, int n2) {
            assert (XToolkit.isAWTLockHeldByCurrentThread());
            for (Long l : this.sites) {
                long l2 = l;
                Point point = XBaseWindow.toOtherWindow(this.getRoot(), l2, n, n2);
                if (point == null) continue;
                int n3 = point.x;
                int n4 = point.y;
                if (n3 < 0 || n4 < 0) continue;
                XWindowAttributes xWindowAttributes = new XWindowAttributes();
                try {
                    XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                    int n5 = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l2, xWindowAttributes.pData);
                    XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
                    if (n5 == 0 || XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0 || xWindowAttributes.get_map_state() == 0 || n3 >= xWindowAttributes.get_width() || n4 >= xWindowAttributes.get_height()) continue;
                    long l3 = l2;
                    return l3;
                }
                finally {
                    xWindowAttributes.dispose();
                }
            }
            return 0L;
        }
    }
}

