/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImageryReader {
    private final String source;

    public ImageryReader(String string) {
        this.source = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ImageryInfo> parse() throws SAXException, IOException {
        Parser parser = new Parser();
        try (InputStream inputStream = new CachedFile(this.source).setMaxAge(86400L).setCachingStrategy(CachedFile.CachingStrategy.IfModifiedSince).getInputStream();){
            InputSource inputSource = new InputSource(UTFInputStreamReader.create(inputStream));
            Utils.parseSafeSAX(inputSource, parser);
            List list = parser.entries;
            return list;
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Main.error(parserConfigurationException);
            throw new SAXException(parserConfigurationException);
        }
    }

    private static class Parser
    extends DefaultHandler {
        private StringBuilder accumulator = new StringBuilder();
        private Stack<State> states;
        private List<ImageryInfo> entries;
        private boolean skipEntry;
        private ImageryInfo entry;
        private ImageryInfo.ImageryBounds bounds;
        private Shape shape;
        private String lang;
        private List<String> projections;
        private Map<String, String> noTileHeaders;
        private Map<String, String> metadataHeaders;

        private Parser() {
        }

        @Override
        public void startDocument() {
            this.accumulator = new StringBuilder();
            this.skipEntry = false;
            this.states = new Stack();
            this.states.push(State.INIT);
            this.entries = new ArrayList<ImageryInfo>();
            this.entry = null;
            this.bounds = null;
            this.projections = null;
            this.noTileHeaders = null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.accumulator.setLength(0);
            State state = null;
            switch (this.states.peek()) {
                case INIT: {
                    if (!"imagery".equals(string3)) break;
                    state = State.IMAGERY;
                    break;
                }
                case IMAGERY: {
                    if (!"entry".equals(string3)) break;
                    this.entry = new ImageryInfo();
                    this.skipEntry = false;
                    state = State.ENTRY;
                    this.noTileHeaders = new HashMap<String, String>();
                    this.metadataHeaders = new HashMap<String, String>();
                    break;
                }
                case ENTRY: {
                    if (Arrays.asList("name", "id", "type", "description", "default", "url", "eula", "min-zoom", "max-zoom", "attribution-text", "attribution-url", "logo-image", "logo-url", "terms-of-use-text", "terms-of-use-url", "country-code", "icon", "tile-size", "validGeoreference", "epsg4326to3857Supported").contains(string3)) {
                        state = State.ENTRY_ATTRIBUTE;
                        this.lang = attributes.getValue("lang");
                        break;
                    }
                    if ("bounds".equals(string3)) {
                        try {
                            this.bounds = new ImageryInfo.ImageryBounds(attributes.getValue("min-lat") + ',' + attributes.getValue("min-lon") + ',' + attributes.getValue("max-lat") + ',' + attributes.getValue("max-lon"), ",");
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            break;
                        }
                        state = State.BOUNDS;
                        break;
                    }
                    if ("projections".equals(string3)) {
                        this.projections = new ArrayList<String>();
                        state = State.PROJECTIONS;
                        break;
                    }
                    if ("no-tile-header".equals(string3)) {
                        this.noTileHeaders.put(attributes.getValue("name"), attributes.getValue("value"));
                        state = State.NO_TILE;
                        break;
                    }
                    if (!"metadata-header".equals(string3)) break;
                    this.metadataHeaders.put(attributes.getValue("header-name"), attributes.getValue("metadata-key"));
                    state = State.METADATA;
                    break;
                }
                case BOUNDS: {
                    if (!"shape".equals(string3)) break;
                    this.shape = new Shape();
                    state = State.SHAPE;
                    break;
                }
                case SHAPE: {
                    if (!"point".equals(string3)) break;
                    try {
                        this.shape.addPoint(attributes.getValue("lat"), attributes.getValue("lon"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
                case PROJECTIONS: {
                    if (!"code".equals(string3)) break;
                    state = State.CODE;
                }
            }
            if (state == null) {
                state = State.UNKNOWN;
            }
            this.states.push(state);
            if (state == State.UNKNOWN && "true".equals(attributes.getValue("mandatory"))) {
                this.skipEntry = true;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.accumulator.append(cArray, n, n2);
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            switch (this.states.pop()) {
                case INIT: {
                    throw new RuntimeException("parsing error: more closing than opening elements");
                }
                case ENTRY: {
                    if (!"entry".equals(string2)) break;
                    this.entry.setNoTileHeaders(this.noTileHeaders);
                    this.noTileHeaders = null;
                    this.entry.setMetadataHeaders(this.metadataHeaders);
                    this.metadataHeaders = null;
                    if (!this.skipEntry) {
                        this.entries.add(this.entry);
                    }
                    this.entry = null;
                    break;
                }
                case ENTRY_ATTRIBUTE: {
                    block33 : switch (string2) {
                        case "name": {
                            this.entry.setName(this.lang == null ? LanguageInfo.getJOSMLocaleCode(null) : this.lang, this.accumulator.toString());
                            break;
                        }
                        case "description": {
                            this.entry.setDescription(this.lang, this.accumulator.toString());
                            break;
                        }
                        case "id": {
                            this.entry.setId(this.accumulator.toString());
                            break;
                        }
                        case "type": {
                            boolean bl = false;
                            for (ImageryInfo.ImageryType imageryType : ImageryInfo.ImageryType.values()) {
                                if (!Objects.equals(this.accumulator.toString(), imageryType.getTypeString())) continue;
                                this.entry.setImageryType(imageryType);
                                bl = true;
                                break;
                            }
                            if (bl) break;
                            this.skipEntry = true;
                            break;
                        }
                        case "default": {
                            switch (this.accumulator.toString()) {
                                case "true": {
                                    this.entry.setDefaultEntry(true);
                                    break block33;
                                }
                                case "false": {
                                    this.entry.setDefaultEntry(false);
                                    break block33;
                                }
                            }
                            this.skipEntry = true;
                            break;
                        }
                        case "url": {
                            this.entry.setUrl(this.accumulator.toString());
                            break;
                        }
                        case "eula": {
                            this.entry.setEulaAcceptanceRequired(this.accumulator.toString());
                            break;
                        }
                        case "min-zoom": 
                        case "max-zoom": {
                            Integer n = null;
                            try {
                                n = Integer.valueOf(this.accumulator.toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                n = null;
                            }
                            if (n == null) {
                                this.skipEntry = true;
                                break;
                            }
                            if ("min-zoom".equals(string2)) {
                                this.entry.setDefaultMinZoom(n);
                                break;
                            }
                            this.entry.setDefaultMaxZoom(n);
                            break;
                        }
                        case "attribution-text": {
                            this.entry.setAttributionText(this.accumulator.toString());
                            break;
                        }
                        case "attribution-url": {
                            this.entry.setAttributionLinkURL(this.accumulator.toString());
                            break;
                        }
                        case "logo-image": {
                            this.entry.setAttributionImage(this.accumulator.toString());
                            break;
                        }
                        case "logo-url": {
                            this.entry.setAttributionImageURL(this.accumulator.toString());
                            break;
                        }
                        case "terms-of-use-text": {
                            this.entry.setTermsOfUseText(this.accumulator.toString());
                            break;
                        }
                        case "terms-of-use-url": {
                            this.entry.setTermsOfUseURL(this.accumulator.toString());
                            break;
                        }
                        case "country-code": {
                            this.entry.setCountryCode(this.accumulator.toString());
                            break;
                        }
                        case "icon": {
                            this.entry.setIcon(this.accumulator.toString());
                            break;
                        }
                        case "tile-size": {
                            Integer n = null;
                            try {
                                n = Integer.valueOf(this.accumulator.toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                n = null;
                            }
                            if (n == null) {
                                this.skipEntry = true;
                                break;
                            }
                            this.entry.setTileSize(n);
                            break;
                        }
                        case "valid-georeference": {
                            this.entry.setGeoreferenceValid(new Boolean(this.accumulator.toString()));
                            break;
                        }
                        case "epsg4326to3857Supported": {
                            this.entry.setEpsg4326To3857Supported(new Boolean(this.accumulator.toString()));
                        }
                    }
                    break;
                }
                case BOUNDS: {
                    this.entry.setBounds(this.bounds);
                    this.bounds = null;
                    break;
                }
                case SHAPE: {
                    this.bounds.addShape(this.shape);
                    this.shape = null;
                    break;
                }
                case CODE: {
                    this.projections.add(this.accumulator.toString());
                    break;
                }
                case PROJECTIONS: {
                    this.entry.setServerProjections(this.projections);
                    this.projections = null;
                    break;
                }
            }
        }
    }

    private static enum State {
        INIT,
        IMAGERY,
        ENTRY,
        ENTRY_ATTRIBUTE,
        PROJECTIONS,
        CODE,
        BOUNDS,
        SHAPE,
        NO_TILE,
        METADATA,
        UNKNOWN;

    }
}

