/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class EditableList
extends JPanel {
    public final String title;
    public final JList<String> sourcesList = new JList(new DefaultListModel());
    public final JButton addSrcButton = new JButton(I18n.tr("Add", new Object[0]));
    public final JButton editSrcButton = new JButton(I18n.tr("Edit", new Object[0]));
    public final JButton deleteSrcButton = new JButton(I18n.tr("Delete", new Object[0]));

    public EditableList(String string) {
        this.title = string;
        this.build();
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.addSrcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(Main.parent, EditableList.this.title, EditableList.this.title, 3);
                if (string != null) {
                    ((DefaultListModel)EditableList.this.sourcesList.getModel()).addElement(string);
                }
                EditableList.this.sourcesList.clearSelection();
            }
        });
        this.editSrcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = EditableList.this.sourcesList.getSelectedIndex();
                if (n == -1 && EditableList.this.sourcesList.getModel().getSize() == 1) {
                    EditableList.this.sourcesList.setSelectedIndex(0);
                    n = 0;
                }
                if (n == -1) {
                    if (EditableList.this.sourcesList.getModel().getSize() == 0) {
                        String string = JOptionPane.showInputDialog(Main.parent, EditableList.this.title, EditableList.this.title, 3);
                        if (string != null) {
                            ((DefaultListModel)EditableList.this.sourcesList.getModel()).addElement(string);
                        }
                    } else {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to edit.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                    }
                } else {
                    String string = (String)JOptionPane.showInputDialog(Main.parent, EditableList.this.title, EditableList.this.title, 3, null, null, EditableList.this.sourcesList.getSelectedValue());
                    if (string != null) {
                        ((DefaultListModel)EditableList.this.sourcesList.getModel()).setElementAt(string, n);
                    }
                }
                EditableList.this.sourcesList.clearSelection();
            }
        });
        this.deleteSrcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EditableList.this.sourcesList.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to delete.", new Object[0]), I18n.tr("Information", new Object[0]), 3);
                } else {
                    ((DefaultListModel)EditableList.this.sourcesList.getModel()).remove(EditableList.this.sourcesList.getSelectedIndex());
                }
            }
        });
        this.sourcesList.setMinimumSize(new Dimension(300, 50));
        this.sourcesList.setVisibleRowCount(3);
        this.addSrcButton.setToolTipText(I18n.tr("Add a new source to the list.", new Object[0]));
        this.editSrcButton.setToolTipText(I18n.tr("Edit the selected source.", new Object[0]));
        this.deleteSrcButton.setToolTipText(I18n.tr("Delete the selected source from the list.", new Object[0]));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.addSrcButton, GBC.std().insets(0, 5, 0, 0));
        jPanel.add((Component)this.editSrcButton, GBC.std().insets(5, 5, 5, 0));
        jPanel.add((Component)this.deleteSrcButton, GBC.std().insets(0, 5, 0, 0));
        this.add((Component)new JScrollPane(this.sourcesList), "Center");
        this.add((Component)jPanel, "South");
        this.setPreferredSize(new Dimension(300, 50 + (int)jPanel.getPreferredSize().getHeight()));
    }

    public void setItems(Iterable<String> iterable) {
        for (String string : iterable) {
            ((DefaultListModel)this.sourcesList.getModel()).addElement(string);
        }
    }

    public List<String> getItems() {
        ArrayList<String> arrayList = new ArrayList<String>(this.sourcesList.getModel().getSize());
        for (int i = 0; i < this.sourcesList.getModel().getSize(); ++i) {
            arrayList.add(this.sourcesList.getModel().getElementAt(i));
        }
        return arrayList;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.sourcesList.setEnabled(bl);
        this.addSrcButton.setEnabled(bl);
        this.editSrcButton.setEnabled(bl);
        this.deleteSrcButton.setEnabled(bl);
    }
}

