/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.help.HelpBrowserHistory;
import org.openstreetmap.josm.gui.help.HelpContentReader;
import org.openstreetmap.josm.gui.help.HelpContentReaderException;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.MissingHelpContentException;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.gui.widgets.JosmHTMLEditorKit;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.WindowGeometry;

public class HelpBrowser
extends JDialog {
    private static HelpBrowser instance;
    private JMenuItem windowMenuItem;
    private JosmEditorPane help;
    private transient HelpBrowserHistory history;
    private String url;
    private final transient HelpContentReader reader = new HelpContentReader(HelpUtil.getWikiBaseUrl());
    private static final JosmAction focusAction;

    public static synchronized HelpBrowser getInstance() {
        if (instance == null) {
            instance = new HelpBrowser();
        }
        return instance;
    }

    public static void setUrlForHelpTopic(final String string) {
        final HelpBrowser helpBrowser = HelpBrowser.getInstance();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                helpBrowser.openHelpTopic(string);
                helpBrowser.setVisible(true);
                helpBrowser.toFront();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public static void launchBrowser(String string) {
        HelpBrowser helpBrowser = HelpBrowser.getInstance();
        helpBrowser.openHelpTopic(string);
        helpBrowser.setVisible(true);
        helpBrowser.toFront();
    }

    protected StyleSheet buildStyleSheet() {
        StyleSheet styleSheet = new StyleSheet();
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/data/help-browser.css"), StandardCharsets.UTF_8));){
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
        }
        catch (Exception exception) {
            Main.error(I18n.tr("Failed to read CSS file ''help-browser.css''. Exception is: {0}", exception.toString()));
            Main.error(exception);
            return styleSheet;
        }
        styleSheet.addRule(stringBuilder.toString());
        return styleSheet;
    }

    protected JToolBar buildToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new JButton(new HomeAction()));
        jToolBar.add(new JButton(new BackAction(this.history)));
        jToolBar.add(new JButton(new ForwardAction(this.history)));
        jToolBar.add(new JButton(new ReloadAction()));
        jToolBar.add(new JSeparator());
        jToolBar.add(new JButton(new OpenInBrowserAction()));
        jToolBar.add(new JButton(new EditAction()));
        return jToolBar;
    }

    protected final void build() {
        this.help = new JosmEditorPane();
        JosmHTMLEditorKit josmHTMLEditorKit = new JosmHTMLEditorKit();
        josmHTMLEditorKit.setStyleSheet(this.buildStyleSheet());
        this.help.setEditorKit(josmHTMLEditorKit);
        this.help.setEditable(false);
        this.help.addHyperlinkListener(new HyperlinkHandler());
        this.help.setContentType("text/html");
        this.history = new HelpBrowserHistory(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        jPanel.add((Component)new JScrollPane(this.help), "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HelpBrowser.this.setVisible(false);
            }
        });
        jPanel.add((Component)this.buildToolBar(), "North");
        this.help.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Close");
        this.help.getActionMap().put("Close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.this.setVisible(false);
            }
        });
        this.setMinimumSize(new Dimension(400, 200));
        this.setTitle(I18n.tr("JOSM Help Browser", new Object[0]));
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(600, 400))).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        if (Main.main != null && Main.main.menu != null && Main.main.menu.windowMenu != null) {
            if (this.windowMenuItem != null && !bl) {
                Main.main.menu.windowMenu.remove(this.windowMenuItem);
                this.windowMenuItem = null;
            }
            if (this.windowMenuItem == null && bl) {
                this.windowMenuItem = MainMenu.add(Main.main.menu.windowMenu, focusAction, MainMenu.WINDOW_MENU_GROUP.VOLATILE);
            }
        }
        super.setVisible(bl);
    }

    public HelpBrowser() {
        this.build();
    }

    protected void loadTopic(String string) {
        Document document = this.help.getEditorKit().createDefaultDocument();
        try {
            this.help.getEditorKit().read(new StringReader(string), document, 0);
        }
        catch (Exception exception) {
            Main.error(exception);
        }
        this.help.setDocument(document);
    }

    public String getUrl() {
        return this.url;
    }

    protected void handleMissingHelpContent(String string) {
        String string2 = I18n.tr("<html><p class=\"warning-header\">Help content for help topic missing</p><p class=\"warning-body\">Help content for the help topic <strong>{0}</strong> is not available yet. It is missing both in your local language ({1}) and in English.<br><br>Please help to improve the JOSM help system and fill in the missing information. You can both edit the <a href=\"{2}\">help topic in your local language ({1})</a> and the <a href=\"{3}\">help topic in English</a>.</p></html>", string, Locale.getDefault().getDisplayName(), HelpUtil.getHelpTopicEditUrl(HelpUtil.buildAbsoluteHelpTopic(string, LanguageInfo.LocaleType.DEFAULT)), HelpUtil.getHelpTopicEditUrl(HelpUtil.buildAbsoluteHelpTopic(string, LanguageInfo.LocaleType.ENGLISH)));
        this.loadTopic(string2);
    }

    protected void handleHelpContentReaderException(String string, HelpContentReaderException helpContentReaderException) {
        String string2 = I18n.tr("<html><p class=\"error-header\">Error when retrieving help information</p><p class=\"error-body\">The content for the help topic <strong>{0}</strong> could not be loaded. The error message is (untranslated):<br><tt>{1}</tt></p></html>", string, helpContentReaderException.toString());
        this.loadTopic(string2);
    }

    protected void loadRelativeHelpTopic(String string) {
        String string2 = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(string, LanguageInfo.LocaleType.DEFAULTNOTENGLISH));
        String string3 = null;
        try {
            string3 = this.reader.fetchHelpTopicContent(string2, true);
        }
        catch (MissingHelpContentException missingHelpContentException) {
            string2 = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(string, LanguageInfo.LocaleType.BASELANGUAGE));
            try {
                string3 = this.reader.fetchHelpTopicContent(string2, true);
            }
            catch (MissingHelpContentException missingHelpContentException2) {
                string2 = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(string, LanguageInfo.LocaleType.ENGLISH));
                try {
                    string3 = this.reader.fetchHelpTopicContent(string2, true);
                }
                catch (MissingHelpContentException missingHelpContentException3) {
                    this.url = string2;
                    this.handleMissingHelpContent(string);
                    return;
                }
                catch (HelpContentReaderException helpContentReaderException) {
                    Main.error(helpContentReaderException);
                    this.handleHelpContentReaderException(string, helpContentReaderException);
                    return;
                }
            }
            catch (HelpContentReaderException helpContentReaderException) {
                Main.error(helpContentReaderException);
                this.handleHelpContentReaderException(string, helpContentReaderException);
                return;
            }
        }
        catch (HelpContentReaderException helpContentReaderException) {
            Main.error(helpContentReaderException);
            this.handleHelpContentReaderException(string, helpContentReaderException);
            return;
        }
        this.loadTopic(string3);
        this.history.setCurrentUrl(string2);
        this.url = string2;
    }

    protected void loadAbsoluteHelpTopic(String string) {
        String string2 = HelpUtil.getHelpTopicUrl(string);
        String string3 = null;
        try {
            string3 = this.reader.fetchHelpTopicContent(string2, true);
        }
        catch (MissingHelpContentException missingHelpContentException) {
            this.url = string2;
            this.handleMissingHelpContent(string);
            return;
        }
        catch (HelpContentReaderException helpContentReaderException) {
            Main.error(helpContentReaderException);
            this.handleHelpContentReaderException(string, helpContentReaderException);
            return;
        }
        this.loadTopic(string3);
        this.history.setCurrentUrl(string2);
        this.url = string2;
    }

    public void openUrl(String string) {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.toFront();
        } else {
            this.toFront();
        }
        String string2 = HelpUtil.extractAbsoluteHelpTopic(string);
        if (string2 == null) {
            try {
                this.url = string;
                String string3 = this.reader.fetchHelpTopicContent(string, false);
                this.loadTopic(string3);
                this.history.setCurrentUrl(string);
                this.url = string;
            }
            catch (Exception exception) {
                Main.warn(exception);
                HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>Failed to open help page for url {0}.<br>This is most likely due to a network problem, please check<br>your internet connection</html>", string), I18n.tr("Failed to open URL", new Object[0]), 0, null, null, null, null);
            }
            this.history.setCurrentUrl(string);
        } else {
            this.loadAbsoluteHelpTopic(string2);
        }
    }

    public void openHelpTopic(String string) {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.toFront();
        } else {
            this.toFront();
        }
        this.loadRelativeHelpTopic(string);
    }

    static {
        focusAction = new JosmAction(I18n.tr("JOSM Help Browser", new Object[0]), "help", "", null, false, false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.getInstance().setVisible(true);
            }
        };
    }

    class HyperlinkHandler
    implements HyperlinkListener {
        HyperlinkHandler() {
        }

        protected boolean scrollToElementWithId(String string) {
            Document document = HelpBrowser.this.help.getDocument();
            if (document instanceof HTMLDocument) {
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                Element element = hTMLDocument.getElement(string);
                try {
                    Rectangle rectangle = HelpBrowser.this.help.modelToView(element.getStartOffset());
                    if (rectangle != null) {
                        Rectangle rectangle2 = HelpBrowser.this.help.getVisibleRect();
                        rectangle.height = rectangle2.height;
                        HelpBrowser.this.help.scrollRectToVisible(rectangle);
                        return true;
                    }
                }
                catch (BadLocationException badLocationException) {
                    Main.warn(I18n.tr("Bad location in HTML document. Exception was: {0}", badLocationException.toString()));
                    Main.error(badLocationException);
                }
            }
            return false;
        }

        protected String getUrlFragment(HyperlinkEvent hyperlinkEvent) {
            AttributeSet attributeSet = hyperlinkEvent.getSourceElement().getAttributes();
            Object object = attributeSet.getAttribute(HTML.Tag.A);
            if (!(object instanceof SimpleAttributeSet)) {
                return null;
            }
            SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)object;
            if ((object = simpleAttributeSet.getAttribute(HTML.Attribute.HREF)) == null) {
                return null;
            }
            String string = (String)object;
            if (string.matches("#.*")) {
                return string.substring(1);
            }
            return null;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (hyperlinkEvent.getURL() == null || hyperlinkEvent.getURL().toString().startsWith(HelpBrowser.this.url + '#')) {
                String string = this.getUrlFragment(hyperlinkEvent);
                if (string != null) {
                    if (!this.scrollToElementWithId(string)) {
                        HelpBrowser.this.help.scrollToReference(string);
                    }
                } else {
                    HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("Failed to open help page. The target URL is empty.", new Object[0]), I18n.tr("Failed to open help page", new Object[0]), 0, null, null, null, null);
                }
            } else if (hyperlinkEvent.getURL().toString().endsWith("action=edit")) {
                OpenBrowser.displayUrl(hyperlinkEvent.getURL().toString());
            } else {
                HelpBrowser.this.url = hyperlinkEvent.getURL().toString();
                HelpBrowser.this.openUrl(hyperlinkEvent.getURL().toString());
            }
        }
    }

    class HomeAction
    extends AbstractAction {
        HomeAction() {
            this.putValue("ShortDescription", I18n.tr("Go to the JOSM help home page", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help", "home"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowser.this.openHelpTopic("/");
        }
    }

    static class ForwardAction
    extends AbstractAction
    implements Observer {
        private final transient HelpBrowserHistory history;

        ForwardAction(HelpBrowserHistory helpBrowserHistory) {
            this.history = helpBrowserHistory;
            helpBrowserHistory.addObserver(this);
            this.putValue("ShortDescription", I18n.tr("Go to the next page", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help", "next"));
            this.setEnabled(helpBrowserHistory.canGoForward());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.history.forward();
        }

        @Override
        public void update(Observable observable, Object object) {
            this.setEnabled(this.history.canGoForward());
        }
    }

    static class BackAction
    extends AbstractAction
    implements Observer {
        private final transient HelpBrowserHistory history;

        BackAction(HelpBrowserHistory helpBrowserHistory) {
            this.history = helpBrowserHistory;
            helpBrowserHistory.addObserver(this);
            this.putValue("ShortDescription", I18n.tr("Go to the previous page", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help", "previous"));
            this.setEnabled(helpBrowserHistory.canGoBack());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.history.back();
        }

        @Override
        public void update(Observable observable, Object object) {
            this.setEnabled(this.history.canGoBack());
        }
    }

    class ReloadAction
    extends AbstractAction {
        ReloadAction() {
            this.putValue("ShortDescription", I18n.tr("Reload the current help page", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowser.this.openUrl(HelpBrowser.this.getUrl());
        }
    }

    class EditAction
    extends AbstractAction {
        EditAction() {
            this.putValue("ShortDescription", I18n.tr("Edit the current help page", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = HelpBrowser.this.getUrl();
            if (string == null) {
                return;
            }
            if (!string.startsWith(HelpUtil.getWikiBaseHelpUrl())) {
                String string2 = I18n.tr("<html>The current URL <tt>{0}</tt><br>is an external URL. Editing is only possible for help topics<br>on the help server <tt>{1}</tt>.</html>", HelpBrowser.this.getUrl(), HelpUtil.getWikiBaseUrl());
                JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            string = string.replaceAll("#[^#]*$", "");
            OpenBrowser.displayUrl(string + "?action=edit");
        }
    }

    class OpenInBrowserAction
    extends AbstractAction {
        OpenInBrowserAction() {
            this.putValue("ShortDescription", I18n.tr("Open the current help page in an external browser", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help", "internet"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OpenBrowser.displayUrl(HelpBrowser.this.getUrl());
        }
    }
}

