/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.proj.Proj;

public abstract class AbstractProjection
implements Projection {
    protected Ellipsoid ellps;
    protected Datum datum;
    protected Proj proj;
    protected double x0;
    protected double y0;
    protected double lon0;
    protected double pm;
    protected double k0 = 1.0;
    private volatile ProjectionBounds projectionBoundsBox;

    public final Ellipsoid getEllipsoid() {
        return this.ellps;
    }

    public final Datum getDatum() {
        return this.datum;
    }

    public final Proj getProj() {
        return this.proj;
    }

    public final double getFalseEasting() {
        return this.x0;
    }

    public final double getFalseNorthing() {
        return this.y0;
    }

    public final double getCentralMeridian() {
        return this.lon0;
    }

    public final double getScaleFactor() {
        return this.k0;
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon latLon) {
        latLon = this.datum.fromWGS84(latLon);
        double[] dArray = this.proj.project(Math.toRadians(latLon.lat()), Math.toRadians(latLon.lon() - this.lon0 - this.pm));
        return new EastNorth(this.ellps.a * this.k0 * dArray[0] + this.x0, this.ellps.a * this.k0 * dArray[1] + this.y0);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        double[] dArray = this.proj.invproject((eastNorth.east() - this.x0) / this.ellps.a / this.k0, (eastNorth.north() - this.y0) / this.ellps.a / this.k0);
        LatLon latLon = new LatLon(Math.toDegrees(dArray[0]), Math.toDegrees(dArray[1]) + this.lon0 + this.pm);
        return this.datum.toWGS84(latLon);
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0;
    }

    public abstract Integer getEpsgCode();

    @Override
    public String toCode() {
        return "EPSG:" + this.getEpsgCode();
    }

    protected static final double convertMinuteSecond(double d, double d2) {
        return d / 60.0 + d2 / 3600.0;
    }

    protected static final double convertDegreeMinuteSecond(double d, double d2, double d3) {
        return d + d2 / 60.0 + d3 / 3600.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ProjectionBounds getWorldBoundsBoxEastNorth() {
        ProjectionBounds projectionBounds = this.projectionBoundsBox;
        if (projectionBounds == null) {
            AbstractProjection abstractProjection = this;
            synchronized (abstractProjection) {
                projectionBounds = this.projectionBoundsBox;
                if (projectionBounds == null) {
                    double d;
                    Bounds bounds = this.getWorldBoundsLatLon();
                    projectionBounds = new ProjectionBounds(this.latlon2eastNorth(bounds.getMin()));
                    projectionBounds.extend(this.latlon2eastNorth(bounds.getMax()));
                    projectionBounds.extend(this.latlon2eastNorth(new LatLon(bounds.getMinLat(), bounds.getMaxLon())));
                    projectionBounds.extend(this.latlon2eastNorth(new LatLon(bounds.getMaxLat(), bounds.getMinLon())));
                    double d2 = (bounds.getMaxLon() - bounds.getMinLon()) / 1000.0;
                    double d3 = (bounds.getMaxLat() - bounds.getMinLat()) / 1000.0;
                    for (d = bounds.getMinLon(); d < bounds.getMaxLon(); d += d2) {
                        projectionBounds.extend(this.latlon2eastNorth(new LatLon(bounds.getMinLat(), d)));
                        projectionBounds.extend(this.latlon2eastNorth(new LatLon(bounds.getMaxLat(), d)));
                    }
                    for (d = bounds.getMinLat(); d < bounds.getMaxLat(); d += d3) {
                        projectionBounds.extend(this.latlon2eastNorth(new LatLon(d, bounds.getMinLon())));
                        projectionBounds.extend(this.latlon2eastNorth(new LatLon(d, bounds.getMaxLon())));
                    }
                    this.projectionBoundsBox = projectionBounds;
                }
            }
        }
        return this.projectionBoundsBox;
    }
}

