/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class UndoRedoHandler
implements MapView.LayerChangeListener {
    public final LinkedList<Command> commands = new LinkedList();
    public final LinkedList<Command> redoCommands = new LinkedList();
    private final LinkedList<OsmDataLayer.CommandQueueListener> listenerCommands = new LinkedList();

    public UndoRedoHandler() {
        MapView.addLayerChangeListener(this);
    }

    public void addNoRedraw(Command command) {
        CheckParameterUtil.ensureParameterNotNull(command, "c");
        command.executeCommand();
        this.commands.add(command);
        if (this.commands.size() > Main.pref.getInteger("undo.max", 1000)) {
            this.commands.removeFirst();
        }
        this.redoCommands.clear();
    }

    public void afterAdd() {
        this.fireCommandsChanged();
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet != null) {
            dataSet.fireSelectionChanged();
        }
    }

    public synchronized void add(Command command) {
        this.addNoRedraw(command);
        this.afterAdd();
    }

    public void undo() {
        this.undo(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undo(int n) {
        if (this.commands.isEmpty()) {
            return;
        }
        Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
        Main.main.getCurrentDataSet().beginUpdate();
        try {
            for (int i = 1; i <= n; ++i) {
                Command command = this.commands.removeLast();
                command.undoCommand();
                this.redoCommands.addFirst(command);
                if (!this.commands.isEmpty()) continue;
                break;
            }
        }
        finally {
            Main.main.getCurrentDataSet().endUpdate();
        }
        this.fireCommandsChanged();
        Collection<OsmPrimitive> collection2 = Main.main.getCurrentDataSet().getSelected();
        if (!collection.equals(collection2)) {
            Main.main.getCurrentDataSet().fireSelectionChanged();
        }
    }

    public void redo() {
        this.redo(1);
    }

    public void redo(int n) {
        if (this.redoCommands.isEmpty()) {
            return;
        }
        Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
        for (int i = 0; i < n; ++i) {
            Command command = this.redoCommands.removeFirst();
            command.executeCommand();
            this.commands.add(command);
            if (this.redoCommands.isEmpty()) break;
        }
        this.fireCommandsChanged();
        Collection<OsmPrimitive> collection2 = Main.main.getCurrentDataSet().getSelected();
        if (!collection.equals(collection2)) {
            Main.main.getCurrentDataSet().fireSelectionChanged();
        }
    }

    public void fireCommandsChanged() {
        for (OsmDataLayer.CommandQueueListener commandQueueListener : this.listenerCommands) {
            commandQueueListener.commandChanged(this.commands.size(), this.redoCommands.size());
        }
    }

    public void clean() {
        this.redoCommands.clear();
        this.commands.clear();
        this.fireCommandsChanged();
    }

    public void clean(Layer layer) {
        if (layer == null) {
            return;
        }
        boolean bl = false;
        Iterator iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            if (!((Command)iterator.next()).invalidBecauselayerRemoved(layer)) continue;
            iterator.remove();
            bl = true;
        }
        iterator = this.redoCommands.iterator();
        while (iterator.hasNext()) {
            if (!((Command)iterator.next()).invalidBecauselayerRemoved(layer)) continue;
            iterator.remove();
            bl = true;
        }
        if (bl) {
            this.fireCommandsChanged();
        }
    }

    @Override
    public void layerRemoved(Layer layer) {
        this.clean(layer);
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    public void removeCommandQueueListener(OsmDataLayer.CommandQueueListener commandQueueListener) {
        this.listenerCommands.remove(commandQueueListener);
    }

    public boolean addCommandQueueListener(OsmDataLayer.CommandQueueListener commandQueueListener) {
        return this.listenerCommands.add(commandQueueListener);
    }
}

